/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.drippyloadingscreen.customization.rendering.SimpleTextRenderer;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public class WebStringCustomizationItem
extends CustomizationItemBase {
    public volatile Map<String, Float> lines = new LinkedHashMap<String, Float>();
    private volatile boolean updating = false;
    public boolean multiline = false;
    public boolean shadow = false;
    public float scale = 1.0f;
    public CustomizationItemBase.Alignment alignment = CustomizationItemBase.Alignment.LEFT;
    public String rawURL = "";
    protected volatile int unscaledHeight = 1;
    protected volatile int unscaledWidth = 1;
    public Color textColor = Color.WHITE;
    public String textColorHex = "#ffffff";

    public WebStringCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addwebtext")) {
            String al;
            String sc;
            String sh;
            String multi;
            String tc;
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.rawURL = this.value;
                this.value = PlaceholderTextValueHelper.convertFromRaw(this.value);
            }
            if ((tc = item.getEntryValue("textcolor")) != null) {
                this.textColorHex = tc;
                this.textColor = RenderUtils.getColorFromHexString((String)tc);
            }
            if ((multi = item.getEntryValue("multiline")) != null && multi.equalsIgnoreCase("true")) {
                this.multiline = true;
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("true")) {
                this.shadow = true;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            if ((al = item.getEntryValue("alignment")) != null) {
                if (al.equalsIgnoreCase("right")) {
                    this.alignment = CustomizationItemBase.Alignment.RIGHT;
                }
                if (al.equalsIgnoreCase("centered")) {
                    this.alignment = CustomizationItemBase.Alignment.CENTERED;
                }
            }
            this.updateContent(this.value);
        }
    }

    @Override
    public void render(PoseStack matrix) {
        if (!this.shouldRender()) {
            return;
        }
        if (!this.updating) {
            RenderSystem.m_69478_();
            this.width = (int)((float)this.unscaledWidth * this.scale);
            this.height = (int)((float)this.unscaledHeight * this.scale);
            int i = 0;
            for (Map.Entry<String, Float> m : this.lines.entrySet()) {
                float sc = this.scale * m.getValue().floatValue();
                int x = this.getPosX();
                int y = this.getPosY();
                int stringwidth = (int)((float)SimpleTextRenderer.getStringWidth(m.getKey()) * sc);
                if (this.alignment == CustomizationItemBase.Alignment.RIGHT) {
                    x += this.width - stringwidth;
                }
                if (this.alignment == CustomizationItemBase.Alignment.CENTERED) {
                    x += (this.width - stringwidth) / 2;
                }
                String line = "";
                line = WebStringCustomizationItem.isEditorActive() ? StringUtils.convertFormatCodes((String)m.getKey(), (String)"&", (String)"\u00a7") : PlaceholderTextValueHelper.convertFromRaw(m.getKey());
                if (this.shadow) {
                    SimpleTextRenderer.drawStringWithShadow(matrix, line, x, y + i, this.textColor.getRGB(), this.opacity, sc);
                } else {
                    SimpleTextRenderer.drawString(matrix, line, x, y + i, this.textColor.getRGB(), this.opacity, sc);
                }
                i = (int)((float)i + 10.0f * sc);
            }
            RenderSystem.m_69461_();
        }
    }

    @Override
    public boolean shouldRender() {
        if (this.lines == null || this.lines.isEmpty()) {
            return false;
        }
        return super.shouldRender();
    }

    public void updateContent(final String url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebStringCustomizationItem.this.updating = true;
                String old = WebStringCustomizationItem.this.value;
                int w = 1;
                int h = 1;
                WebStringCustomizationItem.this.value = url;
                if (WebStringCustomizationItem.this.isValidUrl()) {
                    String path;
                    if (WebStringCustomizationItem.this.value.toLowerCase().contains("/blob/") && (WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://github.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://github.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://www.github.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://www.github.com/"))) {
                        path = WebStringCustomizationItem.this.value.replace("//", "").split("/", 2)[1].replace("/blob/", "/");
                        WebStringCustomizationItem.this.value = "https://raw.githubusercontent.com/" + path;
                    }
                    if (!WebStringCustomizationItem.this.value.toLowerCase().contains("/raw/") && (WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://pastebin.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://pastebin.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://www.pastebin.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://www.pastebin.com/"))) {
                        path = WebStringCustomizationItem.this.value.replace("//", "").split("/", 2)[1];
                        WebStringCustomizationItem.this.value = "https://pastebin.com/raw/" + path;
                    }
                    try {
                        WebStringCustomizationItem.this.lines.clear();
                        URL u = new URL(WebStringCustomizationItem.this.value);
                        BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8));
                        String s = r.readLine();
                        while (s != null) {
                            float sc = WebStringCustomizationItem.getScaleMultiplicator(s);
                            int i = (int)((float)SimpleTextRenderer.getStringWidth(s = WebStringCustomizationItem.getWithoutHeadlineCodes(s)) * sc);
                            if (i > w) {
                                w = i;
                            }
                            h = (int)((float)h + 10.0f * sc);
                            WebStringCustomizationItem.this.lines.put(s, Float.valueOf(sc));
                            if (!WebStringCustomizationItem.this.multiline) break;
                            s = r.readLine();
                        }
                        r.close();
                        WebStringCustomizationItem.this.unscaledWidth = w;
                        WebStringCustomizationItem.this.unscaledHeight = h;
                    }
                    catch (Exception e) {
                        WebStringCustomizationItem.this.lines.clear();
                        String s = Locals.localize((String)"drippyloadingscreen.customization.items.webstring.unabletoload", (String[])new String[0]);
                        WebStringCustomizationItem.this.lines.put(s, Float.valueOf(1.0f));
                        WebStringCustomizationItem.this.unscaledWidth = SimpleTextRenderer.getStringWidth(s);
                        WebStringCustomizationItem.this.unscaledHeight = 10;
                        e.printStackTrace();
                    }
                } else {
                    WebStringCustomizationItem.this.lines.clear();
                    String s = Locals.localize((String)"drippyloadingscreen.customization.items.webstring.unabletoload", (String[])new String[0]);
                    WebStringCustomizationItem.this.lines.put(s, Float.valueOf(1.0f));
                    WebStringCustomizationItem.this.unscaledWidth = SimpleTextRenderer.getStringWidth(s);
                    WebStringCustomizationItem.this.unscaledHeight = 10;
                    System.out.println("########################## ERROR ##########################");
                    System.out.println("[FM] Cannot load text content from " + WebStringCustomizationItem.this.value + "! Invalid URL!");
                    System.out.println("###########################################################");
                    WebStringCustomizationItem.this.value = old;
                }
                WebStringCustomizationItem.this.updating = false;
            }
        }).start();
    }

    protected static float getScaleMultiplicator(String s) {
        if (s.startsWith("### ")) {
            return 1.1f;
        }
        if (s.startsWith("## ")) {
            return 1.3f;
        }
        if (s.startsWith("# ")) {
            return 1.5f;
        }
        return 1.0f;
    }

    protected static String getWithoutHeadlineCodes(String s) {
        if (s.startsWith("### ")) {
            return s.substring(4);
        }
        if (s.startsWith("## ")) {
            return s.substring(3);
        }
        if (s.startsWith("# ")) {
            return s.substring(2);
        }
        return s;
    }

    private boolean isValidUrl() {
        if (this.value == null || !this.value.startsWith("http://") && !this.value.startsWith("https://")) {
            return false;
        }
        try {
            URL url = new URL(this.value);
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setRequestMethod("HEAD");
            int r = c.getResponseCode();
            if (r == 200) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Trying alternative method to check for existing url..");
            try {
                URL url = new URL(this.value);
                HttpURLConnection c = (HttpURLConnection)url.openConnection();
                int r = c.getResponseCode();
                if (r == 200) {
                    return true;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return false;
    }
}

