/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.handlers;

import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.MCFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.createtweaker.CreateTweaker;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;

@IRecipeHandler.For(value=MixingRecipe.class)
public class MixingRecipeHandler
implements IRecipeHandler<MixingRecipe> {
    public String dumpToCommandString(IRecipeManager iRecipeManager, MixingRecipe recipe) {
        Either result = !recipe.getFluidResults().isEmpty() ? Either.right((Object)new MCFluidStack((FluidStack)recipe.getFluidResults().get(0))) : Either.left(recipe.getRollableResults().stream().map(CreateTweaker::mapProcessingResult));
        return String.format("<recipetype:create:mixing>.addRecipe(\"%s\", <constant:create:heat_condition:%s>, [%s], [%s], [%s], [%s]);", recipe.m_6423_(), recipe.getRequiredHeat().name().toLowerCase(Locale.ENGLISH), result.map(results -> results.map(Percentaged::getCommandString).collect(Collectors.joining(", ")), CommandStringDisplayable::getCommandString), recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ")), recipe.getFluidIngredients().stream().flatMap(fluidIngredient -> fluidIngredient.getMatchingFluidStacks().stream()).map(fluidStack -> new MCFluidStack(fluidStack).getCommandString()).collect(Collectors.joining(", ")), recipe.getFluidResults().stream().map(MCFluidStack::new).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(", ")));
    }

    public Optional<Function<ResourceLocation, MixingRecipe>> replaceIngredients(IRecipeManager manager, MixingRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList((NonNullList)recipe.m_7527_(), Ingredient.class, (Recipe)recipe, rules, newIngredients -> id -> {
            ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(((ProcessingRecipeSerializer)AllRecipeTypes.MIXING.getSerializer()).getFactory(), id);
            builder.withItemOutputs((ProcessingOutput[])recipe.getRollableResults().toArray(ProcessingOutput[]::new));
            builder.withItemIngredients(newIngredients);
            builder.withFluidIngredients(recipe.getFluidIngredients());
            builder.requiresHeat(recipe.getRequiredHeat());
            builder.duration(recipe.getProcessingDuration());
            return (MixingRecipe)builder.build();
        });
    }
}

