/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.InvalidLauncherSetupException;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.NameMappingServiceHandler;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.TransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ITransformerDiscoveryService;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.lang.module.Configuration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

class TransformationServicesHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<String, TransformationServiceDecorator> serviceLookup;
    private final TransformStore transformStore;
    private final ModuleLayerHandler layerHandler;

    TransformationServicesHandler(TransformStore transformStore, ModuleLayerHandler layerHandler) {
        this.transformStore = transformStore;
        this.layerHandler = layerHandler;
    }

    List<ITransformationService.Resource> initializeTransformationServices(ArgumentHandler argumentHandler, Environment environment, NameMappingServiceHandler nameMappingServiceHandler) {
        this.loadTransformationServices(environment);
        this.validateTransformationServices();
        this.processArguments(argumentHandler, environment);
        this.initialiseTransformationServices(environment);
        environment.computePropertyIfAbsent(IEnvironment.Keys.NAMING.get(), a -> "mojang");
        nameMappingServiceHandler.bindNamingServices(environment.getProperty(IEnvironment.Keys.NAMING.get()).orElse("mojang"));
        return this.runScanningTransformationServices(environment);
    }

    TransformingClassLoader buildTransformingClassLoader(LaunchPluginHandler pluginHandler, TransformingClassLoaderBuilder builder, Environment environment, ModuleLayerHandler layerHandler) {
        List classLocatorList = this.serviceLookup.values().stream().map(TransformationServiceDecorator::getClassLoader).filter(Objects::nonNull).collect(Collectors.toList());
        ModuleLayerHandler.LayerInfo layerInfo = layerHandler.buildLayer(IModuleLayerManager.Layer.GAME, (cf, parents) -> new TransformingClassLoader(this.transformStore, pluginHandler, builder, environment, (Configuration)cf, (List<ModuleLayer>)parents));
        layerHandler.updateLayer(IModuleLayerManager.Layer.PLUGIN, li -> li.cl().setFallbackClassLoader((ClassLoader)layerInfo.cl()));
        return (TransformingClassLoader)layerInfo.cl();
    }

    private void processArguments(ArgumentHandler argumentHandler, Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Configuring option handling for services");
        argumentHandler.processArguments(environment, this::computeArgumentsForServices, this::offerArgumentResultsToServices);
    }

    private void computeArgumentsForServices(OptionParser parser) {
        this.serviceLookup.values().stream().map(TransformationServiceDecorator::getService).forEach(service -> service.arguments((a, b) -> parser.accepts(service.name() + "." + a, b)));
    }

    private void offerArgumentResultsToServices(OptionSet optionSet, BiFunction<String, OptionSet, ITransformationService.OptionResult> resultHandler) {
        this.serviceLookup.values().stream().map(TransformationServiceDecorator::getService).forEach(service -> service.argumentValues((ITransformationService.OptionResult)resultHandler.apply(service.name(), optionSet)));
    }

    void initialiseServiceTransformers() {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services loading transformers");
        this.serviceLookup.values().forEach(s -> s.gatherTransformers(this.transformStore));
    }

    private void initialiseTransformationServices(Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services initializing");
        this.serviceLookup.values().forEach(s -> s.onInitialize(environment));
    }

    private List<ITransformationService.Resource> runScanningTransformationServices(Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services begin scanning");
        return this.serviceLookup.values().stream().map(s -> s.runScan(environment)).mapMulti(Iterable::forEach).toList();
    }

    private void validateTransformationServices() {
        if (this.serviceLookup.values().stream().filter(d -> !d.isValid()).count() > 0L) {
            List services = this.serviceLookup.values().stream().filter(d -> !d.isValid()).map(TransformationServiceDecorator::getService).collect(Collectors.toList());
            String names = services.stream().map(ITransformationService::name).collect(Collectors.joining(","));
            LOGGER.error(LogMarkers.MODLAUNCHER, "Found {} services that failed to load : [{}]", (Object)services.size(), (Object)names);
            throw new InvalidLauncherSetupException("Invalid Services found " + names);
        }
    }

    private void loadTransformationServices(Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services loading");
        this.serviceLookup.values().forEach(s -> s.onLoad(environment, this.serviceLookup.keySet()));
    }

    void discoverServices(ArgumentHandler.DiscoveryData discoveryData) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Discovering transformation services");
        ModuleLayer bootLayer = this.layerHandler.getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow();
        List additionalPaths = ServiceLoaderUtils.streamServiceLoader(() -> ServiceLoader.load(bootLayer, ITransformerDiscoveryService.class), sce -> LOGGER.fatal(LogMarkers.MODLAUNCHER, "Encountered serious error loading transformation discoverer, expect problems", (Throwable)sce)).map(s -> s.candidates(discoveryData.gameDir(), discoveryData.launchTarget())).mapMulti(Iterable::forEach).toList();
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found additional transformation services from discovery services: {}", new Supplier[]{() -> additionalPaths.stream().map(ap -> Arrays.toString(ap.paths()))});
        additionalPaths.forEach(np -> this.layerHandler.addToLayer(IModuleLayerManager.Layer.SERVICE, (NamedPath)np));
        ModuleLayerHandler.LayerInfo serviceLayer = this.layerHandler.buildLayer(IModuleLayerManager.Layer.SERVICE);
        this.serviceLookup = ServiceLoaderUtils.streamServiceLoader(() -> ServiceLoader.load(serviceLayer.layer(), ITransformationService.class), sce -> LOGGER.fatal(LogMarkers.MODLAUNCHER, "Encountered serious error loading transformation service, expect problems", (Throwable)sce)).collect(Collectors.toMap(ITransformationService::name, TransformationServiceDecorator::new));
        List<Map> modlist = this.serviceLookup.entrySet().stream().map(e -> Map.of("name", (String)e.getKey(), "type", "TRANSFORMATIONSERVICE", "file", ServiceLoaderUtils.fileNameFor(((TransformationServiceDecorator)e.getValue()).getClass()))).toList();
        Launcher.INSTANCE.environment().getProperty(IEnvironment.Keys.MODLIST.get()).ifPresent(ml -> ml.addAll(modlist));
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found transformer services : [{}]", new Supplier[]{() -> String.join((CharSequence)",", this.serviceLookup.keySet())});
    }

    public List<ITransformationService.Resource> triggerScanCompletion(IModuleLayerManager moduleLayerManager) {
        return this.serviceLookup.values().stream().map(tsd -> tsd.onCompleteScan(moduleLayerManager)).mapMulti(Iterable::forEach).toList();
    }
}

