/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelResource;
import org.lwjgl.opengl.GL11;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.MapLimiter;
import xaero.map.MapRunner;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BiomeGetter;
import xaero.map.biome.BlockTintProvider;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.cache.BrokenBlockTintCache;
import xaero.map.controls.ControlsRegister;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.RegionDetection;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.graphics.CustomVertexConsumers;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.TextureUploader;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.gui.message.MessageBox;
import xaero.map.gui.message.render.MessageBoxRenderer;
import xaero.map.highlight.DimensionHighlighterHandler;
import xaero.map.highlight.HighlighterRegistry;
import xaero.map.highlight.MapRegionHighlightsPreparer;
import xaero.map.mcworld.WorldMapClientWorldData;
import xaero.map.mcworld.WorldMapClientWorldDataHelper;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.pool.MapTilePool;
import xaero.map.region.LeveledRegion;
import xaero.map.region.LeveledRegionManager;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;
import xaero.map.region.texture.BranchTextureRenderer;
import xaero.map.region.texture.RegionTexture;
import xaero.map.task.MapRunnerTask;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapProcessor {
    public static final int DEFAULT_LIGHT_LEVELS = 4;
    private MapSaveLoad mapSaveLoad;
    private MapWriter mapWriter;
    private MapLimiter mapLimiter;
    private WorldDataHandler worldDataHandler;
    private ByteBufferDeallocator bufferDeallocator;
    private TextureUploader textureUploader;
    private BranchTextureRenderer branchTextureRenderer;
    private BiomeColorCalculator biomeColorCalculator;
    private final BlockStateShortShapeCache blockStateShortShapeCache;
    private final BiomeGetter biomeGetter;
    private final BrokenBlockTintCache brokenBlockTintCache;
    private final MapRegionHighlightsPreparer mapRegionHighlightsPreparer;
    private ClientLevel world;
    public Registry<Biome> worldBiomeRegistry;
    private BlockTintProvider worldBlockTintProvider;
    private ClientLevel newWorld;
    public Registry<Biome> newWorldBiomeRegistry;
    public final Object mainStuffSync;
    public ClientLevel mainWorld;
    public Registry<Biome> mainWorldBiomeRegistry;
    public double mainPlayerX;
    public double mainPlayerY;
    public double mainPlayerZ;
    private boolean mainWorldUnloaded;
    private ArrayList<Double[]> footprints = new ArrayList();
    private int footprintsTimer;
    private boolean mapWorldUsable;
    private MapWorld mapWorld;
    private String currentWorldId;
    private String currentDimId;
    private String currentMWId;
    private FileLock mapLockToRelease;
    private FileChannel mapLockChannelToClose;
    private FileChannel currentMapLockChannel;
    private FileLock currentMapLock;
    private boolean mapWorldUsableRequest;
    private boolean caveStartDetermined;
    private int caveStart;
    public final Object renderThreadPauseSync = new Object();
    private int pauseUploading;
    private int pauseRendering;
    private int pauseWriting;
    public final Object processorThreadPauseSync = new Object();
    private int pauseProcessing;
    private final Object loadingSync = new Object();
    private boolean isLoading;
    public final Object uiSync = new Object();
    private boolean waitingForWorldUpdate;
    public final Object uiPauseSync = new Object();
    private boolean isUIPaused;
    private ArrayList<LeveledRegion<?>>[] toProcessLevels;
    private ArrayList<MapRegion> toRefresh = new ArrayList();
    private static final int SPAWNPOINT_TIMEOUT = 3000;
    private BlockPos spawnToRestore;
    private long mainWorldChangedTime = -1L;
    private MapTilePool tilePool;
    private int firstBranchLevel;
    private long lastRenderProcessTime = -1L;
    private int workingFramesCount;
    public long freeFramePeriod = -1L;
    private int testingFreeFrame = 1;
    private MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers;
    private CustomVertexConsumers cvc;
    private final MessageBox messageBox;
    private final MessageBoxRenderer messageBoxRenderer;
    private boolean currentMapNeedsDeletion;
    private OverlayManager overlayManager;
    private long renderStartTime;
    private Field scheduledTasksField;
    private Runnable renderStartTimeUpdaterRunnable;
    private boolean finalizing;
    private int state;
    private HashSet<ResourceLocation> hardcodedNetherlike;
    private final HighlighterRegistry highlighterRegistry;
    private String[] dimensionsToIgnore = new String[]{"FZHammer"};
    public Field selectedField = null;

    public MapProcessor(MapSaveLoad mapSaveLoad, MapWriter mapWriter, MapLimiter mapLimiter, ByteBufferDeallocator bufferDeallocator, MapTilePool tilePool, OverlayManager overlayManager, TextureUploader textureUploader, WorldDataHandler worldDataHandler, BranchTextureRenderer branchTextureRenderer, MultiTextureRenderTypeRendererProvider mtrtrs, CustomVertexConsumers cvc, BiomeColorCalculator biomeColorCalculator, BlockStateShortShapeCache blockStateShortShapeCache, BiomeGetter biomeGetter, BrokenBlockTintCache brokenBlockTintCache, HighlighterRegistry highlighterRegistry, MapRegionHighlightsPreparer mapRegionHighlightsPreparer, MessageBox messageBox, MessageBoxRenderer messageBoxRenderer) throws NoSuchFieldException {
        this.branchTextureRenderer = branchTextureRenderer;
        this.mapSaveLoad = mapSaveLoad;
        this.mapWriter = mapWriter;
        this.mapLimiter = mapLimiter;
        this.bufferDeallocator = bufferDeallocator;
        this.tilePool = tilePool;
        this.overlayManager = overlayManager;
        this.textureUploader = textureUploader;
        this.worldDataHandler = worldDataHandler;
        try {
            this.scheduledTasksField = Minecraft.class.getDeclaredField("f_91023_");
        }
        catch (Exception e) {
            this.scheduledTasksField = Minecraft.class.getDeclaredField("progressTasks");
        }
        this.renderStartTimeUpdaterRunnable = new Runnable(){

            @Override
            public void run() {
                MapProcessor.this.updateRenderStartTime();
            }
        };
        this.mainStuffSync = new Object();
        this.caveStart = Short.MAX_VALUE;
        this.toProcessLevels = new ArrayList[4];
        for (int i = 0; i < this.toProcessLevels.length; ++i) {
            this.toProcessLevels[i] = new ArrayList();
        }
        this.multiTextureRenderTypeRenderers = mtrtrs;
        this.cvc = cvc;
        this.biomeColorCalculator = biomeColorCalculator;
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.hardcodedNetherlike = Sets.newHashSet((Object[])new ResourceLocation[]{DimensionType.f_63841_, new ResourceLocation("undergarden", "undergarden")});
        this.biomeGetter = biomeGetter;
        this.brokenBlockTintCache = brokenBlockTintCache;
        this.highlighterRegistry = highlighterRegistry;
        this.mapRegionHighlightsPreparer = mapRegionHighlightsPreparer;
        this.messageBox = messageBox;
        this.messageBoxRenderer = messageBoxRenderer;
    }

    public void onInit() {
        this.mapWorld = new MapWorld(this.getMainId(true), this.getMainId(false), this);
        this.mapWorld.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(MapRunner runner) {
        if (this.state < 2) {
            try {
                while (this.state < 2 && WorldMap.crashHandler.getCrashedBy() == null) {
                    Object object = this.processorThreadPauseSync;
                    synchronized (object) {
                        if (!this.isProcessingPaused()) {
                            this.updateWorld();
                            if (this.world != null) {
                                this.updateCaveStart(this.mainPlayerX, this.mainPlayerZ, (Level)this.world);
                                this.updateFootprints((Level)this.world, Minecraft.m_91087_().f_91080_ instanceof GuiMap ? 1 : 10);
                            }
                            if (this.mapWorldUsable) {
                                this.mapLimiter.applyLimit(this.mapWorld, this);
                                long currentTime = System.currentTimeMillis();
                                block11: for (int l = 0; l < this.toProcessLevels.length; ++l) {
                                    ArrayList<LeveledRegion<?>> regionsToProcess = this.toProcessLevels[l];
                                    for (int i = 0; i < regionsToProcess.size(); ++i) {
                                        LeveledRegion<?> leveledRegion;
                                        ArrayList<LeveledRegion<?>> arrayList = regionsToProcess;
                                        synchronized (arrayList) {
                                            if (i >= regionsToProcess.size()) {
                                                continue block11;
                                            }
                                            leveledRegion = regionsToProcess.get(i);
                                        }
                                        this.mapSaveLoad.updateSave(leveledRegion, currentTime);
                                    }
                                }
                            }
                            this.mapSaveLoad.run((Level)this.world, this.biomeGetter);
                            this.handleRefresh((Level)this.world);
                            runner.doTasks(this);
                            this.releaseLocksIfNeeded();
                        }
                    }
                    try {
                        Thread.sleep(this.world == null || Misc.screenShouldSkipWorldRender(Minecraft.m_91087_().f_91080_, true) || this.state > 0 ? 40L : 1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
            if (this.state < 2) {
                this.forceClean();
            }
        }
        if (this.state == 2) {
            this.state = 3;
        }
    }

    public int getDebugFPS(Minecraft mc) {
        int debugFPS;
        String fpsString = mc.f_90977_.split(" ")[0];
        try {
            debugFPS = Integer.parseInt(fpsString);
        }
        catch (NumberFormatException nfe) {
            if (fpsString.contains("/")) {
                debugFPS = Integer.parseInt(fpsString.split("/")[0]);
            }
            throw nfe;
        }
        return debugFPS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRenderProcess(Minecraft mc) throws RuntimeException {
        try {
            this.mapWriter.onRender(this.biomeColorCalculator, this.overlayManager);
            long renderProcessTime = System.nanoTime();
            if (this.testingFreeFrame == 1) {
                this.testingFreeFrame = 2;
            } else {
                Object object = this.renderThreadPauseSync;
                synchronized (object) {
                    if (this.lastRenderProcessTime == -1L) {
                        this.lastRenderProcessTime = renderProcessTime;
                    }
                    long sinceLastProcessTime = renderProcessTime - this.lastRenderProcessTime;
                    if (this.testingFreeFrame == 2) {
                        this.freeFramePeriod = sinceLastProcessTime;
                        this.testingFreeFrame = 0;
                    }
                    if (this.pauseUploading == 0 && this.mapWorldUsable && this.currentWorldId != null) {
                        boolean branchesCatchup;
                        while (GL11.glGetError() != 0) {
                        }
                        RenderSystem.m_69854_((int)3317, (int)4);
                        RenderSystem.m_69854_((int)3316, (int)0);
                        RenderSystem.m_69854_((int)3315, (int)0);
                        RenderSystem.m_69854_((int)3314, (int)0);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        DimensionHighlighterHandler highlighterHandler = this.mapWorld.getCurrentDimension().getHighlightHandler();
                        int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                        boolean detailedDebug = WorldMap.settings.detailed_debug;
                        long uploadStart = System.nanoTime();
                        long totalTime = Math.min(sinceLastProcessTime, this.freeFramePeriod);
                        long passed = uploadStart - this.renderStartTime;
                        long timeAvailable = Math.max(3000000L, totalTime - passed);
                        long uploadUntil = uploadStart + timeAvailable / 4L;
                        long gpuLimit = Minecraft.m_91087_().f_91080_ instanceof GuiMap ? Math.max(1000000L, totalTime * 5L / 12L) : Math.min(totalTime / 5L, timeAvailable);
                        boolean noLimits = false;
                        if (Minecraft.m_91087_().f_91080_ instanceof GuiMap) {
                            GuiMap guiMap = (GuiMap)Minecraft.m_91087_().f_91080_;
                            noLimits = guiMap.noUploadingLimits;
                            guiMap.noUploadingLimits = false;
                        }
                        int firstLevel = 0;
                        boolean bl = branchesCatchup = (int)(Math.random() * 5.0) == 0;
                        if (branchesCatchup) {
                            firstLevel = 1 + this.firstBranchLevel;
                        }
                        this.firstBranchLevel = (this.firstBranchLevel + 1) % (this.toProcessLevels.length - 1);
                        block15: for (int j = 0; j < this.toProcessLevels.length; ++j) {
                            int level = (firstLevel + j) % this.toProcessLevels.length;
                            ArrayList<LeveledRegion<?>> toProcess = this.toProcessLevels[level];
                            for (int i = 0; i < toProcess.size(); ++i) {
                                LeveledRegion<?> region;
                                Object object2 = toProcess;
                                synchronized (object2) {
                                    if (i >= toProcess.size()) {
                                        continue block15;
                                    }
                                    region = toProcess.get(i);
                                }
                                if (region == null) continue;
                                object2 = region;
                                synchronized (object2) {
                                    if (region.shouldBeProcessed()) {
                                        boolean cleanAndCacheRequestsBlocked = region.cleanAndCacheRequestsBlocked();
                                        boolean allCleaned = true;
                                        boolean allCached = true;
                                        boolean allUploaded = true;
                                        boolean hasLoadedTextures = false;
                                        for (int x = 0; x < 8; ++x) {
                                            for (int z = 0; z < 8; ++z) {
                                                Object texture = region.getTexture(x, z);
                                                if (texture == null) continue;
                                                if (((RegionTexture)texture).canUpload()) {
                                                    hasLoadedTextures = true;
                                                    if (noLimits || gpuLimit > 0L && System.nanoTime() < uploadUntil) {
                                                        ((RegionTexture)texture).preUpload(this, this.worldBlockTintProvider, this.overlayManager, region, detailedDebug, this.blockStateShortShapeCache);
                                                        if (((RegionTexture)texture).shouldUpload()) {
                                                            if (((RegionTexture)texture).getTimer() == 0) {
                                                                gpuLimit -= ((RegionTexture)texture).uploadBuffer(highlighterHandler, this.textureUploader, region, this.branchTextureRenderer, x, z);
                                                            } else {
                                                                ((RegionTexture)texture).decTimer();
                                                            }
                                                        }
                                                    }
                                                    ((RegionTexture)texture).postUpload(this, region, cleanAndCacheRequestsBlocked);
                                                }
                                                if (((RegionTexture)texture).hasSourceData()) {
                                                    allCleaned = false;
                                                }
                                                if (((RegionTexture)texture).shouldIncludeInCache() && !((RegionTexture)texture).isCachePrepared()) {
                                                    allCached = false;
                                                }
                                                if (((RegionTexture)texture).isUploaded()) continue;
                                                allUploaded = false;
                                            }
                                        }
                                        if (hasLoadedTextures) {
                                            region.processWhenLoadedChunksExist(globalRegionCacheHashCode);
                                        }
                                        allUploaded = allUploaded && region.isLoaded() && !cleanAndCacheRequestsBlocked;
                                        boolean bl2 = allCached = allCached && allUploaded;
                                        if ((!region.shouldCache() || !region.recacheHasBeenRequested()) && region.shouldEndProcessingAfterUpload() && allCleaned && allUploaded) {
                                            region.onProcessingEnd();
                                            region.deleteGLBuffers();
                                            ArrayList<LeveledRegion<?>> arrayList = toProcess;
                                            synchronized (arrayList) {
                                                if (i < toProcess.size()) {
                                                    toProcess.remove(i);
                                                    --i;
                                                }
                                            }
                                            if (WorldMap.settings.debug) {
                                                WorldMap.LOGGER.info("Region freed: " + region + " " + this.mapWriter.getUpdateCounter() + " " + this.currentWorldId + " " + this.currentDimId);
                                            }
                                        }
                                        if (allCached && !region.isAllCachePrepared()) {
                                            region.setAllCachePrepared(true);
                                        }
                                        if (region.shouldCache() && region.recacheHasBeenRequested() && region.isAllCachePrepared() && !cleanAndCacheRequestsBlocked) {
                                            this.getMapSaveLoad().requestCache(region);
                                        }
                                    }
                                    continue;
                                }
                            }
                        }
                        ++this.workingFramesCount;
                        if (this.workingFramesCount >= 30) {
                            this.testingFreeFrame = 1;
                            this.workingFramesCount = 0;
                        }
                        this.textureUploader.uploadTextures();
                    }
                }
            }
            this.mapLimiter.updateAvailableVRAM();
            this.lastRenderProcessTime = renderProcessTime;
        }
        catch (Throwable e) {
            WorldMap.crashHandler.setCrashedBy(e);
        }
        WorldMap.crashHandler.checkForCrashes();
        MapRenderHelper.restoreDefaultShaderBlendState();
    }

    public boolean ignoreWorld(Level world) {
        for (int i = 0; i < this.dimensionsToIgnore.length; ++i) {
            if (!this.dimensionsToIgnore[i].equals(world.m_46472_().m_135782_().m_135815_())) continue;
            return true;
        }
        return false;
    }

    public String getDimensionName(ResourceKey<Level> id) {
        if (id == Level.f_46428_) {
            return "null";
        }
        if (id == Level.f_46429_) {
            return "DIM-1";
        }
        if (id == Level.f_46430_) {
            return "DIM1";
        }
        ResourceLocation identifier = id.m_135782_();
        return identifier.m_135827_() + "$" + identifier.m_135815_().replace('/', '%');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoadingToFinish(Runnable onFinish) {
        while (true) {
            Object object = this.loadingSync;
            synchronized (object) {
                if (!this.isLoading) {
                    onFinish.run();
                    break;
                }
                this.blockStateShortShapeCache.supplyForIOThread();
            }
        }
    }

    public synchronized void changeWorld(ClientLevel world, Registry<Biome> biomeRegistry) {
        this.pushWriterPause();
        this.waitForLoadingToFinish(() -> {
            this.waitingForWorldUpdate = true;
        });
        this.newWorld = world;
        this.newWorldBiomeRegistry = biomeRegistry;
        if (world == null) {
            this.mapWorldUsableRequest = false;
        } else {
            this.mapWorldUsableRequest = true;
            ResourceKey dimId = world.m_46472_();
            Object autoIdBase = this.getAutoIdBase(world);
            MapDimension mapDimension = this.mapWorld.getDimension((ResourceKey<Level>)dimId);
            if (mapDimension == null) {
                mapDimension = this.mapWorld.createDimensionUnsynced((ResourceKey<Level>)dimId);
            }
            this.mapWorld.setFutureDimensionId((ResourceKey<Level>)dimId);
            mapDimension.updateFutureAutomaticUnsynced(Minecraft.m_91087_(), autoIdBase);
            mapDimension.resetCustomMultiworldUnsynced();
        }
        this.popWriterPause();
    }

    private String getMainId(boolean rootFolderFormat) {
        Minecraft mc = Minecraft.m_91087_();
        Object result = null;
        if (mc.m_91092_() != null) {
            result = mc.m_91092_().m_129843_(LevelResource.f_78182_).getParent().getFileName().toString().replaceAll("_", "^us^");
            if (this.isWorldMultiplayer(this.isWorldRealms((String)result), (String)result)) {
                result = "^e^" + (String)result;
            }
        } else if (mc.m_91294_() && WorldMap.events.getLatestRealm() != null) {
            result = "Realms_" + WorldMap.events.getLatestRealm().f_87479_ + "." + WorldMap.events.getLatestRealm().f_87473_;
        } else if (mc.m_91089_() != null) {
            String serverIP;
            String string = serverIP = WorldMap.settings.differentiateByServerAddress ? mc.m_91089_().f_105363_ : "Any Address";
            if (serverIP.contains(":")) {
                serverIP = serverIP.substring(0, serverIP.indexOf(":"));
            }
            while (rootFolderFormat && serverIP.endsWith(".")) {
                serverIP = serverIP.substring(0, serverIP.length() - 1);
            }
            result = "Multiplayer_" + serverIP.replaceAll(":", "\u00a7");
        } else {
            result = "Multiplayer_Unknown";
        }
        return result;
    }

    public synchronized void toggleMultiworldType(MapDimension dim) {
        if (this.mapWorldUsable && !this.waitingForWorldUpdate && this.mapWorld.isMultiplayer() && this.mapWorld.getCurrentDimension() == dim) {
            this.mapWorld.toggleMultiworldTypeUnsynced();
        }
    }

    public synchronized void quickConfirmMultiworld() {
        if (this.canQuickConfirmUnsynced() && this.mapWorld.getCurrentDimension().hasConfirmedMultiworld()) {
            this.confirmMultiworld(this.mapWorld.getCurrentDimension());
        }
    }

    public synchronized boolean confirmMultiworld(MapDimension dim) {
        if (this.mapWorldUsable && this.mapWorld.isMultiplayer() && this.mainWorld != null && this.mainWorld.m_46472_() == this.mapWorld.getCurrentDimensionId() && this.mapWorld.getCurrentDimension() == dim) {
            this.mapWorld.confirmMultiworldTypeUnsynced();
            this.mapWorld.getCurrentDimension().confirmMultiworldUnsynced();
            return true;
        }
        return false;
    }

    public synchronized void setMultiworld(MapDimension dimToCompare, String customMW) {
        if (this.mapWorldUsable && this.mapWorld.isMultiplayer() && dimToCompare == this.mapWorld.getCurrentDimension()) {
            this.mapWorld.getCurrentDimension().setMultiworldUnsynced(customMW);
        }
    }

    public boolean canQuickConfirmUnsynced() {
        return this.mapWorldUsable && !this.mapWorld.getCurrentDimension().futureMultiworldWritable && this.mainWorld.m_46472_() == this.mapWorld.getCurrentDimensionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCrosshairMessage() {
        Object object = this.uiPauseSync;
        synchronized (object) {
            if (this.isUIPaused) {
                return null;
            }
            if (this.canQuickConfirmUnsynced()) {
                String selectedMWName = this.mapWorld.getCurrentDimension().getMultiworldName(this.mapWorld.getCurrentDimension().getFutureMultiworldUnsynced());
                String message = "\u00a72(" + ControlsRegister.keyOpenMap.m_90863_().getString().toUpperCase() + ")\u00a7r " + I18n.m_118938_((String)"gui.xaero_map_unconfirmed", (Object[])new Object[0]);
                if (this.mapWorld.getCurrentDimension().hasConfirmedMultiworld()) {
                    message = message + " \u00a72" + ControlsRegister.keyQuickConfirm.m_90863_().getString().toUpperCase() + "\u00a7r for map \"" + selectedMWName + "\"";
                }
                return message;
            }
        }
        return null;
    }

    private synchronized void checkForWorldUpdate() {
        Object autoIdBase;
        if (this.mainWorld != null && (autoIdBase = this.getAutoIdBase(this.mainWorld)) != null) {
            Object updatedAutoIdBase;
            MapDimension mapDimension;
            boolean baseChanged;
            boolean bl = baseChanged = !autoIdBase.equals(this.getUsedAutoIdBase(this.mainWorld));
            if (baseChanged && this.mapWorldUsable && (mapDimension = this.mapWorld.getDimension((ResourceKey<Level>)this.mainWorld.m_46472_())) != null) {
                mapDimension.updateFutureAutomaticUnsynced(Minecraft.m_91087_(), autoIdBase);
            }
            if (this.mainWorld != this.world) {
                this.changeWorld(this.mainWorld, this.mainWorldBiomeRegistry);
            }
            if ((updatedAutoIdBase = this.getAutoIdBase(this.mainWorld)) != null) {
                this.setUsedAutoIdBase(this.mainWorld, updatedAutoIdBase);
            } else {
                this.removeUsedAutoIdBase(this.mainWorld);
            }
        }
    }

    private void updateWorld() throws IOException, CommandSyntaxException {
        this.pushUIPause();
        this.updateWorldSynced();
        this.popUIPause();
        if (this.mapWorldUsable && !this.mapSaveLoad.isRegionDetectionComplete()) {
            this.mapSaveLoad.detectRegions();
            this.mapSaveLoad.setRegionDetectionComplete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateWorldSynced() throws IOException, CommandSyntaxException {
        Object object = this.uiSync;
        synchronized (object) {
            boolean changedDimension;
            boolean bl = changedDimension = this.mapWorldUsable != this.mapWorldUsableRequest || !this.mapWorldUsableRequest || this.mapWorld.getFutureDimension() != this.mapWorld.getCurrentDimension();
            if (this.mapWorldUsable != this.mapWorldUsableRequest || this.mapWorldUsableRequest && (changedDimension || !this.mapWorld.getFutureDimension().getFutureMultiworldUnsynced().equals(this.mapWorld.getFutureDimension().getCurrentMultiworld()))) {
                String newMultiworldId = !this.mapWorldUsableRequest ? null : this.mapWorld.getFutureMultiworldUnsynced();
                this.pushRenderPause(true, true);
                this.pushWriterPause();
                String newWorldId = !this.mapWorldUsableRequest ? null : this.mapWorld.getMainId();
                String newMWId = !this.mapWorld.isMultiplayer() ? null : newMultiworldId;
                boolean shouldClearAllDimensions = this.state == 1;
                boolean shouldClearNewDimension = this.mapWorldUsableRequest && !this.mapWorld.getFutureMultiworldUnsynced().equals(this.mapWorld.getFutureDimension().getCurrentMultiworld());
                this.mapSaveLoad.getToSave().clear();
                if (this.currentMapLock != null) {
                    this.mapLockToRelease = this.currentMapLock;
                    this.mapLockChannelToClose = this.currentMapLockChannel;
                    this.currentMapLock = null;
                    this.currentMapLockChannel = null;
                }
                this.releaseLocksIfNeeded();
                if (this.mapWorld.getCurrentDimensionId() != null) {
                    MapDimension currentDim = this.mapWorld.getCurrentDimension();
                    MapDimension reqDim = !this.mapWorldUsableRequest ? null : this.mapWorld.getFutureDimension();
                    boolean shouldFinishCurrentDim = this.mapWorldUsable && !this.currentMapNeedsDeletion;
                    boolean currentDimChecked = false;
                    if (shouldFinishCurrentDim) {
                        this.mapSaveLoad.saveAll = true;
                    }
                    if (shouldFinishCurrentDim || shouldClearNewDimension && reqDim == currentDim) {
                        for (LeveledRegion<?> leveledRegion : currentDim.getMapRegions().getUnsyncedList()) {
                            if (shouldFinishCurrentDim) {
                                if (leveledRegion.getLevel() == 0 && leveledRegion.recacheHasBeenRequested() && leveledRegion.getCacheFile() != null) {
                                    ((MapRegion)leveledRegion).convertCacheToOutdated(this.mapSaveLoad, "might be outdated");
                                    if (WorldMap.settings.debug) {
                                        WorldMap.LOGGER.info(String.format("Converting cache for region %s because it might be outdated.", leveledRegion));
                                    }
                                }
                                leveledRegion.setReloadHasBeenRequested(false, "world/dim change");
                                leveledRegion.onCurrentDimFinish(this.mapSaveLoad, this);
                            }
                            if (!shouldClearAllDimensions && (!shouldClearNewDimension || reqDim != currentDim)) continue;
                            leveledRegion.onDimensionClear(this);
                        }
                        currentDimChecked = true;
                    }
                    if (reqDim != currentDim && shouldClearNewDimension) {
                        for (LeveledRegion leveledRegion : reqDim.getMapRegions().getUnsyncedList()) {
                            leveledRegion.onDimensionClear(this);
                        }
                    }
                    if (shouldClearAllDimensions) {
                        for (MapDimension mapDimension : this.mapWorld.getDimensionsList()) {
                            if (currentDimChecked && mapDimension == currentDim) continue;
                            for (LeveledRegion<?> region : mapDimension.getMapRegions().getUnsyncedList()) {
                                region.onDimensionClear(this);
                            }
                        }
                    }
                    if (this.currentMapNeedsDeletion) {
                        this.mapWorld.getCurrentDimension().deleteMultiworldMapDataUnsynced(this.mapWorld.getCurrentDimension().getCurrentMultiworld());
                    }
                }
                this.currentMapNeedsDeletion = false;
                if (shouldClearAllDimensions) {
                    if (this.mapWorld.getCurrentDimensionId() != null) {
                        for (MapDimension dim : this.mapWorld.getDimensionsList()) {
                            dim.clear();
                        }
                    }
                    if (WorldMap.settings.debug) {
                        WorldMap.LOGGER.info("All map data cleared!");
                    }
                    if (this.state == 1) {
                        WorldMap.LOGGER.info("World map cleaned normally!");
                        this.state = 2;
                    }
                } else if (shouldClearNewDimension) {
                    this.mapWorld.getFutureDimension().regionsToCache.clear();
                    this.mapWorld.getFutureDimension().clear();
                    if (WorldMap.settings.debug) {
                        WorldMap.LOGGER.info("Dimension map data cleared!");
                    }
                }
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("World changed!");
                }
                this.mapWorldUsable = this.mapWorldUsableRequest;
                if (this.mapWorldUsableRequest) {
                    this.mapWorld.switchToFutureUnsynced();
                }
                this.caveStartDetermined = false;
                this.caveStart = Short.MAX_VALUE;
                this.currentWorldId = newWorldId;
                this.currentDimId = !this.mapWorldUsableRequest ? null : this.getDimensionName(this.mapWorld.getFutureDimensionId());
                this.currentMWId = newMWId;
                Path mapPath = this.mapSaveLoad.getMWSubFolder(this.currentWorldId, this.currentDimId, this.currentMWId);
                if (this.mapWorldUsable) {
                    Files.createDirectories(mapPath, new FileAttribute[0]);
                    Path mapLockPath = mapPath.resolve(".lock");
                    int totalLockAttempts = 10;
                    int lockAttempts = 10;
                    while (lockAttempts-- > 0) {
                        if (lockAttempts < 9) {
                            WorldMap.LOGGER.info("Failed attempt to lock the current world map! Retrying in 50 ms... " + lockAttempts);
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        try {
                            FileChannel lockChannel = FileChannel.open(mapLockPath, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                            this.currentMapLock = lockChannel.tryLock();
                            if (this.currentMapLock == null) continue;
                            this.currentMapLockChannel = lockChannel;
                            break;
                        }
                        catch (Exception e) {
                            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                        }
                    }
                }
                this.footprints.clear();
                this.mapSaveLoad.clearToLoad();
                this.mapSaveLoad.setNextToLoadByViewing((LeveledRegion)null);
                this.clearToRefresh();
                for (int i = 0; i < this.toProcessLevels.length; ++i) {
                    this.toProcessLevels[i].clear();
                }
                if (this.mapWorldUsable && !this.isCurrentMapLocked()) {
                    for (LeveledRegion<?> region : this.mapWorld.getCurrentDimension().getMapRegions().getUnsyncedList()) {
                        if (!region.shouldBeProcessed()) continue;
                        this.addToProcess(region);
                    }
                }
                this.mapWriter.resetPosition();
                this.world = this.newWorld;
                this.worldBiomeRegistry = this.newWorldBiomeRegistry;
                BlockTintProvider blockTintProvider = this.worldBlockTintProvider = this.world == null ? null : new BlockTintProvider(this.worldBiomeRegistry, this.biomeColorCalculator, this, this.brokenBlockTintCache);
                if (SupportMods.framedBlocks()) {
                    SupportMods.supportFramedBlocks.onWorldChange();
                }
                if (SupportMods.pac()) {
                    SupportMods.xaeroPac.onMapChange(changedDimension);
                    SupportMods.xaeroPac.resetDetection();
                }
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("World/dimension changed to: " + this.currentWorldId + " " + this.currentDimId + " " + this.currentMWId);
                }
                this.worldDataHandler.prepareSingleplayer((Level)this.world, this);
                if (this.worldDataHandler.getWorldDir() == null && this.currentWorldId != null && !this.mapWorld.isMultiplayer()) {
                    this.currentDimId = null;
                    this.currentWorldId = null;
                }
                boolean shouldDetect = this.mapWorldUsable && this.mapWorld.getCurrentDimension().getDetectedRegions() == null;
                this.mapSaveLoad.setRegionDetectionComplete(!shouldDetect);
                this.popRenderPause(true, true);
                this.popWriterPause();
            } else if (this.newWorld != this.world) {
                this.pushWriterPause();
                this.world = this.newWorld;
                this.worldBiomeRegistry = this.newWorldBiomeRegistry;
                BlockTintProvider blockTintProvider = this.worldBlockTintProvider = this.world == null ? null : new BlockTintProvider(this.worldBiomeRegistry, this.biomeColorCalculator, this, this.brokenBlockTintCache);
                if (SupportMods.framedBlocks()) {
                    SupportMods.supportFramedBlocks.onWorldChange();
                }
                if (SupportMods.pac()) {
                    SupportMods.xaeroPac.resetDetection();
                }
                this.popWriterPause();
            }
            if (this.mapWorldUsable) {
                this.mapWorld.getCurrentDimension().switchToFutureMultiworldWritableValueUnsynced();
                this.mapWorld.switchToFutureMultiworldTypeUnsynced();
            }
            this.waitingForWorldUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFootprints(Level world, int step) {
        if (WorldMap.settings.footsteps) {
            if (this.footprintsTimer > 0) {
                this.footprintsTimer -= step;
            } else {
                Double[] coords = new Double[]{this.mainPlayerX, this.mainPlayerZ};
                ArrayList<Double[]> arrayList = this.footprints;
                synchronized (arrayList) {
                    this.footprints.add(coords);
                    if (this.footprints.size() > 32) {
                        this.footprints.remove(0);
                    }
                }
                this.footprintsTimer = 20;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(MapRegion region, boolean prepareHighlights) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            if (!this.toRefresh.contains(region)) {
                this.toRefresh.add(0, region);
            }
        }
        if (prepareHighlights) {
            this.mapRegionHighlightsPreparer.prepare(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToRefresh(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearToRefresh() {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRefresh(Level world) throws RuntimeException {
        this.pushIsLoading();
        if (!this.waitingForWorldUpdate && !this.toRefresh.isEmpty()) {
            MapRegion region = this.toRefresh.get(0);
            if (region.isRefreshing()) {
                boolean regionLoaded;
                int globalReloadVersion = WorldMap.settings.reloadVersion;
                int globalCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    boolean bl = regionLoaded = region.getLoadState() == 2;
                    if (regionLoaded) {
                        region.setRecacheHasBeenRequested(true, "refresh handle");
                        region.setShouldCache(true, "refresh handle");
                        region.setVersion(WorldMap.globalVersion);
                        region.setCacheHashCode(globalCacheHashCode);
                        region.setReloadVersion(globalReloadVersion);
                        region.setHighlightsHash(region.getTargetHighlightsHash());
                    }
                }
                boolean isEmpty = true;
                if (regionLoaded) {
                    MapRegion mapRegion2 = region;
                    synchronized (mapRegion2) {
                        region.setAllCachePrepared(false);
                    }
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            MapTileChunk chunk = region.getChunk(i, j);
                            if (chunk == null) continue;
                            if (chunk.hasHadTerrain()) {
                                if (chunk.getLoadState() == 2) {
                                    for (int tileX = 0; tileX < 4; ++tileX) {
                                        for (int tileZ = 0; tileZ < 4; ++tileZ) {
                                            region.pushWriterPause();
                                            MapTile tile = chunk.getTile(tileX, tileZ);
                                            if (tile != null && tile.isLoaded()) {
                                                for (int o = 0; o < 16; ++o) {
                                                    MapBlock[] column = tile.getBlockColumn(o);
                                                    for (int p = 0; p < 16; ++p) {
                                                        column[p].setSlopeUnknown(true);
                                                    }
                                                }
                                            }
                                            chunk.setTile(tileX, tileZ, tile, this.blockStateShortShapeCache);
                                            region.popWriterPause();
                                        }
                                    }
                                    chunk.setToUpdateBuffers(true);
                                }
                            } else {
                                region.pushWriterPause();
                                if (!chunk.hasHadTerrain() && !chunk.wasChanged()) {
                                    if (chunk.hasHighlightsIfUndiscovered()) {
                                        chunk.getLeafTexture().requestHighlightOnlyUpload();
                                    } else {
                                        region.setChunk(i, j, null);
                                        chunk.getLeafTexture().deleteTexturesAndBuffers();
                                    }
                                }
                                region.popWriterPause();
                            }
                            isEmpty = false;
                        }
                    }
                    if (WorldMap.settings.debug) {
                        WorldMap.LOGGER.info("Region refreshed: " + region + " " + region + " " + this.mapWriter.getUpdateCounter());
                    }
                }
                MapRegion mapRegion3 = region;
                synchronized (mapRegion3) {
                    region.setRefreshing(false);
                    if (isEmpty) {
                        region.setShouldCache(false, "refresh handle");
                        region.setRecacheHasBeenRequested(false, "refresh handle");
                    }
                }
            }
            throw new RuntimeException(String.format("Trying to refresh region %s, which is not marked as being refreshed!", region));
            this.removeToRefresh(region);
        }
        this.popIsLoading();
    }

    public boolean regionExists(int x, int z) {
        return this.regionDetectionExists(x, z) || this.mapWorld.getCurrentDimension().getHighlightHandler().shouldApplyRegionHighlights(x, z, false);
    }

    public boolean regionDetectionExists(int x, int z) {
        if (!this.mapSaveLoad.isRegionDetectionComplete()) {
            return false;
        }
        Hashtable<Integer, RegionDetection> column = this.mapWorld.getCurrentDimension().getDetectedRegions().get(x);
        return column != null && column.containsKey(z);
    }

    public void addRegionDetection(MapDimension dimension, RegionDetection regionDetection) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = dimension.getDetectedRegions();
        Hashtable<Integer, RegionDetection> column = current.get(regionDetection.getRegionX());
        if (column == null) {
            column = new Hashtable();
            current.put(regionDetection.getRegionX(), column);
        }
        column.put(regionDetection.getRegionZ(), regionDetection);
    }

    public RegionDetection getRegionDetection(int x, int z) {
        Hashtable<Integer, RegionDetection> column = this.mapWorld.getCurrentDimension().getDetectedRegions().get(x);
        if (column != null) {
            return column.get(z);
        }
        return null;
    }

    private void removeRegionDetection(int x, int z) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.mapWorld.getCurrentDimension().getDetectedRegions();
        Hashtable<Integer, RegionDetection> column = current.get(x);
        if (column != null) {
            column.remove(z);
        }
        if (column.isEmpty()) {
            current.remove(x);
        }
    }

    public void removeMapRegion(LeveledRegion<?> region) {
        MapDimension regionDim = region.getDim();
        LeveledRegionManager regions = regionDim.getMapRegions();
        if (region.getLevel() == 0) {
            regions.remove(region.getRegionX(), region.getRegionZ(), region.getLevel());
        }
        regions.removeListRegion(region);
        this.removeToProcess(region);
    }

    public LeveledRegion<?> getLeveledRegion(int leveledRegX, int leveledRegZ, int level) {
        MapDimension mapDimension = this.mapWorld.getCurrentDimension();
        LeveledRegionManager regions = mapDimension.getMapRegions();
        return regions.get(leveledRegX, leveledRegZ, level);
    }

    public MapRegion getMapRegion(int regX, int regZ, boolean create) {
        if (!this.mapSaveLoad.isRegionDetectionComplete()) {
            return null;
        }
        MapDimension mapDimension = this.mapWorld.getCurrentDimension();
        LeveledRegionManager regions = mapDimension.getMapRegions();
        MapRegion region = regions.getLeaf(regX, regZ);
        if (region == null) {
            if (create) {
                if (!Minecraft.m_91087_().m_18695_()) {
                    throw new IllegalAccessError();
                }
                region = new MapRegion(this.currentWorldId, this.currentDimId, this.currentMWId, mapDimension, regX, regZ, this.getGlobalVersion(), this.mapWorld.isMultiplayer(), this.worldBiomeRegistry);
                RegionDetection regionDetection = this.getRegionDetection(regX, regZ);
                if (regionDetection != null) {
                    regionDetection.transferInfoTo(region);
                    this.removeRegionDetection(regX, regZ);
                }
                if (!region.hasHadTerrain()) {
                    mapDimension.getHighlightHandler().getRegionHighlightExistenceTracker().stopTracking(regX, regZ);
                    region.setVersion(this.getGlobalVersion());
                    region.setCacheHashCode(WorldMap.settings.getRegionCacheHashCode());
                    region.setReloadVersion(WorldMap.settings.reloadVersion);
                }
                regions.putLeaf(regX, regZ, region);
                regions.addListRegion(region);
                if (regionDetection != null) {
                    regionDetection.transferInfoPostAddTo(region, this);
                }
            } else {
                return null;
            }
        }
        return region;
    }

    public MapTileChunk getMapChunk(int chunkX, int chunkZ) {
        int regionX = chunkX >> 3;
        int regionZ = chunkZ >> 3;
        MapRegion region = this.getMapRegion(regionX, regionZ, false);
        if (region == null) {
            return null;
        }
        int localChunkX = chunkX & 7;
        int localChunkZ = chunkZ & 7;
        return region.getChunk(localChunkX, localChunkZ);
    }

    public MapTile getMapTile(int x, int z) {
        MapTileChunk tileChunk = this.getMapChunk(x >> 2, z >> 2);
        if (tileChunk == null) {
            return null;
        }
        int tileX = x & 3;
        int tileZ = z & 3;
        return tileChunk.getTile(tileX, tileZ);
    }

    public void updateWorldSpawn(BlockPos newSpawn, ClientLevel world) {
        ResourceKey dimId = world.m_46472_();
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        worldData.latestSpawn = newSpawn;
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info("Updated spawn for dimension " + dimId + " " + newSpawn);
        }
        this.spawnToRestore = newSpawn;
        if (world == this.mainWorld) {
            this.mainWorldChangedTime = -1L;
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Done waiting for main spawn.");
            }
        }
        this.checkForWorldUpdate();
    }

    public void onServerLevelId(int serverLevelId) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = serverLevelId;
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info("Updated server level id " + serverLevelId);
        }
        this.checkForWorldUpdate();
    }

    public void onWorldUnload() {
        if (this.mainWorldUnloaded) {
            return;
        }
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info("Changing worlds, pausing the world map...");
        }
        this.mainWorldUnloaded = true;
        this.mapWorld.clearAllCachedHighlightHashes();
        this.mainWorldChangedTime = -1L;
        this.changeWorld(null, null);
    }

    public void onClientTickStart() throws RuntimeException {
        if (this.mainWorld != null && this.spawnToRestore != null && this.mainWorldChangedTime != -1L && System.currentTimeMillis() - this.mainWorldChangedTime >= 3000L) {
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("SPAWN SET TIME OUT");
            }
            this.updateWorldSpawn(this.spawnToRestore, this.mainWorld);
        }
    }

    private void updateRenderStartTime() {
        if (this.renderStartTime == -1L) {
            this.renderStartTime = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWriterPause() {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            ++this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popWriterPause() {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            --this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                ++this.pauseRendering;
            }
            if (uploading) {
                ++this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                --this.pauseRendering;
            }
            if (uploading) {
                --this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            ++this.pauseProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            --this.pauseProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushIsLoading() {
        Object object = this.loadingSync;
        synchronized (object) {
            this.isLoading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popIsLoading() {
        Object object = this.loadingSync;
        synchronized (object) {
            this.isLoading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushUIPause() {
        Object object = this.uiPauseSync;
        synchronized (object) {
            this.isUIPaused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popUIPause() {
        Object object = this.uiPauseSync;
        synchronized (object) {
            this.isUIPaused = false;
        }
    }

    public boolean isUIPaused() {
        return this.isUIPaused;
    }

    public boolean isWritingPaused() {
        return this.pauseWriting > 0;
    }

    public boolean isRenderingPaused() {
        return this.pauseRendering > 0;
    }

    public boolean isUploadingPaused() {
        return this.pauseUploading > 0;
    }

    public boolean isProcessingPaused() {
        return this.pauseProcessing > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessed(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> toProcess;
        ArrayList<LeveledRegion<?>> arrayList = toProcess = this.toProcessLevels[region.getLevel()];
        synchronized (arrayList) {
            return toProcess.contains(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToProcess(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> toProcess;
        ArrayList<LeveledRegion<?>> arrayList = toProcess = this.toProcessLevels[region.getLevel()];
        synchronized (arrayList) {
            toProcess.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToProcess(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> toProcess;
        ArrayList<LeveledRegion<?>> arrayList = toProcess = this.toProcessLevels[region.getLevel()];
        synchronized (arrayList) {
            toProcess.remove(region);
        }
    }

    public int getProcessedCount() {
        int total = 0;
        for (int i = 0; i < this.toProcessLevels.length; ++i) {
            total += this.toProcessLevels[i].size();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAffectingLoadingFrequencyCount() {
        int total = 0;
        block3: for (int i = 0; i < this.toProcessLevels.length; ++i) {
            ArrayList<LeveledRegion<?>> processed = this.toProcessLevels[i];
            for (int j = 0; j < processed.size(); ++j) {
                ArrayList<LeveledRegion<?>> arrayList = processed;
                synchronized (arrayList) {
                    if (j >= processed.size()) {
                        continue block3;
                    }
                    if (processed.get(j).shouldAffectLoadingRequestFrequency()) {
                        ++total;
                    }
                    continue;
                }
            }
        }
        return total;
    }

    public MapSaveLoad getMapSaveLoad() {
        return this.mapSaveLoad;
    }

    public ClientLevel getWorld() {
        return this.world;
    }

    public ClientLevel getNewWorld() {
        return this.newWorld;
    }

    public String getCurrentWorldId() {
        return this.currentWorldId;
    }

    public String getCurrentDimId() {
        return this.currentDimId;
    }

    public String getCurrentMWId() {
        return this.currentMWId;
    }

    public MapWriter getMapWriter() {
        return this.mapWriter;
    }

    public MapLimiter getMapLimiter() {
        return this.mapLimiter;
    }

    public ArrayList<Double[]> getFootprints() {
        return this.footprints;
    }

    public ByteBufferDeallocator getBufferDeallocator() {
        return this.bufferDeallocator;
    }

    public MapTilePool getTilePool() {
        return this.tilePool;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public int getGlobalVersion() {
        return WorldMap.globalVersion;
    }

    public void setGlobalVersion(int globalVersion) {
        WorldMap.globalVersion = globalVersion;
    }

    public long getRenderStartTime() {
        return this.renderStartTime;
    }

    public void resetRenderStartTime() {
        this.renderStartTime = -1L;
    }

    public Queue<Runnable> getMinecraftScheduledTasks() {
        Queue result;
        this.scheduledTasksField.setAccessible(true);
        try {
            result = (Queue)this.scheduledTasksField.get(Minecraft.m_91087_());
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        catch (IllegalAccessException e) {
            result = null;
        }
        this.scheduledTasksField.setAccessible(false);
        return result;
    }

    public Runnable getRenderStartTimeUpdater() {
        return this.renderStartTimeUpdaterRunnable;
    }

    public boolean isWaitingForWorldUpdate() {
        return this.waitingForWorldUpdate;
    }

    public WorldDataHandler getWorldDataHandler() {
        return this.worldDataHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainValues() {
        Object object = this.mainStuffSync;
        synchronized (object) {
            Entity player = Minecraft.m_91087_().m_91288_();
            if (player != null) {
                boolean worldChanging;
                ClientLevel worldToChangeTo = this.ignoreWorld(player.f_19853_) || !(player.f_19853_ instanceof ClientLevel) ? this.mainWorld : (ClientLevel)player.f_19853_;
                boolean bl = worldChanging = worldToChangeTo != this.mainWorld;
                if (worldChanging) {
                    this.mainWorldChangedTime = -1L;
                    if (this.spawnToRestore != null) {
                        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(worldToChangeTo);
                        if (worldData.latestSpawn == null) {
                            this.mainWorldChangedTime = System.currentTimeMillis();
                        }
                    }
                    this.mainWorldUnloaded = false;
                    this.mainWorldBiomeRegistry = worldToChangeTo == null ? null : worldToChangeTo.m_5962_().m_175515_(Registry.f_122885_);
                }
                this.mainWorld = worldToChangeTo;
                this.mainPlayerX = player.m_20185_();
                this.mainPlayerY = player.m_20186_();
                this.mainPlayerZ = player.m_20189_();
                if (worldChanging) {
                    this.checkForWorldUpdate();
                }
            } else {
                if (this.mainWorld != null && !this.mainWorldUnloaded) {
                    this.onWorldUnload();
                }
                this.mainWorld = null;
            }
        }
    }

    public void updateCaveStart(double playerX, double playerZ, Level world) {
        int chunkZ;
        int chunkX;
        ChunkAccess chunk;
        if (!this.caveStartDetermined && (chunk = world.m_6522_(chunkX = (int)Math.floor(playerX) >> 4, chunkZ = (int)Math.floor(playerZ) >> 4, ChunkStatus.f_62326_, false)) != null && !(chunk instanceof EmptyLevelChunk)) {
            if (WorldMap.settings.netherlikeCaveMapAllowed && (this.hardcodedNetherlike.contains(world.m_6042_().m_63969_()) || world.m_6042_().m_63964_() < 256 && Math.abs(chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, 0, 0) - world.m_6042_().m_63964_()) < 16)) {
                this.caveStart = world.m_141937_() + world.m_6042_().m_63964_() - 1;
            }
            this.caveStartDetermined = true;
        }
    }

    public boolean caveStartIsDetermined() {
        return this.caveStartDetermined;
    }

    public int getCaveStart() {
        return this.caveStart;
    }

    public float getBrightness() {
        return this.getBrightness(WorldMap.settings.lighting);
    }

    public float getBrightness(boolean lighting) {
        if (this.world == null) {
            return 1.0f;
        }
        float sunBrightness = lighting && this.caveStart == Short.MAX_VALUE ? (this.world.m_104805_(1.0f) - 0.2f) / 0.8f : 1.0f;
        return 0.375f + 0.625f * Mth.m_14036_((float)sunBrightness, (float)0.0f, (float)1.0f);
    }

    public boolean isWorldRealms(String world) {
        return world.startsWith("Realms_");
    }

    public boolean isWorldMultiplayer(boolean realms, String world) {
        return realms || world.startsWith("Multiplayer_");
    }

    public MapWorld getMapWorld() {
        return this.mapWorld;
    }

    public boolean isCurrentMultiworldWritable() {
        return this.mapWorldUsable && this.mapWorld.getCurrentDimension().currentMultiworldWritable;
    }

    public String getCurrentDimension() {
        return "placeholder";
    }

    public void requestCurrentMapDeletion() {
        if (this.currentMapNeedsDeletion) {
            throw new RuntimeException("Requesting map deletion at a weird time!");
        }
        this.currentMapNeedsDeletion = true;
    }

    public boolean isFinalizing() {
        return this.finalizing;
    }

    public void stop() {
        this.finalizing = true;
        WorldMap.mapRunner.addTask(new MapRunnerTask(){

            @Override
            public void run(MapProcessor doNotUse) {
                if (MapProcessor.this.state == 0) {
                    MapProcessor.this.state = 1;
                    if (!MapProcessor.this.mapWorldUsable) {
                        MapProcessor.this.forceClean();
                    } else {
                        MapProcessor.this.changeWorld(null, null);
                    }
                }
            }
        });
    }

    private synchronized void forceClean() {
        this.pushRenderPause(true, true);
        this.pushWriterPause();
        if (this.mapWorld != null) {
            for (MapDimension dim : this.mapWorld.getDimensionsList()) {
                for (LeveledRegion<?> region : dim.getMapRegions().getUnsyncedList()) {
                    region.onDimensionClear(this);
                }
            }
        }
        this.popRenderPause(true, true);
        this.popWriterPause();
        if (this.currentMapLock != null) {
            if (this.mapLockToRelease != null) {
                this.releaseLocksIfNeeded();
            }
            this.mapLockToRelease = this.currentMapLock;
            this.mapLockChannelToClose = this.currentMapLockChannel;
            this.releaseLocksIfNeeded();
        }
        this.state = 2;
        WorldMap.LOGGER.info("World map force-cleaned!");
    }

    public boolean isMapWorldUsable() {
        return this.mapWorldUsable;
    }

    private Object getAutoIdBase(ClientLevel world) {
        return this.hasServerLevelId() ? WorldMapClientWorldDataHelper.getCurrentWorldData().serverLevelId : WorldMapClientWorldDataHelper.getWorldData((ClientLevel)world).latestSpawn;
    }

    private Object getUsedAutoIdBase(ClientLevel world) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        return this.hasServerLevelId() ? WorldMapClientWorldDataHelper.getCurrentWorldData().usedServerLevelId : worldData.usedSpawn;
    }

    private void setUsedAutoIdBase(ClientLevel world, Object autoIdBase) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        if (this.hasServerLevelId()) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().usedServerLevelId = (Integer)autoIdBase;
        } else {
            worldData.usedSpawn = (BlockPos)autoIdBase;
        }
    }

    private void removeUsedAutoIdBase(ClientLevel world) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        if (this.hasServerLevelId()) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().usedServerLevelId = null;
        } else {
            worldData.usedSpawn = null;
        }
    }

    private boolean hasServerLevelId() {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return false;
        }
        return worldData.serverLevelId != null && !this.mapWorld.isIgnoreServerLevelId();
    }

    public boolean isEqual(String worldId, String dimId, String mwId) {
        return worldId.equals(this.currentWorldId) && dimId.equals(this.currentDimId) && (mwId == this.currentMWId || mwId != null && mwId.equals(this.currentMWId));
    }

    @Deprecated
    public String getCurrentWorldString() {
        return this.getCurrentWorldId();
    }

    public boolean isFinished() {
        return this.state == 3;
    }

    public MultiTextureRenderTypeRendererProvider getMultiTextureRenderTypeRenderers() {
        return this.multiTextureRenderTypeRenderers;
    }

    public CustomVertexConsumers getCvc() {
        return this.cvc;
    }

    public boolean isCurrentMapLocked() {
        return this.currentMapLock == null;
    }

    private void releaseLocksIfNeeded() {
        if (this.mapLockToRelease != null) {
            int lockAttempts = 10;
            while (lockAttempts-- > 0) {
                try {
                    if (this.mapLockToRelease.isValid()) {
                        this.mapLockToRelease.release();
                    }
                    this.mapLockChannelToClose.close();
                    break;
                }
                catch (Exception e) {
                    WorldMap.LOGGER.error("Failed attempt to release the lock for the world map! Retrying in 50 ms... " + lockAttempts, (Throwable)e);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.mapLockToRelease = null;
            this.mapLockChannelToClose = null;
        }
    }

    public BlockStateShortShapeCache getBlockStateShortShapeCache() {
        return this.blockStateShortShapeCache;
    }

    public BlockTintProvider getWorldBlockTintProvider() {
        return this.worldBlockTintProvider;
    }

    public HighlighterRegistry getHighlighterRegistry() {
        return this.highlighterRegistry;
    }

    public MapRegionHighlightsPreparer getMapRegionHighlightsPreparer() {
        return this.mapRegionHighlightsPreparer;
    }

    public MessageBox getMessageBox() {
        return this.messageBox;
    }

    public MessageBoxRenderer getMessageBoxRenderer() {
        return this.messageBoxRenderer;
    }
}

