/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.file.MapSaveLoad;
import xaero.map.region.BranchLeveledRegion;
import xaero.map.region.MapRegion;
import xaero.map.region.texture.RegionTexture;
import xaero.map.world.MapDimension;

public abstract class LeveledRegion<T extends RegionTexture<T>>
implements Comparable<LeveledRegion<T>> {
    public static final int SIDE_LENGTH = 8;
    private static int comparisonX = 0;
    private static int comparisonZ = 0;
    protected static int comparisonLevel;
    private static int comparisonLeafX;
    private static int comparisonLeafZ;
    protected BranchLeveledRegion parent;
    protected int regionX;
    protected int regionZ;
    protected int level;
    private boolean allCachePrepared;
    protected boolean shouldCache;
    protected boolean recacheHasBeenRequested;
    protected boolean reloadHasBeenRequested;
    protected File cacheFile = null;
    protected String worldId;
    protected String dimId;
    protected String mwId;
    protected MapDimension dim;
    public int activeBranchUpdateReferences;
    public int[][] leafTextureVersionSum = new int[8][8];
    protected int[][] cachedTextureVersions = new int[8][8];
    protected boolean metaLoaded;
    private int distanceFromPlayerCache;
    private int leafDistanceFromPlayerCache;
    protected long lastSaveTime;

    public LeveledRegion(String worldId, String dimId, String mwId, MapDimension dim, int level, int leveledX, int leveledZ, BranchLeveledRegion parent) {
        this.worldId = worldId;
        this.dimId = dimId;
        this.mwId = mwId;
        this.dim = dim;
        this.level = level;
        this.regionX = leveledX;
        this.regionZ = leveledZ;
        this.parent = parent;
    }

    public void onDimensionClear(MapProcessor mapProcessor) {
        this.deleteTexturesAndBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTexturesAndBuffers() {
        LeveledRegion leveledRegion = this;
        synchronized (leveledRegion) {
            this.setAllCachePrepared(false);
        }
        if (this.hasTextures()) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    T texture = this.getTexture(i, j);
                    if (texture == null) continue;
                    LeveledRegion leveledRegion2 = this;
                    synchronized (leveledRegion2) {
                        this.setAllCachePrepared(false);
                        ((RegionTexture)texture).setCachePrepared(false);
                    }
                    ((RegionTexture)texture).deleteTexturesAndBuffers();
                    if (this.level <= 0) continue;
                    this.putTexture(i, j, null);
                }
            }
        }
    }

    public boolean hasTextures() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBuffers() {
        LeveledRegion leveledRegion = this;
        synchronized (leveledRegion) {
            this.setAllCachePrepared(false);
        }
        if (this.hasTextures()) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    T texture = this.getTexture(i, j);
                    if (texture == null || ((RegionTexture)texture).getColorBuffer() == null) continue;
                    LeveledRegion leveledRegion2 = this;
                    synchronized (leveledRegion2) {
                        this.setAllCachePrepared(false);
                        ((RegionTexture)texture).setCachePrepared(false);
                    }
                    ((RegionTexture)texture).setToUpload(false);
                    ((RegionTexture)texture).deleteColorBuffer();
                }
            }
        }
    }

    public void deleteGLBuffers() {
        if (this.hasTextures()) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    T texture = this.getTexture(i, j);
                    if (texture == null) continue;
                    ((RegionTexture)texture).deletePBOs();
                }
            }
        }
    }

    public boolean isAllCachePrepared() {
        return this.allCachePrepared;
    }

    public void setAllCachePrepared(boolean allCachePrepared) {
        if (this.allCachePrepared && !allCachePrepared && WorldMap.settings.detailed_debug) {
            WorldMap.LOGGER.info("Cancelling cache: " + this);
        }
        this.allCachePrepared = allCachePrepared;
    }

    public int getRegionX() {
        return this.regionX;
    }

    public int getRegionZ() {
        return this.regionZ;
    }

    public boolean shouldCache() {
        return this.shouldCache;
    }

    public int getLevel() {
        return this.level;
    }

    public void setShouldCache(boolean shouldCache, String by) {
        this.shouldCache = shouldCache;
        if (WorldMap.settings.detailed_debug) {
            WorldMap.LOGGER.info("shouldCache set to " + shouldCache + " by " + by + " for " + this);
        }
    }

    public boolean recacheHasBeenRequested() {
        return this.recacheHasBeenRequested;
    }

    public void setRecacheHasBeenRequested(boolean recacheHasBeenRequested, String by) {
        if (WorldMap.settings.detailed_debug && recacheHasBeenRequested != this.recacheHasBeenRequested) {
            WorldMap.LOGGER.info("Recache set to " + recacheHasBeenRequested + " by " + by + " for " + this);
        }
        this.recacheHasBeenRequested = recacheHasBeenRequested;
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public void setCacheFile(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    public MapDimension getDim() {
        return this.dim;
    }

    public String toString() {
        return this.regionX + "_" + this.regionZ + " L" + this.level + " " + super.toString();
    }

    public boolean reloadHasBeenRequested() {
        return this.reloadHasBeenRequested;
    }

    public void setReloadHasBeenRequested(boolean reloadHasBeenRequested, String by) {
        if (WorldMap.settings.detailed_debug && reloadHasBeenRequested != this.reloadHasBeenRequested) {
            WorldMap.LOGGER.info("Reload set to " + reloadHasBeenRequested + " by " + by + " for " + this);
        }
        this.reloadHasBeenRequested = reloadHasBeenRequested;
    }

    public static void setComparison(int x, int z, int level, int leafX, int leafZ) {
        comparisonX = x;
        comparisonZ = z;
        comparisonLevel = level;
        comparisonLeafX = leafX;
        comparisonLeafZ = leafZ;
    }

    protected int distanceFromPlayer() {
        int toRegionX = (this.regionX << this.level >> comparisonLevel) - comparisonX;
        int toRegionZ = (this.regionZ << this.level >> comparisonLevel) - comparisonZ;
        return (int)Math.sqrt(toRegionX * toRegionX + toRegionZ * toRegionZ);
    }

    protected int leafDistanceFromPlayer() {
        int toRegionX = (this.regionX << this.level) - comparisonLeafX;
        int toRegionZ = (this.regionZ << this.level) - comparisonLeafZ;
        return (int)Math.sqrt(toRegionX * toRegionX + toRegionZ * toRegionZ);
    }

    public void calculateSortingDistance() {
        this.distanceFromPlayerCache = this.distanceFromPlayer();
        this.leafDistanceFromPlayerCache = this.leafDistanceFromPlayer();
    }

    @Override
    public int compareTo(LeveledRegion<T> arg0) {
        if (this.level == 3 && arg0.level != 3) {
            return -1;
        }
        if (arg0.level == 3 && this.level != 3) {
            return 1;
        }
        if (this.level == comparisonLevel && arg0.level != comparisonLevel) {
            return -1;
        }
        if (arg0.level == comparisonLevel && this.level != comparisonLevel) {
            return 1;
        }
        int toRegion = this.distanceFromPlayerCache;
        int toRegion2 = arg0.distanceFromPlayerCache;
        if (toRegion > toRegion2) {
            return 1;
        }
        if (toRegion == toRegion2) {
            toRegion = this.leafDistanceFromPlayerCache;
            toRegion2 = arg0.leafDistanceFromPlayerCache;
            if (toRegion > toRegion2) {
                return 1;
            }
            if (toRegion == toRegion2) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public void onProcessingEnd() {
    }

    public void addDebugLines(List<String> debugLines, MapProcessor mapProcessor, int textureX, int textureY) {
        debugLines.add("processed: " + mapProcessor.isProcessed(this));
        debugLines.add(String.format("recache: %s reload: %s metaLoaded: %s", this.recacheHasBeenRequested(), this.reloadHasBeenRequested(), this.metaLoaded));
        debugLines.add("shouldCache: " + this.shouldCache() + " allCachePrepared: " + this.allCachePrepared);
        debugLines.add("activeBranchUpdateReferences: " + this.activeBranchUpdateReferences);
        debugLines.add("leafTextureVersionSum: " + this.leafTextureVersionSum[textureX][textureY] + " cachedTextureVersions: " + this.cachedTextureVersions[textureX][textureY] + " [" + textureX + "," + textureY + "]");
    }

    protected void writeCacheMetaData(DataOutputStream output, byte[] usableBuffer, byte[] integerByteBuffer) throws IOException {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                T texture = this.getTexture(i, j);
                if (texture == null || !((RegionTexture)texture).shouldIncludeInCache()) continue;
                if (!((RegionTexture)texture).isCachePrepared()) {
                    throw new RuntimeException("Trying to save cache but " + i + " " + j + " in " + this + " is not prepared.");
                }
                output.write(i << 4 | j);
                int bufferedTextureVersion = ((RegionTexture)texture).getBufferedTextureVersion();
                output.writeInt(bufferedTextureVersion);
            }
        }
        output.write(255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean saveCacheTextures(File tempFile, int extraAttempts) throws IOException {
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info("Saving cache: " + this);
        }
        try (ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));){
            boolean bl;
            try (DataOutputStream output = new DataOutputStream(zipOutput);){
                T texture;
                int j;
                ZipEntry e = new ZipEntry("cache.xaero");
                zipOutput.putNextEntry(e);
                byte[] usableBuffer = new byte[16384];
                byte[] integerByteBuffer = new byte[4];
                int currentFullVersion = 65554;
                output.writeInt(currentFullVersion);
                this.writeCacheMetaData(output, usableBuffer, integerByteBuffer);
                for (int i = 0; i < 8; ++i) {
                    for (j = 0; j < 8; ++j) {
                        texture = this.getTexture(i, j);
                        if (texture == null || !((RegionTexture)texture).shouldIncludeInCache()) continue;
                        if (!((RegionTexture)texture).isCachePrepared()) {
                            throw new RuntimeException("Trying to save cache but " + i + " " + j + " in " + this + " is not prepared.");
                        }
                        output.write(i << 4 | j);
                        ((RegionTexture)texture).writeCacheMapData(output, usableBuffer, integerByteBuffer, this);
                    }
                }
                output.write(255);
                zipOutput.closeEntry();
                LeveledRegion i = this;
                synchronized (i) {
                    this.setAllCachePrepared(false);
                }
                for (int i2 = 0; i2 < 8; ++i2) {
                    for (j = 0; j < 8; ++j) {
                        texture = this.getTexture(i2, j);
                        if (texture == null || !((RegionTexture)texture).shouldIncludeInCache()) continue;
                        ((RegionTexture)texture).deleteColorBuffer();
                        LeveledRegion leveledRegion = this;
                        synchronized (leveledRegion) {
                            ((RegionTexture)texture).setCachePrepared(false);
                            this.setAllCachePrepared(false);
                            continue;
                        }
                    }
                }
                bl = true;
            }
            return bl;
        }
        catch (IOException ioe) {
            WorldMap.LOGGER.info("IO exception while trying to save cache textures for " + this);
            if (extraAttempts > 0) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)ioe);
                WorldMap.LOGGER.info("Retrying...");
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.saveCacheTextures(tempFile, extraAttempts - 1);
            }
            throw ioe;
        }
    }

    protected void readCacheMetaData(DataInputStream input, int minorSaveVersion, int majorSaveVersion, byte[] usableBuffer, byte[] integerByteBuffer, boolean[][] textureLoaded, MapProcessor mapProcessor) throws IOException {
        if (minorSaveVersion == 8 || minorSaveVersion >= 12) {
            this.readCacheInput(true, input, minorSaveVersion, majorSaveVersion, usableBuffer, integerByteBuffer, textureLoaded, false, mapProcessor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadCacheTextures(MapProcessor mapProcessor, boolean justMetaData, boolean[][] textureLoaded, int targetHighlightsHash, boolean[] leafShouldAffectBranchesDest, boolean[] metaLoadedDest, int extraAttempts) {
        if (this.cacheFile == null) {
            return false;
        }
        if (!this.cacheFile.exists()) {
            this.cacheFile = null;
            this.shouldCache = true;
            return false;
        }
        try (ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
             DataInputStream input = new DataInputStream(zipInput);){
            boolean leafShouldAffectBranches;
            ZipEntry entry = zipInput.getNextEntry();
            if (entry == null) return false;
            byte[] integerByteBuffer = new byte[4];
            int cacheFullSaveVersion = input.readInt();
            int minorSaveVersion = cacheFullSaveVersion & 0xFFFF;
            int majorSaveVersion = cacheFullSaveVersion >> 16 & 0xFFFF;
            int currentFullVersion = 65554;
            if (cacheFullSaveVersion > currentFullVersion || cacheFullSaveVersion == 7) {
                input.close();
                WorldMap.LOGGER.info("Trying to load newer region cache " + this + " using an older version of Xaero's World Map!");
                mapProcessor.getMapSaveLoad().backupFile(this.cacheFile, cacheFullSaveVersion);
                this.cacheFile = null;
                this.shouldCache = true;
                boolean bl = false;
                return bl;
            }
            if (cacheFullSaveVersion < currentFullVersion) {
                this.shouldCache = true;
            }
            byte[] usableBuffer = new byte[16384];
            if (minorSaveVersion >= 8) {
                this.readCacheMetaData(input, minorSaveVersion, majorSaveVersion, usableBuffer, integerByteBuffer, textureLoaded, mapProcessor);
                metaLoadedDest[0] = true;
                if (justMetaData && (minorSaveVersion == 8 || minorSaveVersion >= 12)) {
                    boolean bl = true;
                    return bl;
                }
            }
            this.preCacheLoad();
            boolean bl = leafShouldAffectBranches = !this.shouldCache && this.shouldLeafAffectCache(targetHighlightsHash);
            if (leafShouldAffectBranchesDest != null) {
                leafShouldAffectBranchesDest[0] = leafShouldAffectBranches;
            }
            this.readCacheInput(false, input, minorSaveVersion, majorSaveVersion, usableBuffer, integerByteBuffer, textureLoaded, leafShouldAffectBranches, mapProcessor);
            metaLoadedDest[0] = true;
            zipInput.closeEntry();
            boolean bl2 = false;
            return bl2;
        }
        catch (IOException ioe) {
            WorldMap.LOGGER.error("IO exception while trying to load cache for region " + this + "! " + this.cacheFile, (Throwable)ioe);
            if (extraAttempts <= 0) {
                this.cacheFile = null;
                this.shouldCache = true;
                return false;
            }
            WorldMap.LOGGER.info("Retrying...");
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            metaLoadedDest[0] = false;
            return this.loadCacheTextures(mapProcessor, justMetaData, textureLoaded, targetHighlightsHash, leafShouldAffectBranchesDest, metaLoadedDest, extraAttempts - 1);
        }
        catch (Throwable e) {
            this.cacheFile = null;
            this.shouldCache = true;
            WorldMap.LOGGER.error("Failed to load cache for region " + this + "! " + this.cacheFile, e);
            return false;
        }
    }

    protected boolean shouldLeafAffectCache(int targetHighlightsHash) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCacheInput(boolean isMeta, DataInputStream input, int minorSaveVersion, int majorSaveVersion, byte[] usableBuffer, byte[] integerByteBuffer, boolean[][] textureLoaded, boolean leafShouldAffectBranches, MapProcessor mapProcessor) throws IOException {
        int textureCoords = input.read();
        while (textureCoords != -1 && textureCoords != 255) {
            int x = textureCoords >> 4;
            int y = textureCoords & 0xF;
            if (textureLoaded != null) {
                textureLoaded[x][y] = true;
            }
            if (isMeta) {
                int cachedTextureVersion;
                this.cachedTextureVersions[x][y] = cachedTextureVersion = input.readInt();
                this.updateLeafTextureVersion(x, y, cachedTextureVersion);
            } else {
                RegionTexture texture;
                RegionTexture regionTexture = texture = this.hasTextures() ? (RegionTexture)this.getTexture(x, y) : null;
                if (texture == null) {
                    texture = (RegionTexture)this.createTexture(x, y);
                    if (this.level == 0) {
                        LeveledRegion leveledRegion = this;
                        synchronized (leveledRegion) {
                            this.setAllCachePrepared(false);
                        }
                    }
                }
                texture.readCacheData(minorSaveVersion, majorSaveVersion, input, usableBuffer, integerByteBuffer, this, mapProcessor, x, y, leafShouldAffectBranches);
            }
            textureCoords = input.read();
        }
    }

    public int getAndResetCachedTextureVersion(int x, int y) {
        int result = this.cachedTextureVersions[x][y];
        this.cachedTextureVersions[x][y] = -1;
        return result;
    }

    public BranchLeveledRegion getParent() {
        return this.parent;
    }

    public boolean shouldAffectLoadingRequestFrequency() {
        return this.shouldBeProcessed();
    }

    protected void preCacheLoad() {
    }

    public void processWhenLoadedChunksExist(int globalRegionCacheHashCode) {
    }

    public boolean isMetaLoaded() {
        return this.metaLoaded;
    }

    public void confirmMetaLoaded() {
        this.metaLoaded = true;
    }

    public LeveledRegion<?> getRootRegion() {
        LeveledRegion<?> result = this;
        if (this.parent != null) {
            result = this.parent.getRootRegion();
        }
        return result;
    }

    public void checkForUpdates(MapProcessor mapProcessor, boolean prevWaitingForBranchCache, boolean[] waitingForBranchCache, ArrayList<BranchLeveledRegion> branchRegionBuffer, int viewedLevel, int minViewedLeafX, int minViewedLeafZ, int maxViewedLeafX, int maxViewedLeafZ) {
    }

    public abstract boolean shouldEndProcessingAfterUpload();

    public abstract T createTexture(int var1, int var2);

    public abstract void putTexture(int var1, int var2, T var3);

    public abstract T getTexture(int var1, int var2);

    protected abstract void putLeaf(int var1, int var2, MapRegion var3);

    protected abstract boolean remove(int var1, int var2, int var3);

    protected abstract LeveledRegion<?> get(int var1, int var2, int var3);

    public abstract boolean loadingAnimation();

    public abstract boolean cleanAndCacheRequestsBlocked();

    public abstract boolean shouldBeProcessed();

    public abstract boolean isLoaded();

    public abstract void preCache();

    public abstract void postCache(File var1, MapSaveLoad var2, boolean var3) throws IOException;

    public abstract boolean skipCaching(MapProcessor var1);

    public abstract File findCacheFile(MapSaveLoad var1) throws IOException;

    public abstract void onCurrentDimFinish(MapSaveLoad var1, MapProcessor var2);

    public abstract void onLimiterRemoval(MapProcessor var1);

    public abstract void afterLimiterRemoval(MapProcessor var1);

    public String getExtraInfo() {
        return "";
    }

    public void updateLeafTextureVersion(int localTextureX, int localTextureZ, int newVersion) {
    }

    public boolean hasRemovableSourceData() {
        return false;
    }

    static {
        comparisonLeafX = 0;
        comparisonLeafZ = 0;
    }
}

