/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.util.LogMessageAdapter;
import net.minecraftforge.common.util.TablePrinter;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ForgeRegistryTagManager;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.IHolderHelperHolder;
import net.minecraftforge.registries.NamespacedDefaultedWrapper;
import net.minecraftforge.registries.NamespacedHolderHelper;
import net.minecraftforge.registries.NamespacedWrapper;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryDelegate;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeRegistry<V extends IForgeRegistryEntry<V>>
implements IForgeRegistryInternal<V>,
IForgeRegistryModifiable<V> {
    public static Marker REGISTRIES = MarkerManager.getMarker((String)"REGISTRIES");
    private static Marker REGISTRYDUMP = MarkerManager.getMarker((String)"REGISTRYDUMP");
    private static Logger LOGGER = LogManager.getLogger();
    private final RegistryManager stage;
    private final BiMap<Integer, V> ids = HashBiMap.create();
    private final BiMap<ResourceLocation, V> names = HashBiMap.create();
    private final BiMap<ResourceKey<V>, V> keys = HashBiMap.create();
    private final Class<V> superType;
    private final Map<ResourceLocation, ResourceLocation> aliases = Maps.newHashMap();
    final Map<ResourceLocation, ?> slaves = Maps.newHashMap();
    private final ResourceLocation defaultKey;
    private final ResourceKey<V> defaultResourceKey;
    private final IForgeRegistry.CreateCallback<V> create;
    private final IForgeRegistry.AddCallback<V> add;
    private final IForgeRegistry.ClearCallback<V> clear;
    private final IForgeRegistry.ValidateCallback<V> validate;
    private final IForgeRegistry.BakeCallback<V> bake;
    private final IForgeRegistry.MissingFactory<V> missing;
    private final BitSet availabilityMap;
    private final Set<ResourceLocation> dummies = Sets.newHashSet();
    private final Set<Integer> blocked = Sets.newHashSet();
    private final Multimap<ResourceLocation, V> overrides = ArrayListMultimap.create();
    private final BiMap<OverrideOwner<V>, V> owners = HashBiMap.create();
    private final ForgeRegistryTagManager<V> tagManager;
    private final IForgeRegistry.DummyFactory<V> dummyFactory;
    private final boolean isDelegated;
    private final int min;
    private final int max;
    private final boolean allowOverrides;
    private final boolean isModifiable;
    private final boolean hasWrapper;
    private V defaultValue = null;
    boolean isFrozen = false;
    private final ResourceLocation name;
    private final ResourceKey<Registry<V>> key;
    private final RegistryBuilder<V> builder;
    private final Codec<V> codec = new RegistryCodec();

    ForgeRegistry(RegistryManager stage, ResourceLocation name, RegistryBuilder<V> builder) {
        this.name = name;
        this.key = ResourceKey.m_135788_((ResourceLocation)name);
        this.builder = builder;
        this.stage = stage;
        this.superType = builder.getType();
        this.defaultKey = builder.getDefault();
        this.defaultResourceKey = ResourceKey.m_135785_(this.key, (ResourceLocation)this.defaultKey);
        this.min = builder.getMinId();
        this.max = builder.getMaxId();
        this.availabilityMap = new BitSet(Math.min(this.max + 1, 4095));
        this.create = builder.getCreate();
        this.add = builder.getAdd();
        this.clear = builder.getClear();
        this.validate = builder.getValidate();
        this.bake = builder.getBake();
        this.missing = builder.getMissingFactory();
        this.dummyFactory = builder.getDummyFactory();
        this.isDelegated = ForgeRegistryEntry.class.isAssignableFrom(this.superType);
        this.allowOverrides = builder.getAllowOverrides();
        this.isModifiable = builder.getAllowModifications();
        this.hasWrapper = builder.getHasWrapper();
        ForgeRegistryTagManager forgeRegistryTagManager = this.tagManager = this.hasWrapper ? new ForgeRegistryTagManager(this) : null;
        if (this.create != null) {
            this.create.onCreate(this, stage);
        }
    }

    @Override
    public void register(V value) {
        this.add(-1, value);
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            int cur = -1;
            V next = null;
            {
                this.next();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public V next() {
                Object ret = this.next;
                do {
                    this.cur = ForgeRegistry.this.availabilityMap.nextSetBit(this.cur + 1);
                    this.next = (IForgeRegistryEntry)ForgeRegistry.this.ids.get((Object)this.cur);
                } while (this.next == null && this.cur != -1);
                return ret;
            }
        };
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    @Override
    public ResourceKey<Registry<V>> getRegistryKey() {
        return this.key;
    }

    @Override
    public Class<V> getRegistrySuperType() {
        return this.superType;
    }

    @Override
    @NotNull
    public Codec<V> getCodec() {
        return this.codec;
    }

    @Override
    public void registerAll(V ... values) {
        for (V value : values) {
            this.register(value);
        }
    }

    @Override
    public boolean containsKey(ResourceLocation key) {
        while (key != null) {
            if (this.names.containsKey((Object)key)) {
                return true;
            }
            key = this.aliases.get(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(V value) {
        return this.names.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    int size() {
        return this.names.size();
    }

    @Override
    public V getValue(ResourceLocation key) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)this.names.get((Object)key);
        key = this.aliases.get(key);
        while (ret == null && key != null) {
            ret = (IForgeRegistryEntry)this.names.get((Object)key);
            key = this.aliases.get(key);
        }
        return (V)(ret == null ? this.defaultValue : ret);
    }

    @Override
    public ResourceLocation getKey(V value) {
        return this.getResourceKey(value).map(ResourceKey::m_135782_).orElse(this.defaultKey);
    }

    @Override
    @NotNull
    public Optional<ResourceKey<V>> getResourceKey(V value) {
        return Optional.ofNullable((OverrideOwner)this.owners.inverse().get(value)).map(OverrideOwner::key);
    }

    @Nullable
    Registry<V> getWrapper() {
        if (!this.hasWrapper) {
            return null;
        }
        return this.defaultKey != null ? (Registry)this.getSlaveMap(NamespacedDefaultedWrapper.Factory.ID, NamespacedDefaultedWrapper.class) : (Registry)this.getSlaveMap(NamespacedWrapper.Factory.ID, NamespacedWrapper.class);
    }

    @NotNull
    Optional<NamespacedHolderHelper<V>> getHolderHelper() {
        Registry<V> wrapper = this.getWrapper();
        if (!(wrapper instanceof IHolderHelperHolder)) {
            return Optional.empty();
        }
        return Optional.of(((IHolderHelperHolder)wrapper).getHolderHelper());
    }

    void onBindTags(Map<TagKey<V>, HolderSet.Named<V>> tags, Set<TagKey<V>> defaultedTags) {
        if (this.tagManager != null) {
            this.tagManager.bind(tags, defaultedTags);
        }
    }

    @Override
    @NotNull
    public Optional<Holder<V>> getHolder(ResourceKey<V> key) {
        return this.getHolderHelper().flatMap(h -> h.getHolder(key));
    }

    @Override
    @NotNull
    public Optional<Holder<V>> getHolder(ResourceLocation location) {
        return this.getHolderHelper().flatMap(h -> h.getHolder(location));
    }

    @Override
    @NotNull
    public Optional<Holder<V>> getHolder(V value) {
        return this.getHolderHelper().flatMap(h -> h.getHolder(value));
    }

    @Override
    @Nullable
    public ITagManager<V> tags() {
        return this.tagManager;
    }

    @Override
    @NotNull
    public Set<ResourceLocation> getKeys() {
        return Collections.unmodifiableSet(this.names.keySet());
    }

    @Override
    @NotNull
    public Collection<V> getValues() {
        return Collections.unmodifiableSet(this.names.values());
    }

    @Override
    @NotNull
    public Set<Map.Entry<ResourceKey<V>, V>> getEntries() {
        return Collections.unmodifiableSet(this.keys.entrySet());
    }

    @Override
    public <T> T getSlaveMap(ResourceLocation name, Class<T> type) {
        return (T)this.slaves.get(name);
    }

    @Override
    public void setSlaveMap(ResourceLocation name, Object obj) {
        this.slaves.put(name, obj);
    }

    public int getID(V value) {
        Integer ret = (Integer)this.ids.inverse().get(value);
        if (ret == null && this.defaultValue != null) {
            ret = (Integer)this.ids.inverse().get(this.defaultValue);
        }
        return ret == null ? -1 : ret;
    }

    public int getID(ResourceLocation name) {
        return this.getID((IForgeRegistryEntry)this.names.get((Object)name));
    }

    private int getIDRaw(V value) {
        Integer ret = (Integer)this.ids.inverse().get(value);
        return ret == null ? -1 : ret;
    }

    private int getIDRaw(ResourceLocation name) {
        return this.getIDRaw((IForgeRegistryEntry)this.names.get((Object)name));
    }

    public V getValue(int id) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)this.ids.get((Object)id);
        return (V)(ret == null ? this.defaultValue : ret);
    }

    @Nullable
    public ResourceKey<V> getKey(int id) {
        V value = this.getValue(id);
        return (ResourceKey)this.keys.inverse().get(value);
    }

    void validateKey() {
        if (this.defaultKey != null) {
            Validate.notNull(this.defaultValue, (String)("Missing default of ForgeRegistry: " + this.defaultKey + " Type: " + this.superType), (Object[])new Object[0]);
        }
    }

    @Override
    @Nullable
    public ResourceLocation getDefaultKey() {
        return this.defaultKey;
    }

    ForgeRegistry<V> copy(RegistryManager stage) {
        return new ForgeRegistry<V>(stage, this.name, this.builder);
    }

    int add(int id, V value) {
        String owner = ModLoadingContext.get().getActiveNamespace();
        return this.add(id, value, owner);
    }

    int add(int id, V value, String owner) {
        Integer foundId;
        ResourceLocation key = value == null ? null : value.getRegistryName();
        Preconditions.checkNotNull((Object)key, (String)"Can't use a null-name for the registry, object %s.", value);
        Preconditions.checkNotNull(value, (String)"Can't add null-object to the registry, name %s.", (Object)key);
        int idToUse = id;
        if (idToUse < 0 || this.availabilityMap.get(idToUse)) {
            idToUse = this.availabilityMap.nextClearBit(this.min);
        }
        if (idToUse > this.max) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Invalid id %d - maximum id range exceeded.", idToUse));
        }
        V oldEntry = this.getRaw(key);
        if (oldEntry == value) {
            LOGGER.warn(REGISTRIES, "Registry {}: The object {} has been registered twice for the same name {}.", (Object)this.name, value, (Object)key);
            return this.getID(value);
        }
        if (oldEntry != null) {
            if (!this.allowOverrides) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The name %s has been registered twice, for %s and %s.", key, this.getRaw(key), value));
            }
            if (owner == null) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Could not determine owner for the override on %s. Value: %s", key, value));
            }
            LOGGER.debug(REGISTRIES, "Registry {} Override: {} {} -> {}", (Object)this.name, (Object)key, oldEntry, value);
            idToUse = this.getID(oldEntry);
        }
        if ((foundId = (Integer)this.ids.inverse().get(value)) != null) {
            IForgeRegistryEntry otherThing = (IForgeRegistryEntry)this.ids.get((Object)foundId);
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", value, System.identityHashCode(value), this.getKey(value), key, otherThing, System.identityHashCode(otherThing)));
        }
        if (this.isLocked()) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "The object %s (name %s) is being added too late.", value, key));
        }
        if (this.defaultKey != null && this.defaultKey.equals((Object)key)) {
            if (this.defaultValue != null) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Attemped to override already set default value. This is not allowed: The object %s (name %s)", value, key));
            }
            this.defaultValue = value;
        }
        ResourceKey rkey = ResourceKey.m_135785_(this.key, (ResourceLocation)key);
        this.names.put((Object)key, value);
        this.keys.put((Object)rkey, value);
        this.ids.put((Object)idToUse, value);
        this.availabilityMap.set(idToUse);
        this.owners.put(new OverrideOwner(owner == null ? key.m_135815_() : owner, rkey), value);
        if (this.isDelegated) {
            this.getDelegate(value).setName(key);
            if (oldEntry != null) {
                if (!this.overrides.get((Object)key).contains(oldEntry)) {
                    this.overrides.put((Object)key, oldEntry);
                }
                this.overrides.get((Object)key).remove(value);
                if (this.stage == RegistryManager.ACTIVE) {
                    this.getDelegate(oldEntry).changeReference(value);
                }
            }
        }
        if (this.add != null) {
            this.add.onAdd(this, this.stage, idToUse, value, oldEntry);
        }
        if (this.dummies.remove(key)) {
            LOGGER.debug(REGISTRIES, "Registry {} Dummy Remove: {}", (Object)this.name, (Object)key);
        }
        LOGGER.trace(REGISTRIES, "Registry {} add: {} {} {} (req. id {})", (Object)this.name, (Object)key, (Object)idToUse, value, (Object)id);
        return idToUse;
    }

    public V getRaw(ResourceLocation key) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)this.names.get((Object)key);
        key = this.aliases.get(key);
        while (ret == null && key != null) {
            ret = (IForgeRegistryEntry)this.names.get((Object)key);
            key = this.aliases.get(key);
        }
        return (V)ret;
    }

    void addAlias(ResourceLocation from, ResourceLocation to) {
        if (this.isLocked()) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Attempted to register the alias %s -> %s to late", from, to));
        }
        if (from.equals((Object)to)) {
            LOGGER.warn(REGISTRIES, "Registry {} Ignoring invalid alias: {} -> {}", (Object)this.name, (Object)from, (Object)to);
            return;
        }
        this.aliases.put(from, to);
        LOGGER.trace(REGISTRIES, "Registry {} alias: {} -> {}", (Object)this.name, (Object)from, (Object)to);
    }

    void addDummy(ResourceLocation key) {
        if (this.isLocked()) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Attempted to register the dummy %s to late", key));
        }
        this.dummies.add(key);
        LOGGER.trace(REGISTRIES, "Registry {} dummy: {}", (Object)this.name, (Object)key);
    }

    private RegistryDelegate<V> getDelegate(V thing) {
        if (this.isDelegated) {
            return (RegistryDelegate)((ForgeRegistryEntry)thing).delegate;
        }
        throw new IllegalStateException("Tried to get existing delegate from registry that is not delegated.");
    }

    void resetDelegates() {
        if (!this.isDelegated) {
            return;
        }
        for (IForgeRegistryEntry value : this) {
            this.getDelegate(value).changeReference(value);
        }
        for (IForgeRegistryEntry value : this.overrides.values()) {
            this.getDelegate(value).changeReference(value);
        }
    }

    V getDefault() {
        return this.defaultValue;
    }

    boolean isDummied(ResourceLocation key) {
        return this.dummies.contains(key);
    }

    void validateContent(ResourceLocation registryName) {
        try {
            ObfuscationReflectionHelper.findMethod(BitSet.class, (String)"trimToSize", (Class[])new Class[0]).invoke((Object)this.availabilityMap, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (IForgeRegistryEntry obj : this) {
            int id = this.getID(obj);
            ResourceLocation name = this.getKey(obj);
            if (name == null) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Registry entry for %s %s, id %d, doesn't yield a name.", registryName, obj, id));
            }
            if (id > this.max) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Registry entry for %s %s, name %s uses the too large id %d.", registryName, obj, name, id));
            }
            if (this.getValue(id) != obj) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Registry entry for id %d, name %s, doesn't yield the expected %s %s.", id, name, registryName, obj));
            }
            if (this.getValue(name) != obj) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Registry entry for name %s, id %d, doesn't yield the expected %s %s.", name, id, registryName, obj));
            }
            if (this.getID(name) != id) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Registry entry for name %s doesn't yield the expected id %d.", name, id));
            }
            if (this.validate == null) continue;
            this.validate.onValidate(this, this.stage, id, name, obj);
        }
    }

    public void bake() {
        if (this.bake != null) {
            this.bake.onBake(this, this.stage);
        }
    }

    void sync(ResourceLocation name, ForgeRegistry<V> from) {
        LOGGER.debug(REGISTRIES, "Registry {} Sync: {} -> {}", (Object)this.name, (Object)this.stage.getName(), (Object)from.stage.getName());
        if (this == from) {
            throw new IllegalArgumentException("WTF We are the same!?!?!");
        }
        if (from.superType != this.superType) {
            throw new IllegalArgumentException("Attempted to copy to incompatible registry: " + name + " " + from.superType + " -> " + this.superType);
        }
        this.isFrozen = false;
        if (this.clear != null) {
            this.clear.onClear(this, this.stage);
        }
        this.aliases.clear();
        from.aliases.forEach(this::addAlias);
        this.ids.clear();
        this.names.clear();
        this.keys.clear();
        this.availabilityMap.clear(0, this.availabilityMap.length());
        this.defaultValue = null;
        this.overrides.clear();
        this.owners.clear();
        boolean errored = false;
        for (Map.Entry entry : from.names.entrySet()) {
            ArrayList overrides = Lists.newArrayList((Iterable)from.overrides.get((Object)((ResourceLocation)entry.getKey())));
            int id = from.getID((ResourceLocation)entry.getKey());
            if (overrides.isEmpty()) {
                int realId = this.add(id, (IForgeRegistryEntry)entry.getValue());
                if (id == realId || id == -1) continue;
                LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, entry.getKey(), (Object)id, (Object)realId);
                errored = true;
                continue;
            }
            overrides.add((IForgeRegistryEntry)entry.getValue());
            for (IForgeRegistryEntry value : overrides) {
                OverrideOwner owner = (OverrideOwner)from.owners.inverse().get((Object)value);
                if (owner == null) {
                    LOGGER.warn(REGISTRIES, "Registry {}: Override did not have an associated owner object. Name: {} Value: {}", (Object)this.name, entry.getKey(), (Object)value);
                    errored = true;
                    continue;
                }
                int realId = this.add(id, value, owner.owner);
                if (id == realId || id == -1) continue;
                LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, entry.getKey(), (Object)id, (Object)realId);
                errored = true;
            }
        }
        this.dummies.clear();
        from.dummies.forEach(this::addDummy);
        if (errored) {
            throw new RuntimeException("One of more entry values did not copy to the correct id. Check log for details!");
        }
    }

    @Override
    public void clear() {
        if (!this.isModifiable) {
            throw new UnsupportedOperationException("Attempted to clear a non-modifiable Forge Registry");
        }
        if (this.isLocked()) {
            throw new IllegalStateException("Attempted to clear the registry to late.");
        }
        if (this.clear != null) {
            this.clear.onClear(this, this.stage);
        }
        this.aliases.clear();
        this.dummies.clear();
        this.ids.clear();
        this.names.clear();
        this.keys.clear();
        this.availabilityMap.clear(0, this.availabilityMap.length());
    }

    @Override
    public V remove(ResourceLocation key) {
        if (!this.isModifiable) {
            throw new UnsupportedOperationException("Attempted to remove from a non-modifiable Forge Registry");
        }
        if (this.isLocked()) {
            throw new IllegalStateException("Attempted to remove from the registry to late.");
        }
        IForgeRegistryEntry value = (IForgeRegistryEntry)this.names.remove((Object)key);
        if (value != null) {
            ResourceKey rkey = (ResourceKey)this.keys.inverse().remove((Object)value);
            if (rkey == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated RegistryKey: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            Integer id = (Integer)this.ids.inverse().remove((Object)value);
            if (id == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated id: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            LOGGER.trace(REGISTRIES, "Registry {} remove: {} {}", (Object)this.name, (Object)key, (Object)id);
        }
        return (V)value;
    }

    void block(int id) {
        this.blocked.add(id);
        this.availabilityMap.set(id);
    }

    @Override
    public boolean isLocked() {
        return this.isFrozen;
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public void unfreeze() {
        this.isFrozen = false;
    }

    RegistryEvent.Register<V> getRegisterEvent(ResourceLocation name) {
        return new RegistryEvent.Register(name, this);
    }

    void dump(ResourceLocation name) {
        if (LOGGER.isDebugEnabled(REGISTRYDUMP)) {
            TablePrinter<DumpRow> tab = new TablePrinter<DumpRow>().header("ID", r -> r.id).header("Dummy", r -> r.dummied).header("Key", r -> r.key).header("Value", r -> r.value);
            LOGGER.debug(REGISTRYDUMP, () -> LogMessageAdapter.adapt(sb -> {
                sb.append("Registry Name: ").append(name).append('\n');
                tab.clearRows();
                this.getKeys().stream().map(this::getID).sorted().map(id -> {
                    V val = this.getValue((int)id);
                    ResourceLocation key = this.getKey(val);
                    return new DumpRow(Integer.toString(id), this.getKey(val).toString(), val.toString(), Boolean.toString(this.dummies.contains(key)));
                }).forEach(tab::add);
                tab.build((StringBuilder)sb);
            }));
        }
    }

    public void loadIds(Map<ResourceLocation, Integer> ids, Map<ResourceLocation, String> overrides, Map<ResourceLocation, Integer> missing, Map<ResourceLocation, Integer[]> remapped, ForgeRegistry<V> old, ResourceLocation name) {
        ResourceLocation itemName;
        HashMap ovs = Maps.newHashMap(overrides);
        for (Map.Entry<ResourceLocation, Integer> entry : ids.entrySet()) {
            Object obj;
            itemName = entry.getKey();
            if (old.isDummied(itemName)) {
                LOGGER.info(REGISTRIES, "Registry {}: Skipping injection of dummied object {}", (Object)this.name, (Object)itemName);
                continue;
            }
            int newId = entry.getValue();
            int currId = old.getIDRaw(itemName);
            if (currId == -1) {
                LOGGER.info(REGISTRIES, "Registry {}: Found a missing id from the world {}", (Object)this.name, (Object)itemName);
                missing.put(itemName, newId);
                continue;
            }
            if (currId != newId) {
                LOGGER.debug(REGISTRIES, "Registry {}: Fixed {} id mismatch {}: {} (init) -> {} (map).", (Object)this.name, (Object)name, (Object)itemName, (Object)currId, (Object)newId);
                remapped.put(itemName, new Integer[]{currId, newId});
            }
            Preconditions.checkState(((obj = old.getRaw(itemName)) != null ? 1 : 0) != 0, (Object)"objectKey has an ID but no object. Reflection/ASM hackery? Registry bug?");
            ArrayList lst = Lists.newArrayList((Iterable)old.overrides.get((Object)itemName));
            String primaryName = null;
            if (old.overrides.containsKey((Object)itemName)) {
                if (!overrides.containsKey(itemName)) {
                    lst.add(obj);
                    obj = (IForgeRegistryEntry)old.overrides.get((Object)itemName).iterator().next();
                    primaryName = ((OverrideOwner)old.owners.inverse().get(obj)).owner;
                } else {
                    primaryName = overrides.get(itemName);
                }
            }
            for (IForgeRegistryEntry value : lst) {
                int realId;
                OverrideOwner owner = (OverrideOwner)old.owners.inverse().get((Object)value);
                if (owner == null) {
                    LOGGER.warn(REGISTRIES, "Registry {}: Override did not have an associated owner object. Name: {} Value: {}", (Object)this.name, (Object)entry.getKey(), (Object)value);
                    continue;
                }
                if (primaryName.equals(owner.owner) || newId == (realId = this.add(newId, value, owner.owner))) continue;
                LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, (Object)entry.getKey(), (Object)newId, (Object)realId);
            }
            int realId = this.add(newId, obj, primaryName == null ? itemName.m_135815_() : primaryName);
            if (realId != newId) {
                LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, (Object)entry.getKey(), (Object)newId, (Object)realId);
            }
            ovs.remove(itemName);
        }
        for (Map.Entry<Object, Integer> entry : ovs.entrySet()) {
            int realId;
            String current;
            itemName = (ResourceLocation)entry.getKey();
            String owner = (String)((Object)entry.getValue());
            if (owner.equals(current = ((OverrideOwner)this.owners.inverse().get(this.getRaw((ResourceLocation)itemName))).owner)) continue;
            IForgeRegistryEntry _new = (IForgeRegistryEntry)this.owners.get(new OverrideOwner(owner, ResourceKey.m_135785_(this.key, (ResourceLocation)itemName)));
            if (_new == null) {
                LOGGER.warn(REGISTRIES, "Registry {}: Skipping override for {}, Unknown owner {}", (Object)this.name, (Object)itemName, (Object)owner);
                continue;
            }
            LOGGER.info(REGISTRIES, "Registry {}: Activating override {} for {}", (Object)this.name, (Object)owner, (Object)itemName);
            int newId = this.getID(itemName);
            if (newId == (realId = this.add(newId, _new, owner))) continue;
            LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, entry.getKey(), (Object)newId, (Object)realId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markDummy(ResourceLocation key, int id) {
        if (this.dummyFactory == null) {
            return false;
        }
        ForgeRegistry<V> active = RegistryManager.ACTIVE.getRegistry(this.getRegistryKey());
        Optional<NamespacedHolderHelper<V>> holders = active.getHolderHelper();
        if (holders.isPresent() && holders.get().isIntrusive() && holders.get().isFrozen()) {
            try {
                holders.get().unfreeze();
                this.createAndAddDummy(key, id);
            }
            finally {
                holders.get().freeze();
            }
        } else {
            this.createAndAddDummy(key, id);
        }
        return true;
    }

    private void createAndAddDummy(ResourceLocation key, int id) {
        int realId;
        V dummy = this.dummyFactory.createDummy(key);
        LOGGER.debug(REGISTRIES, "Registry {} Dummy Add: {} {} -> {}", (Object)this.name, (Object)key, (Object)id, dummy);
        this.availabilityMap.clear(id);
        if (this.containsKey(key)) {
            IForgeRegistryEntry value = (IForgeRegistryEntry)this.names.remove((Object)key);
            if (value == null) {
                throw new IllegalStateException("ContainsKey for " + key + " was true, but removing by name returned no value.. This should never happen unless hackery!");
            }
            ResourceKey rkey = (ResourceKey)this.keys.inverse().remove((Object)value);
            if (rkey == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated RegistryKey: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            Integer oldid = (Integer)this.ids.inverse().remove((Object)value);
            if (oldid == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated id: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            if (oldid != id) {
                LOGGER.debug(REGISTRIES, "Registry {}: Dummy ID mismatch {} {} -> {}", (Object)this.name, (Object)key, (Object)oldid, (Object)id);
            }
            LOGGER.debug(REGISTRIES, "Registry {} remove: {} {}", (Object)this.name, (Object)key, (Object)oldid);
        }
        if ((realId = this.add(id, dummy)) != id) {
            LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, (Object)key, (Object)id, (Object)realId);
        }
        this.dummies.add(key);
    }

    public Snapshot makeSnapshot() {
        Snapshot ret = new Snapshot();
        this.ids.forEach((id, value) -> ret.ids.put(this.getKey(value), (Integer)id));
        ret.aliases.putAll(this.aliases);
        ret.blocked.addAll(this.blocked);
        ret.dummied.addAll(this.dummies);
        ret.overrides.putAll(this.getOverrideOwners());
        return ret;
    }

    Map<ResourceLocation, String> getOverrideOwners() {
        HashMap ret = Maps.newHashMap();
        for (ResourceLocation key : this.overrides.keySet()) {
            IForgeRegistryEntry obj = (IForgeRegistryEntry)this.names.get((Object)key);
            OverrideOwner owner = (OverrideOwner)this.owners.inverse().get((Object)obj);
            if (owner == null) {
                LOGGER.debug(REGISTRIES, "Registry {} {}: Invalid override {} {}", (Object)this.name, (Object)this.stage.getName(), (Object)key, (Object)obj);
            }
            ret.put(key, owner.owner);
        }
        return ret;
    }

    public RegistryEvent.MissingMappings<?> getMissingEvent(ResourceLocation name, Map<ResourceLocation, Integer> map) {
        ArrayList lst = Lists.newArrayList();
        ForgeRegistry pool = RegistryManager.ACTIVE.getRegistry(name);
        map.forEach((? super K rl, ? super V id) -> lst.add(new RegistryEvent.MissingMappings.Mapping(this, pool, (ResourceLocation)rl, (int)id)));
        return new RegistryEvent.MissingMappings(name, this, lst);
    }

    void processMissingEvent(ResourceLocation name, ForgeRegistry<V> pool, List<RegistryEvent.MissingMappings.Mapping<V>> mappings, Map<ResourceLocation, Integer> missing, Map<ResourceLocation, Integer[]> remaps, Collection<ResourceLocation> defaulted, Collection<ResourceLocation> failed, boolean injectNetworkDummies) {
        LOGGER.debug(REGISTRIES, "Processing missing event for {}:", (Object)name);
        int ignored = 0;
        for (RegistryEvent.MissingMappings.Mapping<V> remap : mappings) {
            RegistryEvent.MissingMappings.Action action = remap.getAction();
            if (action == RegistryEvent.MissingMappings.Action.REMAP) {
                int currId = this.getID(remap.getTarget());
                ResourceLocation newName = pool.getKey(remap.getTarget());
                LOGGER.debug(REGISTRIES, "  Remapping {} -> {}.", (Object)remap.key, (Object)newName);
                missing.remove(remap.key);
                int realId = this.add(remap.id, remap.getTarget());
                if (realId != remap.id) {
                    LOGGER.warn(REGISTRIES, "Registered object did not get ID it asked for. Name: {} Type: {} Expected: {} Got: {}", (Object)newName, this.getRegistrySuperType(), (Object)remap.id, (Object)realId);
                }
                this.addAlias(remap.key, newName);
                if (currId == realId) continue;
                LOGGER.info(REGISTRIES, "Fixed id mismatch {}: {} (init) -> {} (map).", (Object)newName, (Object)currId, (Object)realId);
                remaps.put(newName, new Integer[]{currId, realId});
                continue;
            }
            if (action == RegistryEvent.MissingMappings.Action.DEFAULT) {
                V m;
                V v = m = this.missing == null ? null : (V)this.missing.createMissing(remap.key, injectNetworkDummies);
                if (m == null) {
                    defaulted.add(remap.key);
                } else {
                    this.add(remap.id, m, remap.key.m_135815_());
                }
            } else if (action == RegistryEvent.MissingMappings.Action.IGNORE) {
                LOGGER.debug(REGISTRIES, "Ignoring {}", (Object)remap.key);
                ++ignored;
            } else if (action == RegistryEvent.MissingMappings.Action.FAIL) {
                LOGGER.debug(REGISTRIES, "Failing {}!", (Object)remap.key);
                failed.add(remap.key);
            } else if (action == RegistryEvent.MissingMappings.Action.WARN) {
                LOGGER.warn(REGISTRIES, "{} may cause world breakage!", (Object)remap.key);
            }
            this.block(remap.id);
        }
        if (failed.isEmpty() && ignored > 0) {
            LOGGER.debug(REGISTRIES, "There were {} missing mappings that have been ignored", (Object)ignored);
        }
    }

    RegistryBuilder<V> getBuilder() {
        return this.builder;
    }

    private class RegistryCodec
    implements Codec<V> {
        private RegistryCodec() {
        }

        public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
            if (ops.compressMaps()) {
                return ops.getNumberValue(input).flatMap(n -> {
                    int id = n.intValue();
                    if (ForgeRegistry.this.ids.get((Object)id) == null) {
                        return DataResult.error((String)("Unknown registry id in " + ForgeRegistry.this.key + ": " + n));
                    }
                    Object val = ForgeRegistry.this.getValue(id);
                    return DataResult.success(val);
                }).map(v -> Pair.of((Object)v, (Object)ops.empty()));
            }
            return ResourceLocation.f_135803_.decode(ops, input).flatMap(keyValuePair -> !ForgeRegistry.this.containsKey((ResourceLocation)keyValuePair.getFirst()) ? DataResult.error((String)("Unknown registry key in " + ForgeRegistry.this.key + ": " + keyValuePair.getFirst())) : DataResult.success((Object)keyValuePair.mapFirst(ForgeRegistry.this::getValue)));
        }

        public <T> DataResult<T> encode(V input, DynamicOps<T> ops, T prefix) {
            ResourceLocation key = ForgeRegistry.this.getKey(input);
            if (key == null) {
                return DataResult.error((String)("Unknown registry element in " + ForgeRegistry.this.key + ": " + input));
            }
            Object toMerge = ops.compressMaps() ? ops.createInt(ForgeRegistry.this.getID(input)) : ops.createString(key.toString());
            return ops.mergeToPrimitive(prefix, toMerge);
        }
    }

    private record OverrideOwner<V>(String owner, ResourceKey<V> key) {
    }

    public static class Snapshot {
        private static final Comparator<ResourceLocation> sorter = (a, b) -> a.compareNamespaced(b);
        public final Map<ResourceLocation, Integer> ids = Maps.newTreeMap(sorter);
        public final Map<ResourceLocation, ResourceLocation> aliases = Maps.newTreeMap(sorter);
        public final Set<Integer> blocked = Sets.newTreeSet();
        public final Set<ResourceLocation> dummied = Sets.newTreeSet(sorter);
        public final Map<ResourceLocation, String> overrides = Maps.newTreeMap(sorter);
        private FriendlyByteBuf binary = null;

        public CompoundTag write() {
            CompoundTag data = new CompoundTag();
            ListTag ids = new ListTag();
            this.ids.entrySet().stream().forEach(e -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("K", ((ResourceLocation)e.getKey()).toString());
                tag.m_128405_("V", ((Integer)e.getValue()).intValue());
                ids.add((Object)tag);
            });
            data.m_128365_("ids", (Tag)ids);
            ListTag aliases = new ListTag();
            this.aliases.entrySet().stream().forEach(e -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("K", ((ResourceLocation)e.getKey()).toString());
                tag.m_128359_("V", ((ResourceLocation)e.getValue()).toString());
                aliases.add((Object)tag);
            });
            data.m_128365_("aliases", (Tag)aliases);
            ListTag overrides = new ListTag();
            this.overrides.entrySet().stream().forEach(e -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("K", ((ResourceLocation)e.getKey()).toString());
                tag.m_128359_("V", (String)e.getValue());
                overrides.add((Object)tag);
            });
            data.m_128365_("overrides", (Tag)overrides);
            int[] blocked = this.blocked.stream().mapToInt(x -> x).sorted().toArray();
            data.m_128385_("blocked", blocked);
            ListTag dummied = new ListTag();
            this.dummied.stream().sorted().forEach(e -> dummied.add((Object)StringTag.m_129297_((String)e.toString())));
            data.m_128365_("dummied", (Tag)dummied);
            return data;
        }

        public static Snapshot read(CompoundTag nbt) {
            int[] blocked;
            Snapshot ret = new Snapshot();
            if (nbt == null) {
                return ret;
            }
            ListTag list = nbt.m_128437_("ids", 10);
            list.forEach(e -> {
                CompoundTag comp = (CompoundTag)e;
                ret.ids.put(new ResourceLocation(comp.m_128461_("K")), comp.m_128451_("V"));
            });
            list = nbt.m_128437_("aliases", 10);
            list.forEach(e -> {
                CompoundTag comp = (CompoundTag)e;
                ret.aliases.put(new ResourceLocation(comp.m_128461_("K")), new ResourceLocation(comp.m_128461_("V")));
            });
            list = nbt.m_128437_("overrides", 10);
            list.forEach(e -> {
                CompoundTag comp = (CompoundTag)e;
                ret.overrides.put(new ResourceLocation(comp.m_128461_("K")), comp.m_128461_("V"));
            });
            for (int i : blocked = nbt.m_128465_("blocked")) {
                ret.blocked.add(i);
            }
            list = nbt.m_128437_("dummied", 8);
            list.forEach(e -> ret.dummied.add(new ResourceLocation(((StringTag)e).m_7916_())));
            return ret;
        }

        public synchronized FriendlyByteBuf getPacketData() {
            if (this.binary == null) {
                FriendlyByteBuf pkt = new FriendlyByteBuf(Unpooled.buffer());
                pkt.m_130130_(this.ids.size());
                this.ids.forEach((k, v) -> {
                    pkt.m_130085_(k);
                    pkt.m_130130_(v.intValue());
                });
                pkt.m_130130_(this.aliases.size());
                this.aliases.forEach((k, v) -> {
                    pkt.m_130085_(k);
                    pkt.m_130085_(v);
                });
                pkt.m_130130_(this.overrides.size());
                this.overrides.forEach((k, v) -> {
                    pkt.m_130085_(k);
                    pkt.m_130072_(v, 256);
                });
                pkt.m_130130_(this.blocked.size());
                this.blocked.forEach(arg_0 -> ((FriendlyByteBuf)pkt).m_130130_(arg_0));
                pkt.m_130130_(this.dummied.size());
                this.dummied.forEach(arg_0 -> ((FriendlyByteBuf)pkt).m_130085_(arg_0));
                this.binary = pkt;
            }
            return new FriendlyByteBuf(this.binary.slice());
        }

        public static Snapshot read(FriendlyByteBuf buff) {
            int x;
            if (buff == null) {
                return new Snapshot();
            }
            Snapshot ret = new Snapshot();
            int len = buff.m_130242_();
            for (x = 0; x < len; ++x) {
                ret.ids.put(buff.m_130281_(), buff.m_130242_());
            }
            len = buff.m_130242_();
            for (x = 0; x < len; ++x) {
                ret.aliases.put(buff.m_130281_(), buff.m_130281_());
            }
            len = buff.m_130242_();
            for (x = 0; x < len; ++x) {
                ret.overrides.put(buff.m_130281_(), buff.m_130136_(256));
            }
            len = buff.m_130242_();
            for (x = 0; x < len; ++x) {
                ret.blocked.add(buff.m_130242_());
            }
            len = buff.m_130242_();
            for (x = 0; x < len; ++x) {
                ret.dummied.add(buff.m_130281_());
            }
            return ret;
        }
    }

    private record DumpRow(String id, String key, String value, String dummied) {
    }
}

