/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.content.blocks.util.APWeatheringCopper;
import architectspalette.content.blocks.util.WaterloggableDirectionalBlock;
import architectspalette.core.util.ShapeRotator;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;

public class NubBlock
extends WaterloggableDirectionalBlock {
    private static final Map<Direction, VoxelShape> SHAPES;

    public NubBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    static {
        VoxelShape north = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)5.0);
        VoxelShape up = Block.m_49796_((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
            builder.put((Object)dir, (Object)ShapeRotator.rotateShapeHorizontal(north, Direction.NORTH, dir));
        }
        builder.put((Object)Direction.UP, (Object)up);
        builder.put((Object)Direction.DOWN, (Object)ShapeRotator.flipShapeVertical(up));
        SHAPES = builder.build();
    }

    public static class CopperNubBlock
    extends NubBlock
    implements APWeatheringCopper {
        private final WeatheringCopper.WeatherState weatherState;

        public CopperNubBlock(BlockBehaviour.Properties properties, WeatheringCopper.WeatherState weatherState) {
            super(properties);
            this.weatherState = weatherState;
        }

        public void m_7455_(BlockState stateIn, ServerLevel worldIn, BlockPos pos, Random random) {
            this.m_153041_(stateIn, worldIn, pos, random);
        }

        public boolean m_6724_(BlockState state) {
            return WeatheringCopper.m_154904_((Block)state.m_60734_()).isPresent();
        }

        public WeatheringCopper.WeatherState getAge() {
            return this.weatherState;
        }

        @Nullable
        public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
            BlockState a = APWeatheringCopper.getToolModifiedState(toolAction, state);
            if (a != null) {
                return a;
            }
            return super.getToolModifiedState(state, context, toolAction, simulate);
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return APWeatheringCopper.onUse(state, level, pos, player, hand);
        }
    }
}

