/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.core.util.ShapeRotator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PipeBlockPart> PART = EnumProperty.m_61587_((String)"part", PipeBlockPart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape Y_AXIS_SHAPE = ShapeRotator.cutout(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    protected static final VoxelShape Z_AXIS_SHAPE = ShapeRotator.cutout(Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
    protected static final VoxelShape X_AXIS_SHAPE = ShapeRotator.cutout(Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));

    public PipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_(PART, (Comparable)((Object)PipeBlockPart.MIDDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_55923_, PART, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_((Property)f_55923_)) {
            default: {
                return X_AXIS_SHAPE;
            }
            case Z: {
                return Z_AXIS_SHAPE;
            }
            case Y: 
        }
        return Y_AXIS_SHAPE;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)this.checkNearbyPipes(state, worldIn, currentPos)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState b = super.m_5573_(context);
        return (BlockState)((BlockState)b.m_61124_(PART, (Comparable)((Object)this.checkNearbyPipes(b, (LevelAccessor)context.m_43725_(), context.m_8083_())))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public PipeBlockPart checkNearbyPipes(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction.Axis facing = (Direction.Axis)state.m_61143_((Property)f_55923_);
        BlockPos forward = pos.m_142629_(facing, 1);
        BlockPos reverse = pos.m_142629_(facing, -1);
        boolean ffound = this.pipeMatches(state, world.m_8055_(forward));
        boolean rfound = this.pipeMatches(state, world.m_8055_(reverse));
        if (facing == Direction.Axis.Z) {
            boolean e = ffound;
            ffound = rfound;
            rfound = e;
        }
        if (ffound && rfound) {
            return PipeBlockPart.MIDDLE;
        }
        if (ffound) {
            return PipeBlockPart.BOTTOM;
        }
        return PipeBlockPart.TOP;
    }

    private boolean pipeMatches(BlockState base, BlockState checking) {
        return checking.m_60734_() instanceof PipeBlock && checking.m_61143_((Property)f_55923_) == base.m_61143_((Property)f_55923_);
    }

    public static enum PipeBlockPart implements StringRepresentable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            switch (this) {
                case TOP: {
                    return "top";
                }
                case BOTTOM: {
                    return "bottom";
                }
            }
            return "middle";
        }
    }
}

