/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.core.config.APConfig;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SunstoneBlock
extends Block {
    public static final IntegerProperty LIGHT = IntegerProperty.m_61631_((String)"light", (int)0, (int)2);
    public Function<Level, Integer> lightSupplier;

    public SunstoneBlock(BlockBehaviour.Properties properties, Function<Level, Integer> getLightState) {
        super(properties);
        this.lightSupplier = getLightState;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIGHT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)LIGHT, (Comparable)this.lightSupplier.apply(context.m_43725_()));
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        Integer lightstate;
        if (!worldIn.f_46443_ && !(lightstate = this.lightSupplier.apply((Level)worldIn)).equals(state.m_61143_((Property)LIGHT))) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIGHT, (Comparable)lightstate), 6);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Random rand;
        Double chance;
        if (facingState.m_60734_() instanceof SunstoneBlock && (chance = (Double)APConfig.SUNSTONE_SPREAD_CHANCE.get()) > 0.0 && (rand = worldIn.m_5822_()).nextDouble() <= chance) {
            worldIn.m_186460_(currentPos, (Block)this, (int)(2.0 + Math.floor(rand.nextDouble() * 6.0)));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public static Integer sunstoneLight(Level world) {
        return SunstoneBlock.getLightFromTime(world, 0L);
    }

    public static Integer moonstoneLight(Level world) {
        return SunstoneBlock.getLightFromTime(world, 12000L);
    }

    private static Integer getLightFromTime(Level world, long offset) {
        MinecraftServer s = world.m_142572_();
        if (s == null) {
            return 0;
        }
        ServerLevel overworld = s.m_129880_(Level.f_46428_);
        if (overworld != null) {
            long time = (overworld.m_46468_() + offset) % 24000L;
            if (time >= 12500L && time <= 23500L) {
                return 0;
            }
            if (time >= 3500L && time <= 8500L) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static boolean isOpaque(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LIGHT) == 0;
    }

    public static boolean isLit(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LIGHT) != 0;
    }

    public static int lightValue(BlockState state) {
        return (Integer)state.m_61143_((Property)LIGHT) * 7;
    }
}

