/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.abyssaline.AbyssalineHelper;
import architectspalette.content.blocks.abyssaline.AbyssalineSlabBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineVerticalSlabBlock;
import architectspalette.content.blocks.abyssaline.IAbyssalineChargeable;
import architectspalette.core.registry.util.IBlockSetBase;
import architectspalette.core.registry.util.StoneBlockSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AbyssalineBlock
extends Block
implements IAbyssalineChargeable,
IBlockSetBase {
    public static final BooleanProperty CHARGED = BooleanProperty.m_61465_((String)"charged");
    public static final DirectionProperty CHARGE_SOURCE = DirectionProperty.m_61549_((String)"charge_source", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});

    public AbyssalineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)CHARGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CHARGE_SOURCE, (Comparable)Direction.NORTH));
    }

    @Override
    public Block getBlockForPart(StoneBlockSet.SetComponent part, BlockBehaviour.Properties properties, Block base) {
        return switch (part) {
            case StoneBlockSet.SetComponent.SLAB -> new AbyssalineSlabBlock(properties);
            case StoneBlockSet.SetComponent.VERTICAL_SLAB -> new AbyssalineVerticalSlabBlock(properties);
            default -> IBlockSetBase.super.getBlockForPart(part, properties, base);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CHARGED, CHARGE_SOURCE});
    }

    public static int getLightValue(BlockState state) {
        return (Boolean)state.m_61143_((Property)CHARGED) != false ? 1 : 0;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        AbyssalineHelper.abyssalineNeighborUpdate(this, state, worldIn, pos, blockIn, fromPos);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        AbyssalineHelper.abyssalineTick(state, worldIn, pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return AbyssalineHelper.getStateWithNeighborCharge(this.m_49966_(), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }
}

