/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.datagen;

import architectspalette.core.datagen.WarpingRecipeBuilder;
import architectspalette.core.integration.APVerticalSlabsCondition;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APItems;
import architectspalette.core.registry.util.BlockNode;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.RegistryObject;

public class APRecipes
extends RecipeProvider {
    public APRecipes(DataGenerator generator) {
        super(generator);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        BlockNode.forAllBaseNodes(node -> APRecipes.processBlockNode(consumer, node));
        APRecipes.quickWarpingRecipe(consumer, APBlocks.ESOTERRACK.get(), Blocks.f_50334_, (ResourceKey<DimensionType>)DimensionType.f_63846_);
        APRecipes.quickWarpingRecipe(consumer, APBlocks.ONYX.get(), Blocks.f_50122_, (ResourceKey<DimensionType>)DimensionType.f_63846_);
        ShapedRecipeBuilder.m_126118_((ItemLike)APBlocks.SHEET_METAL.get(), (int)16).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)Items.f_42416_).m_142284_(APRecipes.m_176602_((ItemLike)Items.f_42416_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Items.f_42416_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)APBlocks.TREAD_PLATE.get(), (int)4).m_126130_(" x ").m_126130_("xyx").m_126130_(" x ").m_126127_(Character.valueOf('x'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('y'), (ItemLike)APBlocks.PLATING_BLOCK.get()).m_142284_(APRecipes.m_176602_((ItemLike)APBlocks.PLATING_BLOCK.get()), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)APBlocks.PLATING_BLOCK.get())).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)APBlocks.HAZARD_BLOCK.get(), (int)4).m_126130_("xy").m_126130_("yx").m_126127_(Character.valueOf('x'), (ItemLike)Blocks.f_50494_).m_126127_(Character.valueOf('y'), (ItemLike)Blocks.f_50505_).m_142284_(APRecipes.m_176602_((ItemLike)Blocks.f_50494_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Blocks.f_50494_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)APBlocks.BREAD_BLOCK.get(), (int)9).m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)Blocks.f_50335_).m_142284_(APRecipes.m_176602_((ItemLike)Items.f_42405_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Items.f_42405_)).m_176498_(consumer);
        APRecipes.brickRecipe((ItemLike)APBlocks.ORACLE_BLOCK.get(), (ItemLike)APItems.ORACLE_JELLY.get(), 8, consumer);
        APRecipes.brickRecipe((ItemLike)APBlocks.CEREBRAL_BLOCK.get(), (ItemLike)APItems.CEREBRAL_PLATE.get(), 8, consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)APBlocks.ORACLE_BLOCK.getChild(BlockNode.BlockType.SPECIAL).get()), (int)2).m_126130_("xyx").m_126127_(Character.valueOf('x'), (ItemLike)APItems.CEREBRAL_PLATE.get()).m_126127_(Character.valueOf('y'), (ItemLike)APBlocks.ORACLE_BLOCK.get()).m_142284_(APRecipes.m_176602_((ItemLike)APBlocks.ORACLE_BLOCK.get()), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)APBlocks.ORACLE_BLOCK.get())).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)APBlocks.ORACLE_BLOCK.getChild(BlockNode.BlockType.LAMP).get()), (int)2).m_126130_(" x ").m_126130_("xyx").m_126130_(" x ").m_126127_(Character.valueOf('x'), (ItemLike)APItems.ORACLE_JELLY.get()).m_126127_(Character.valueOf('y'), (ItemLike)Items.f_42001_).m_142284_(APRecipes.m_176602_((ItemLike)APBlocks.ORACLE_BLOCK.get()), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)APBlocks.ORACLE_BLOCK.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)APItems.ORACLE_JELLY.get()), (int)4).m_126209_((ItemLike)Items.f_42730_).m_126209_((ItemLike)Items.f_151049_).m_126209_((ItemLike)Items.f_42501_).m_142284_(APRecipes.m_176602_((ItemLike)Items.f_151049_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Items.f_151049_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)APItems.CEREBRAL_PLATE.get()), (int)4).m_126209_((ItemLike)Blocks.f_152496_).m_126209_((ItemLike)Items.f_42692_).m_126209_((ItemLike)Items.f_42414_).m_142284_(APRecipes.m_176602_((ItemLike)Items.f_151048_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Items.f_151048_)).m_176498_(consumer);
        APRecipes.quickBlastingRecipe(consumer, (ItemLike)APItems.SUNMETAL_BRICK.get(), (ItemLike)APItems.SUNMETAL_BLEND.get());
        APRecipes.quickBlastingRecipe(consumer, (ItemLike)APItems.NETHER_BRASS.get(), (ItemLike)APItems.BRASS_BLEND.get());
    }

    private static void processBlockNode(Consumer<FinishedRecipe> consumer, BlockNode node) {
        String hasBase = "has_" + node.getName();
        node.forEach(n -> {
            if (n.parent != null && !n.getFlag(BlockNode.ExcludeFlag.RECIPES)) {
                Block block = n.get();
                Block parent = n.parent.get();
                int stoneCuttingCount = APRecipes.getStoneCuttingCount(n.type);
                switch (n.type) {
                    case BRICKS: {
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)4).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        RegistryObject<Block> tiles = n.getSibling(BlockNode.BlockType.TILES);
                        if (tiles == null) break;
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)4).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)tiles.get()).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_142700_(consumer, APRecipes.modId(n.getName() + "_from_" + tiles.getId().m_135815_()));
                        break;
                    }
                    case CRACKED: {
                        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{parent}), (ItemLike)block, (float)0.1f, (int)200).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_142700_(consumer, APRecipes.smeltingName(block, parent));
                        break;
                    }
                    case MOSSY: {
                        break;
                    }
                    case TILES: {
                        RegistryObject<Block> bricks = n.getSibling(BlockNode.BlockType.BRICKS);
                        if (bricks != null) {
                            ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)4).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)bricks.get()).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_142700_(consumer, APRecipes.modId(n.getName() + "_from_" + bricks.getId().m_135815_()));
                            break;
                        }
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)4).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case CHISELED: {
                        RegistryObject<Block> slab = n.getSibling(BlockNode.BlockType.SLAB);
                        if (slab == null) break;
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)1).m_126130_("x").m_126130_("x").m_126127_(Character.valueOf('x'), (ItemLike)slab.get()).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case PILLAR: {
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)2).m_126130_("x").m_126130_("x").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case NUB: {
                        break;
                    }
                    case SLAB: {
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)6).m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case VERTICAL_SLAB: {
                        stoneCuttingCount = 0;
                        Block slab = (Block)n.getSibling(BlockNode.BlockType.SLAB).get();
                        ConditionalRecipe.builder().addCondition((ICondition)APVerticalSlabsCondition.instance).addRecipe(c -> ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)3).m_126130_("x").m_126130_("x").m_126130_("x").m_142409_("vertical_slab").m_126127_(Character.valueOf('x'), (ItemLike)slab).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(c)).build(consumer, APRecipes.modId("vslabs/" + n.getName()));
                        ConditionalRecipe.builder().addCondition((ICondition)APVerticalSlabsCondition.instance).addRecipe(c -> ShapelessRecipeBuilder.m_126191_((ItemLike)slab, (int)1).m_142409_("vertical_slab_revert").m_126209_((ItemLike)block).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(c)).build(consumer, APRecipes.modId("vslabs/" + n.getName() + "_revert"));
                        ConditionalRecipe.builder().addCondition((ICondition)APVerticalSlabsCondition.instance).addRecipe(c -> SingleItemRecipeBuilder.m_126316_((Ingredient)APRecipes.getStonecuttingIngredients(n), (ItemLike)block, (int)2).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(c)).build(consumer, APRecipes.modId("vslabs/stonecutting/" + n.getName()));
                        break;
                    }
                    case STAIRS: {
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)4).m_126130_("x  ").m_126130_("xx ").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case WALL: {
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)6).m_126130_("xxx").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case FENCE: {
                        break;
                    }
                    case PLATING: {
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)8).m_126130_("xxx").m_126130_("x x").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case DARK: {
                        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)8).m_126130_("xxx").m_126130_("xdx").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42498_).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                    }
                }
                if (stoneCuttingCount > 0 && node.tool != BlockNode.Tool.AXE) {
                    SingleItemRecipeBuilder.m_126316_((Ingredient)APRecipes.getStonecuttingIngredients(n), (ItemLike)block, (int)stoneCuttingCount).m_142284_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_142700_(consumer, APRecipes.cuttingName(block, parent));
                }
            }
        });
    }

    private static ResourceLocation smeltingName(Block item, Block from) {
        return new ResourceLocation("architects_palette", "smelting/" + item.getRegistryName().m_135815_());
    }

    private static ResourceLocation cuttingName(Block item, Block from) {
        return new ResourceLocation("architects_palette", "stonecutting/" + item.getRegistryName().m_135815_());
    }

    private static ResourceLocation warpingName(Block item, Block from) {
        return new ResourceLocation("architects_palette", "warping/" + item.getRegistryName().m_135815_() + "_from_" + from.getRegistryName().m_135815_() + "_warping");
    }

    private static ResourceLocation blastingName(ItemLike item, ItemLike from) {
        return new ResourceLocation("architects_palette", "blasting/" + APRecipes.m_176632_((ItemLike)item) + "_from_" + APRecipes.m_176632_((ItemLike)from) + "_blasting");
    }

    private static void quickWarpingRecipe(Consumer<FinishedRecipe> consumer, Block result, Block from, ResourceKey<DimensionType> dimension) {
        new WarpingRecipeBuilder(result.m_5456_(), dimension, Ingredient.m_43929_((ItemLike[])new ItemLike[]{from})).m_142284_(APRecipes.m_176602_((ItemLike)from), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)from)).m_142700_(consumer, APRecipes.warpingName(result, from));
    }

    private static void quickBlastingRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike from) {
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{from}), (ItemLike)result, (float)0.1f, (int)100).m_142284_(APRecipes.m_176602_((ItemLike)from), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)from)).m_142700_(consumer, APRecipes.blastingName(result, from));
    }

    private static Ingredient getStonecuttingIngredients(BlockNode node) {
        ArrayList<BlockNode> list = new ArrayList<BlockNode>();
        BlockNode last = node;
        while (last.parent != null && APRecipes.getStoneCuttingCount(last.type) > 0) {
            list.add(last.parent);
            last = last.parent;
        }
        Stream<ItemStack> stream = list.stream().map(n -> new ItemStack((ItemLike)n.get().m_5456_()));
        return Ingredient.m_43921_(stream);
    }

    private static Ingredient getParentIngredients(BlockNode node) {
        Stream<ItemStack> stream = node.getParents().stream().map(n -> new ItemStack((ItemLike)n.get().m_5456_()));
        return Ingredient.m_43921_(stream);
    }

    private static ResourceLocation modId(String name) {
        return new ResourceLocation("architects_palette", name);
    }

    private static int getStoneCuttingCount(BlockNode.BlockType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BlockNode.BlockType.BASE, BlockNode.BlockType.CRACKED, BlockNode.BlockType.MOSSY, BlockNode.BlockType.LAMP, BlockNode.BlockType.DARK, BlockNode.BlockType.SPECIAL -> 0;
            case BlockNode.BlockType.BRICKS, BlockNode.BlockType.FENCE, BlockNode.BlockType.TILES, BlockNode.BlockType.CHISELED, BlockNode.BlockType.PILLAR, BlockNode.BlockType.STAIRS, BlockNode.BlockType.WALL, BlockNode.BlockType.PLATING -> 1;
            case BlockNode.BlockType.NUB, BlockNode.BlockType.SLAB, BlockNode.BlockType.VERTICAL_SLAB -> 2;
        };
    }

    private static void brickRecipe(ItemLike result, ItemLike ingredient, int count, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)result, (int)count).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), ingredient).m_142284_(APRecipes.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)ingredient)).m_176498_(consumer);
    }
}

