/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class WitheredBoneLootModifier
extends LootModifier {
    private final Item replacedItem;
    private final Item boneItem;
    public static final Serializer SERIALIZER = new Serializer();

    protected WitheredBoneLootModifier(LootItemCondition[] conditionsIn, Item replacedItem, Item boneItem) {
        super(conditionsIn);
        this.replacedItem = replacedItem;
        this.boneItem = boneItem;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity t = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (t == null) {
            return generatedLoot;
        }
        if (t instanceof WitherSkeleton) {
            int amountOfBones = 0;
            for (ItemStack i2 : generatedLoot) {
                if (i2.m_41720_() != this.replacedItem) continue;
                amountOfBones += i2.m_41613_();
            }
            generatedLoot.removeIf(i -> i.m_41720_() == this.replacedItem);
            generatedLoot.add(new ItemStack((ItemLike)this.boneItem, amountOfBones));
        }
        return generatedLoot;
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<WitheredBoneLootModifier> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("architects_palette", "wither_skeleton_bones"));
        }

        public WitheredBoneLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            String boneItem = GsonHelper.m_13906_((JsonObject)object, (String)"bone");
            String replacedItem = GsonHelper.m_13906_((JsonObject)object, (String)"replaces");
            Item witheredBone = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(boneItem));
            Item bone = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(replacedItem));
            return new WitheredBoneLootModifier(ailootcondition, bone, witheredBone);
        }

        public JsonObject write(WitheredBoneLootModifier instance) {
            JsonObject obj = instance.conditions.length > 0 ? this.makeConditions(instance.conditions) : new JsonObject();
            obj.addProperty("bone", instance.boneItem.getRegistryName().toString());
            obj.addProperty("replaces", instance.replacedItem.getRegistryName().toString());
            return obj;
        }
    }
}

