/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.curios;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.curios.BackpackCurioRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosCompat
implements ICompat {
    private Set<String> backpackCurioIdentifiers = new HashSet<String>();
    private long lastTagsRefresh = -1L;
    private static final int TAGS_REFRESH_COOLDOWN = 100;

    public CuriosCompat() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::sendImc);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            CuriosRendererRegistry.register((Item)((Item)ModItems.BACKPACK.get()), BackpackCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ModItems.IRON_BACKPACK.get()), BackpackCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ModItems.GOLD_BACKPACK.get()), BackpackCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ModItems.DIAMOND_BACKPACK.get()), BackpackCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ModItems.NETHERITE_BACKPACK.get()), BackpackCurioRenderer::new);
        });
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addGenericListener(ItemStack.class, this::onAttachCapabilities);
        this.addPlayerInventoryHandlers();
    }

    private void addPlayerInventoryHandlers() {
        PlayerInventoryProvider.get().addPlayerInventoryHandler("curios", this::getCurioTags, (player, identifier) -> CuriosCompat.getFromCuriosSlotStackHandler((LivingEntity)player, identifier, ICurioStacksHandler::getSlots, 0), (player, identifier, slot) -> CuriosCompat.getFromCuriosSlotStackHandler((LivingEntity)player, identifier, sh -> sh.getStacks().getStackInSlot(slot), ItemStack.f_41583_), false, true, true, true);
    }

    private Set<String> getCurioTags(long gameTime) {
        if (this.lastTagsRefresh + 100L < gameTime) {
            this.lastTagsRefresh = gameTime;
            this.backpackCurioIdentifiers = new HashSet<String>(CuriosApi.getCuriosHelper().getCurioTags((Item)ModItems.BACKPACK.get()));
            this.backpackCurioIdentifiers.add(SlotTypePreset.CURIO.getIdentifier());
        }
        return this.backpackCurioIdentifiers;
    }

    public static <T> T getFromCuriosSlotStackHandler(LivingEntity livingEntity, String identifier, Function<ICurioStacksHandler, T> getFromHandler, T defaultValue) {
        return CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(h -> h.getStacksHandler(identifier).map(getFromHandler).orElse(defaultValue)).orElse(defaultValue);
    }

    private void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    public void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        final ItemStack stack = (ItemStack)evt.getObject();
        Item item = stack.m_41720_();
        if (item.getRegistryName() != null && item.getRegistryName().m_135827_().equals("sophisticatedbackpacks") && item instanceof BackpackItem) {
            evt.addCapability(new ResourceLocation("sophisticatedbackpacks", item.getRegistryName().m_135815_() + "_curios"), new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(() -> () -> stack));
                }
            });
        }
    }

    public void setup() {
    }
}

