/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.ChillerRecipeManager;
import cofh.thermal.expansion.init.TExpTileEntities;
import cofh.thermal.expansion.inventory.container.machine.MachineChillerContainer;
import cofh.thermal.lib.tileentity.MachineTileBase;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.references.ThermalTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class MachineChillerTile
extends MachineTileBase {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || this.filter.valid(item) && ChillerRecipeManager.instance().validItem(item));
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH inputTank = new FluidStorageCoFH(8000, fluid -> this.filter.valid(fluid) && ChillerRecipeManager.instance().validFluid(fluid));

    public MachineChillerTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpTileEntities.MACHINE_CHILLER_TILE.get(), pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.inputTank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return ChillerRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = ChillerRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
            this.fluidInputCounts = this.curRecipe.getInputFluidCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.inputTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    protected void resolveInputs() {
        if (!this.itemInputCounts.isEmpty() && !this.inputSlot.getItemStack().m_204117_(ThermalTags.Items.MACHINE_CASTS)) {
            this.inputSlot.modify(-((Integer)this.itemInputCounts.get(0)).intValue());
        }
        for (int i = 0; i < this.fluidInputCounts.size(); ++i) {
            ((FluidStorageCoFH)this.inputTanks().get(i)).modify(-((Integer)this.fluidInputCounts.get(i)).intValue());
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachineChillerContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }
}

