/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.util.managers.machine.RefineryRecipeManager;
import cofh.thermal.expansion.init.TExpTileEntities;
import cofh.thermal.expansion.inventory.container.machine.MachineRefineryContainer;
import cofh.thermal.lib.tileentity.MachineTileBase;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class MachineRefineryTile
extends MachineTileBase {
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH inputTank = new FluidStorageCoFH(4000, fluid -> this.filter.valid(fluid) && RefineryRecipeManager.instance().validRecipe(fluid));
    protected FluidStorageCoFH outputTankA = new FluidStorageCoFH(8000);
    protected FluidStorageCoFH outputTankB = new FluidStorageCoFH(8000);

    public MachineRefineryTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpTileEntities.MACHINE_REFINERY_TILE.get(), pos, state);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.inputTank, StorageGroup.INPUT);
        this.tankInv.addTank(this.outputTankA, StorageGroup.OUTPUT);
        this.tankInv.addTank(this.outputTankB, StorageGroup.OUTPUT);
        this.renderFluid = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return RefineryRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = RefineryRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.fluidInputCounts = this.curRecipe.getInputFluidCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inputTank.isEmpty()) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.inputTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachineRefineryContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputTank.getAmount() >= (Integer)this.fluidInputCounts.get(0);
    }
}

