/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.mixin.AccessorItemEntity;

public class RenderTileCorporeaCrystalCube
implements BlockEntityRenderer<TileCorporeaCrystalCube> {
    public static BakedModel cubeModel = null;
    private ItemEntity entity = null;
    private final BlockRenderDispatcher blockRenderDispatcher;

    public RenderTileCorporeaCrystalCube(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.m_173584_();
    }

    public void render(@Nullable TileCorporeaCrystalCube cube, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ItemStack stack = ItemStack.f_41583_;
        if (cube != null) {
            if (this.entity == null) {
                this.entity = new ItemEntity(cube.m_58904_(), (double)cube.m_58899_().m_123341_(), (double)cube.m_58899_().m_123342_(), (double)cube.m_58899_().m_123343_(), new ItemStack((ItemLike)Blocks.f_50069_));
            }
            ((AccessorItemEntity)this.entity).setAge(ClientTickHandler.ticksInGame);
            stack = cube.getRequestTarget();
            this.entity.m_32045_(stack);
        }
        double time = (float)ClientTickHandler.ticksInGame + f;
        double worldTicks = cube == null || cube.m_58904_() == null ? 0.0 : time;
        Minecraft mc = Minecraft.m_91087_();
        ms.m_85836_();
        ms.m_85837_(0.5, 1.5, 0.5);
        ms.m_85841_(1.0f, -1.0f, -1.0f);
        ms.m_85837_(0.0, (double)((float)Math.sin(worldTicks / 20.0 * 1.55) * 0.025f), 0.0);
        if (!stack.m_41619_()) {
            ms.m_85836_();
            float s = stack.m_41720_() instanceof BlockItem ? 0.7f : 0.5f;
            ms.m_85837_(0.0, (double)0.8f, 0.0);
            ms.m_85841_(s, s, s);
            ms.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            Minecraft.m_91087_().m_91290_().m_114382_((Entity)this.entity).m_7392_((Entity)this.entity, 0.0f, f, ms, buffers, light);
            ms.m_85849_();
        }
        if (cubeModel != null) {
            ms.m_85836_();
            ms.m_85837_(-0.5, 0.25, -0.5);
            VertexConsumer buffer = buffers.m_6299_(Sheets.m_110792_());
            this.blockRenderDispatcher.m_110937_().m_111067_(ms.m_85850_(), buffer, null, cubeModel, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.m_85849_();
        }
        if (!stack.m_41619_()) {
            int count = cube.getItemCount();
            String countStr = "" + count;
            int color = 0xFFFFFF;
            if (count > 9999) {
                countStr = count / 1000 + "K";
                color = 0xFFFF00;
                if (count > 9999999) {
                    countStr = count / 10000000 + "M";
                    color = 65280;
                }
            }
            int colorShade = ((color |= 0xA0000000) & 0xFCFCFC) >> 2 | color & 0xFF000000;
            float s = 0.015625f;
            ms.m_85841_(s, s, s);
            int l = mc.f_91062_.m_92895_(countStr);
            ms.m_85837_(0.0, 55.0, 0.0);
            float tr = -16.5f;
            for (int i = 0; i < 4; ++i) {
                ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                ms.m_85837_(0.0, 0.0, (double)tr);
                mc.f_91062_.m_92811_(countStr, (float)(-l / 2), 0.0f, color, false, ms.m_85850_().m_85861_(), buffers, false, 0, light);
                ms.m_85837_(0.0, 0.0, (double)0.1f);
                mc.f_91062_.m_92811_(countStr, (float)(-l / 2 + 1), 1.0f, colorShade, false, ms.m_85850_().m_85861_(), buffers, false, 0, light);
                ms.m_85837_(0.0, 0.0, (double)(-tr - 0.1f));
            }
        }
        ms.m_85849_();
    }
}

