/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.model.ModModelLayers;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;

public class RenderTileCorporeaIndex
implements BlockEntityRenderer<TileCorporeaIndex> {
    private static final RenderType LAYER = RenderType.m_110458_((ResourceLocation)new ResourceLocation("botania:textures/model/corporea_index.png"));
    private static final float ANGLE = (float)Math.sin(Math.toRadians(45.0));
    private final ModelPart ring;
    private final ModelPart cube;

    public RenderTileCorporeaIndex(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = ctx.m_173582_(ModModelLayers.CORPOREA_INDEX);
        this.ring = root.m_171324_("ring");
        this.cube = root.m_171324_("cube");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("ring", CubeListBuilder.m_171558_().m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        root.m_171599_("cube", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return mesh;
    }

    public boolean shouldRenderOffScreen(@Nonnull TileCorporeaIndex blockEntity) {
        return true;
    }

    public void render(@Nullable TileCorporeaIndex index, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float translation;
        ms.m_85836_();
        ms.m_85837_(0.5, 0.0, 0.5);
        float rotation = ((float)ClientTickHandler.ticksInGame + partialTicks) * 2.0f;
        if (index == null) {
            ms.m_85841_(1.3f, 1.3f, 1.3f);
            ms.m_85837_(0.0, -0.1, 0.0);
            translation = 0.0f;
        } else {
            translation = (float)((Math.cos(((float)index.ticksWithCloseby + (index.hasCloseby ? partialTicks : 0.0f)) / 10.0f) * 0.5 + 0.5) * 0.25);
        }
        VertexConsumer buffer = buffers.m_6299_(LAYER);
        ms.m_85836_();
        ms.m_85837_(0.0, -1.0, 0.0);
        ms.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        ms.m_85837_(0.0, (double)(1.5f + translation / 2.0f), 0.0);
        ms.m_85845_(new Quaternion(new Vector3f(ANGLE, 0.0f, ANGLE), 60.0f, true));
        this.ring.m_104301_(ms, buffer, light, overlay);
        ms.m_85841_(0.875f, 0.875f, 0.875f);
        ms.m_85845_(new Quaternion(new Vector3f(ANGLE, 0.0f, ANGLE), 60.0f, true));
        ms.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        this.ring.m_104301_(ms, buffer, light, overlay);
        ms.m_85841_(0.875f, 0.875f, 0.875f);
        ms.m_85845_(new Quaternion(new Vector3f(ANGLE, 0.0f, ANGLE), 60.0f, true));
        ms.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        this.cube.m_104301_(ms, buffer, light, overlay);
        ms.m_85849_();
        if (index != null && index.closeby > 0.0f) {
            float starScale = 0.02f;
            float starRadius = 2.5f * index.closeby + (index.closeby == 1.0f ? 0.0f : (index.hasCloseby ? partialTicks : -partialTicks)) * 0.2f;
            double rads = (double)(((float)index.ticksWithCloseby + partialTicks) * 2.0f) * Math.PI / 180.0;
            double starX = Math.cos(rads) * (double)starRadius;
            double starZ = Math.sin(rads) * (double)starRadius;
            int color = 0xFF00FF;
            int seed = index.m_58899_().m_123341_() ^ index.m_58899_().m_123342_() ^ index.m_58899_().m_123343_();
            ms.m_85837_(starX, 0.3, starZ);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
            ms.m_85837_(-starX * 2.0, 0.0, -starZ * 2.0);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
            ms.m_85837_(starX, 0.0, starZ);
            rads = -rads;
            starX = Math.cos(rads) * (double)starRadius;
            starZ = Math.sin(rads) * (double)starRadius;
            ms.m_85837_(starX, 0.0, starZ);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
            ms.m_85837_(-starX * 2.0, 0.0, -starZ * 2.0);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
            ms.m_85837_(starX, 0.0, starZ);
        }
        ms.m_85849_();
    }
}

