/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class BlockOpenCrate
extends BlockMod
implements EntityBlock {
    protected BlockOpenCrate(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!newState.m_60713_(state.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof TileSimpleInventory) {
                TileSimpleInventory inventory = (TileSimpleInventory)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        if (world.m_46753_(pos) && rand.nextDouble() < 0.2) {
            BlockOpenCrate.redstoneParticlesOnFullBlock(world, pos, rand);
        }
    }

    public static void redstoneParticlesOnFullBlock(Level world, BlockPos pos, Random random) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_142300_(direction);
            if (world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos)) continue;
            Direction.Axis axis = direction.m_122434_();
            double dx = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.nextFloat();
            double dy = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)random.nextFloat();
            double dz = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.nextFloat();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + dx, (double)pos.m_123342_() + dy, (double)pos.m_123343_() + dz, 0.0, 0.0, 0.0);
        }
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileOpenCrate(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.f_46443_) {
            return BlockOpenCrate.createTickerHelper(type, ModTiles.OPEN_CRATE, TileOpenCrate::serverTick);
        }
        return null;
    }
}

