/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.TileTinyPotato;

public class BlockTinyPotato
extends BlockModWaterloggable
implements EntityBlock {
    private static final VoxelShape SHAPE = BlockTinyPotato.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public BlockTinyPotato(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileTinyPotato) {
            TileTinyPotato tater = (TileTinyPotato)blockEntity;
            return AbstractContainerMenu.m_38938_((Container)tater);
        }
        return 0;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof TileSimpleInventory) {
                TileSimpleInventory inventory = (TileSimpleInventory)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileTinyPotato) {
            TileTinyPotato tater = (TileTinyPotato)tile;
            tater.interact(player, hand, player.m_21120_(hand), hit.m_82434_());
            if (!world.f_46443_) {
                BlockTinyPotato.spawnHearts((ServerLevel)world, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static void spawnHearts(ServerLevel level, BlockPos pos) {
        AABB box = SHAPE.m_83215_();
        level.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)pos.m_123341_() + box.f_82288_ + Math.random() * (box.f_82291_ - box.f_82288_), (double)pos.m_123342_() + box.f_82292_, (double)pos.m_123343_() + box.f_82290_ + Math.random() * (box.f_82293_ - box.f_82290_), 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    @Nonnull
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)ctx.m_8125_().m_122424_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity living, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof TileTinyPotato) {
            TileTinyPotato tater = (TileTinyPotato)blockEntity;
            tater.name = stack.m_41786_();
        }
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileTinyPotato(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockTinyPotato.createTickerHelper(type, ModTiles.TINY_POTATO, TileTinyPotato::commonTick);
    }
}

