/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IPoolOverlayProvider;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BlockMod;

public class BlockManaVoid
extends BlockMod
implements IPoolOverlayProvider {
    private static final int SPARKLE_EVENT = 0;

    public BlockManaVoid(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Override
    public ResourceLocation getIcon(Level world, BlockPos pos) {
        return MiscellaneousModels.INSTANCE.manaVoidOverlay.m_119203_();
    }

    @Override
    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int payload) {
        if (id == 0) {
            if (level.f_46443_) {
                for (int i = 0; i < 10; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle(0.7f + 0.5f * (float)Math.random(), 0.2f, 0.2f, 0.2f, 5);
                    level.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return super.m_8133_(state, level, pos, id, payload);
    }

    public static class ManaReceiver
    implements IManaReceiver {
        private final Level level;
        private final BlockPos pos;
        private final BlockState state;

        public ManaReceiver(Level level, BlockPos pos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        @Override
        public Level getManaReceiverLevel() {
            return this.level;
        }

        @Override
        public BlockPos getManaReceiverPos() {
            return this.pos;
        }

        @Override
        public int getCurrentMana() {
            return 0;
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public void receiveMana(int mana) {
            if (mana > 0) {
                this.level.m_7696_(this.pos, this.state.m_60734_(), 0, 0);
            }
        }

        @Override
        public boolean canReceiveManaFromBursts() {
            return true;
        }
    }
}

