/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileSolegnolia
extends TileEntityFunctionalFlower {
    private static final double RANGE = 5.0;
    private static final double RANGE_MINI = 1.0;
    private static final Set<SubTileSolegnolia> existingFlowers = Collections.newSetFromMap(new MapMaker().concurrencyLevel(2).weakKeys().makeMap());

    protected SubTileSolegnolia(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SubTileSolegnolia(BlockPos pos, BlockState state) {
        this(ModSubtiles.SOLEGNOLIA, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!existingFlowers.contains(this)) {
            existingFlowers.add(this);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        existingFlowers.remove(this);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public static boolean hasSolegnoliaAround(Entity e) {
        return existingFlowers.stream().filter(f -> f.redstoneSignal == 0).filter(f -> f.m_58904_() == e.f_19853_).anyMatch(f -> f.getEffectivePos().m_203198_(e.m_20185_(), e.m_20186_(), e.m_20189_()) <= f.getRange() * f.getRange());
    }

    @Override
    public int getMaxMana() {
        return 1;
    }

    @Override
    public int getColor() {
        return 13212749;
    }

    public double getRange() {
        return 5.0;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends SubTileSolegnolia {
        public Mini(BlockPos pos, BlockState state) {
            super(ModSubtiles.SOLEGNOLIA_CHIBI, pos, state);
        }

        @Override
        public double getRange() {
            return 1.0;
        }
    }
}

