/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TileSpawnerClaw
extends TileMod
implements IManaReceiver {
    private static final String TAG_MANA = "mana";
    private static final int MAX_MANA = 160;
    private int mana = 0;

    public TileSpawnerClaw(BlockPos pos, BlockState state) {
        super(ModTiles.SPAWNER_CLAW, pos, state);
    }

    public static void onSpawnerNearPlayer(Level level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockEntity be;
        if (!level.m_8055_(pos).m_60713_(Blocks.f_50085_)) {
            return;
        }
        BlockPos up = pos.m_7494_();
        if (level.m_8055_(up).m_60713_(ModBlocks.spawnerClaw) && (be = level.m_7702_(pos.m_7494_())) instanceof TileSpawnerClaw) {
            TileSpawnerClaw claw = (TileSpawnerClaw)be;
            if (claw.mana > 5) {
                claw.receiveMana(-6);
                if (level.f_46443_ && Math.random() > 0.5) {
                    WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, 0.6f - (float)Math.random() * 0.3f, 0.1f, 0.6f - (float)Math.random() * 0.3f, 2.0f);
                    level.m_7106_((ParticleOptions)data, (double)up.m_123341_() + 0.3 + Math.random() * 0.5, (double)up.m_123342_() - 0.3 + Math.random() * 0.25, (double)up.m_123343_() + Math.random(), 0.0, (double)(-(-0.025f - 0.005f * (float)Math.random())), 0.0);
                }
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.mana = cmp.m_128451_(TAG_MANA);
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= 160;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(480, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }
}

