/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;

public class KeepIvyRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<KeepIvyRecipe> SERIALIZER = new SimpleRecipeSerializer(KeepIvyRecipe::new);

    public KeepIvyRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundIvy = false;
        boolean foundItem = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(ModItems.keepIvy)) {
                foundIvy = true;
                continue;
            }
            if (!(foundItem || stack.m_41782_() && ItemNBTHelper.getBoolean(stack, "Botania_keepIvy", false) || stack.m_41720_().m_41470_())) {
                foundItem = true;
                continue;
            }
            return false;
        }
        return foundIvy && foundItem;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack item = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || stack.m_150930_(ModItems.keepIvy)) continue;
            item = stack;
        }
        ItemStack copy = item.m_41777_();
        ItemNBTHelper.setBoolean(copy, "Botania_keepIvy", true);
        copy.m_41764_(1);
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

