/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketDumper;
import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.integration.crafttweaker.natives.ExpandBrew;

@ZenRegister
@ZenCodeType.Name(value="mods.botania.BracketHandlers")
@Document(value="mods/Botania/BracketHandlers")
public final class BracketHandlers {
    @ZenCodeType.Method
    @BracketDumper(value="brew")
    public static Collection<String> getBrewDump() {
        return ModBrews.registry.m_123024_().map(ExpandBrew::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.Method
    @BracketResolver(value="brew")
    public static Brew getBrew(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("Brew BEP <brew:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get brew with name: <brew:" + tokens + ">! Syntax is <brew:modid:name>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        return (Brew)ModBrews.registry.m_6612_(key).orElseThrow(() -> new IllegalArgumentException("Could not get brew with name: <brew:" + tokens + ">! Brew does not appear to exist!"));
    }
}

