/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public class DelegatingCraftingRecipeHandler<T extends U, U extends V, V extends CraftingRecipe>
implements IRecipeHandler<T> {
    private final RecipeType<V> wrappedType;
    private final Supplier<IRecipeHandler<U>> delegate;
    private final Function<U, T> wrapper;

    public DelegatingCraftingRecipeHandler(RecipeType<V> wrappedType, Supplier<IRecipeHandler<U>> delegate, Function<U, T> wrapper) {
        this.wrappedType = wrappedType;
        this.delegate = delegate;
        this.wrapper = wrapper;
    }

    public String dumpToCommandString(IRecipeManager manager, T recipe) {
        return this.delegate.get().dumpToCommandString(manager, recipe);
    }

    public Optional<Function<ResourceLocation, T>> replaceIngredients(IRecipeManager manager, T recipe, List<IReplacementRule> rules) throws IRecipeHandler.ReplacementNotSupportedException {
        IRecipeHandler<U> handler = this.delegate.get();
        IRecipeManager mgr = RecipeTypeBracketHandler.getOrDefault(this.wrappedType);
        Optional function = handler.replaceIngredients(mgr, recipe, rules);
        return function.map(f -> f.andThen(this.wrapper));
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager manager, T firstRecipe, U secondRecipe) {
        return this.delegate.get().doesConflict(manager, firstRecipe, secondRecipe);
    }
}

