/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.block.CTBlockIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeMarimorphosis;
import vazkii.botania.common.integration.crafttweaker.CTPlugin;

@Document(value="mods/Botania/recipe/manager/MarimorphosisRecipeManager")
@ZenRegister
@IRecipeHandler.For(value=RecipeMarimorphosis.class)
@ZenCodeType.Name(value="mods.botania.recipe.manager.MarimorphosisRecipeManager")
public class MarimorphosisRecipeManager
implements IRecipeManager<IOrechidRecipe>,
IRecipeHandler<RecipeMarimorphosis> {
    @ZenCodeType.Method
    public void registerOreWeight(String name, CTBlockIngredient output, Block input, int weight, int weightBonus, Biome.BiomeCategory ... biomes) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = CraftTweakerConstants.rl((String)name);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)new RecipeMarimorphosis(resourceLocation, input, CTPlugin.blockIngredientToStateIngredient(output), weight, weightBonus, Arrays.stream(biomes).toList())));
    }

    @ZenCodeType.Method
    public void remove(BlockState output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> recipe.getOutput().test(output)));
    }

    public void remove(IIngredient output) {
        throw new UnsupportedOperationException("Orechid does not output IItemStacks, use remove(BlockState)!");
    }

    public RecipeType<IOrechidRecipe> getRecipeType() {
        return ModRecipeTypes.MARIMORPHOSIS_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, RecipeMarimorphosis recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".addRecipe(", ");");
        s.add(StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()));
        s.add(CTPlugin.ingredientToCommandString(recipe.getOutput()));
        s.add(ExpandBlock.getCommandString((Block)recipe.getInput()));
        s.add(String.valueOf(recipe.getWeight()));
        s.add(String.valueOf(recipe.getWeightBonus()));
        s.add(recipe.getBiomes().stream().map(biomeCategory -> "<constant:minecraft:world/biome/category:" + biomeCategory.name().toLowerCase(Locale.ENGLISH) + ">").collect(Collectors.joining(", ")));
        return s.toString();
    }

    public Optional<Function<ResourceLocation, RecipeMarimorphosis>> replaceIngredients(IRecipeManager manager, RecipeMarimorphosis recipe, List<IReplacementRule> rules) {
        return Optional.empty();
    }
}

