/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class OrechidProvider
extends BotaniaRecipeProvider {
    public OrechidProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void m_6865_(HashCache hashCache) {
        super.m_6865_(hashCache);
    }

    @Override
    protected void registerRecipes(Consumer<FinishedRecipe> consumer) {
        consumer.accept(this.stone(Blocks.f_49997_, 67415));
        consumer.accept(this.stone(Blocks.f_49996_, 29371));
        consumer.accept(this.stone(Blocks.f_50173_, 7654));
        consumer.accept(this.stone(Blocks.f_152505_, 7000));
        consumer.accept(this.stone(Blocks.f_49995_, 2647));
        consumer.accept(this.stone(Blocks.f_50264_, 1239));
        consumer.accept(this.stone(Blocks.f_50059_, 1079));
        consumer.accept(this.stone(Blocks.f_50089_, 883));
        consumer.accept(this.deepslate(Blocks.f_152469_, 75));
        consumer.accept(this.deepslate(Blocks.f_152468_, 250));
        consumer.accept(this.deepslate(Blocks.f_152473_, 150));
        consumer.accept(this.deepslate(Blocks.f_152506_, 75));
        consumer.accept(this.deepslate(Blocks.f_152467_, 125));
        consumer.accept(this.deepslate(Blocks.f_152479_, 50));
        consumer.accept(this.deepslate(Blocks.f_152472_, 175));
        consumer.accept(this.deepslate(Blocks.f_152474_, 100));
        consumer.accept(this.netherrack(Blocks.f_50331_, 19600));
        consumer.accept(this.netherrack(Blocks.f_49998_, 3635));
        consumer.accept(this.netherrack(Blocks.f_50722_, 148));
        consumer.accept(this.biomeStone(ModFluffBlocks.biomeStoneForest, Biome.BiomeCategory.FOREST, Biome.BiomeCategory.TAIGA));
        consumer.accept(this.biomeStone(ModFluffBlocks.biomeStonePlains, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.BEACH));
        consumer.accept(this.biomeStone(ModFluffBlocks.biomeStoneMountain, Biome.BiomeCategory.EXTREME_HILLS, Biome.BiomeCategory.MOUNTAIN));
        consumer.accept(this.biomeStone(ModFluffBlocks.biomeStoneFungal, Biome.BiomeCategory.MUSHROOM, Biome.BiomeCategory.UNDERGROUND));
        consumer.accept(this.biomeStone(ModFluffBlocks.biomeStoneSwamp, Biome.BiomeCategory.SWAMP, Biome.BiomeCategory.JUNGLE));
        consumer.accept(this.biomeStone(ModFluffBlocks.biomeStoneDesert, Biome.BiomeCategory.DESERT, Biome.BiomeCategory.SAVANNA));
        consumer.accept(this.biomeStone(ModFluffBlocks.biomeStoneTaiga, Biome.BiomeCategory.ICY, Biome.BiomeCategory.TAIGA));
        consumer.accept(this.biomeStone(ModFluffBlocks.biomeStoneMesa, Biome.BiomeCategory.MESA, Biome.BiomeCategory.SAVANNA));
    }

    protected ResourceLocation orechidId(Block b) {
        return ResourceLocationHelper.prefix("orechid/" + Registry.f_122824_.m_7981_((Object)b).m_135815_());
    }

    protected ResourceLocation ignemId(Block b) {
        return ResourceLocationHelper.prefix("orechid_ignem/" + Registry.f_122824_.m_7981_((Object)b).m_135815_());
    }

    protected ResourceLocation marimorphosisId(Block b) {
        return ResourceLocationHelper.prefix("marimorphosis/" + Registry.f_122824_.m_7981_((Object)b).m_135815_());
    }

    protected Result stone(Block output, int weight) {
        return new Result(ModRecipeTypes.ORECHID_SERIALIZER, this.orechidId(output), Blocks.f_50069_, OrechidProvider.forBlock(output), weight);
    }

    protected Result deepslate(Block output, int weight) {
        return new Result(ModRecipeTypes.ORECHID_SERIALIZER, this.orechidId(output), Blocks.f_152550_, OrechidProvider.forBlock(output), weight);
    }

    protected Result netherrack(Block output, int weight) {
        return new Result(ModRecipeTypes.ORECHID_IGNEM_SERIALIZER, this.ignemId(output), Blocks.f_50134_, OrechidProvider.forBlock(output), weight);
    }

    protected Result biomeStone(Block output, Biome.BiomeCategory ... biomes) {
        return new BiomeResult(ModRecipeTypes.MARIMORPHOSIS_SERIALIZER, this.marimorphosisId(output), Blocks.f_50069_, OrechidProvider.forBlock(output), 1, 11, biomes);
    }

    protected static StateIngredient forBlock(Block block) {
        return StateIngredientHelper.of(block);
    }

    public String m_6055_() {
        return "Botania Orechid and Marimorphosis weight data";
    }

    protected static class Result
    implements FinishedRecipe {
        private final RecipeSerializer<? extends IOrechidRecipe> type;
        private final ResourceLocation id;
        private final Block input;
        private final StateIngredient output;
        private final int weight;

        public Result(RecipeSerializer<? extends IOrechidRecipe> type, ResourceLocation id, Block input, StateIngredient output, int weight) {
            this.type = type;
            this.id = id;
            this.input = input;
            this.output = output;
            this.weight = weight;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("input", Registry.f_122824_.m_7981_((Object)this.input).toString());
            json.add("output", (JsonElement)this.output.serialize());
            json.addProperty("weight", (Number)this.weight);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    protected static class BiomeResult
    extends Result {
        private final int bonusWeight;
        private final Biome.BiomeCategory[] categories;

        public BiomeResult(RecipeSerializer<? extends IOrechidRecipe> type, ResourceLocation id, Block input, StateIngredient output, int weight, int bonusWeight, Biome.BiomeCategory ... categories) {
            super(type, id, input, output, weight);
            this.bonusWeight = bonusWeight;
            this.categories = categories;
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            JsonArray biomes = new JsonArray();
            for (Biome.BiomeCategory category : this.categories) {
                biomes.add(category.m_7912_());
            }
            json.add("biomes", (JsonElement)biomes);
            json.addProperty("biome_bonus", (Number)this.bonusWeight);
        }
    }
}

