/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class RuneProvider
extends BotaniaRecipeProvider {
    public RuneProvider(DataGenerator gen) {
        super(gen);
    }

    public String m_6055_() {
        return "Botania runic altar recipes";
    }

    @Override
    public void registerRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        int costTier1 = 5200;
        int costTier2 = 8000;
        int costTier3 = 12000;
        Ingredient manaSteel = Ingredient.m_204132_(ModTags.Items.INGOTS_MANASTEEL);
        Ingredient manaDiamond = Ingredient.m_204132_(ModTags.Items.GEMS_MANA_DIAMOND);
        Ingredient manaPowder = Ingredient.m_204132_(ModTags.Items.DUSTS_MANA);
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("water"), new ItemStack((ItemLike)ModItems.runeWater, 2), 5200, manaPowder, manaSteel, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50130_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42523_})));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("fire"), new ItemStack((ItemLike)ModItems.runeFire, 2), 5200, manaPowder, manaSteel, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42691_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42588_})));
        Ingredient stone = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50069_});
        Ingredient coalBlock = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50353_});
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("earth"), new ItemStack((ItemLike)ModItems.runeEarth, 2), 5200, manaPowder, manaSteel, stone, coalBlock, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50072_, Blocks.f_50073_})));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("air"), new ItemStack((ItemLike)ModItems.runeAir, 2), 5200, manaPowder, manaSteel, Ingredient.m_204132_((TagKey)ItemTags.f_13172_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42402_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_})));
        Ingredient fire = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.runeFire});
        Ingredient water = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.runeWater});
        Ingredient earth = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.runeEarth});
        Ingredient air = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.runeAir});
        Ingredient sapling = Ingredient.m_204132_((TagKey)ItemTags.f_13180_);
        Ingredient leaves = Ingredient.m_204132_((TagKey)ItemTags.f_13143_);
        Ingredient sand = Ingredient.m_204132_((TagKey)ItemTags.f_13137_);
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("spring"), new ItemStack((ItemLike)ModItems.runeSpring), 8000, water, fire, sapling, sapling, sapling, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_})));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("summer"), new ItemStack((ItemLike)ModItems.runeSummer), 8000, earth, air, sand, sand, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42518_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42575_})));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("autumn"), new ItemStack((ItemLike)ModItems.runeAutumn), 8000, fire, air, leaves, leaves, leaves, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_})));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("winter"), new ItemStack((ItemLike)ModItems.runeWinter), 8000, water, earth, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50127_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50127_}), Ingredient.m_204132_((TagKey)ItemTags.f_13167_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50145_})));
        Ingredient spring = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.runeSpring});
        Ingredient summer = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.runeSummer});
        Ingredient autumn = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.runeAutumn});
        Ingredient winter = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.runeWinter});
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("mana"), new ItemStack((ItemLike)ModItems.runeMana), 8000, manaSteel, manaSteel, manaSteel, manaSteel, manaSteel, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.manaPearl})));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("lust"), new ItemStack((ItemLike)ModItems.runeLust), 12000, manaDiamond, manaDiamond, summer, air));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("gluttony"), new ItemStack((ItemLike)ModItems.runeGluttony), 12000, manaDiamond, manaDiamond, winter, fire));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("greed"), new ItemStack((ItemLike)ModItems.runeGreed), 12000, manaDiamond, manaDiamond, spring, water));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("sloth"), new ItemStack((ItemLike)ModItems.runeSloth), 12000, manaDiamond, manaDiamond, autumn, air));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("wrath"), new ItemStack((ItemLike)ModItems.runeWrath), 12000, manaDiamond, manaDiamond, winter, earth));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("envy"), new ItemStack((ItemLike)ModItems.runeEnvy), 12000, manaDiamond, manaDiamond, winter, water));
        consumer.accept(new FinishedRecipe(RuneProvider.idFor("pride"), new ItemStack((ItemLike)ModItems.runePride), 12000, manaDiamond, manaDiamond, summer, fire));
        consumer.accept(new FinishedHeadRecipe(RuneProvider.idFor("head"), new ItemStack((ItemLike)Items.f_42680_), 22500, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42678_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.pixieDust}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42696_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42656_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42436_})));
    }

    private static ResourceLocation idFor(String s) {
        return ResourceLocationHelper.prefix("runic_altar/" + s);
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack output;
        private final int mana;
        private final Ingredient[] inputs;

        protected FinishedRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
            this.id = id;
            this.output = output;
            this.mana = mana;
            this.inputs = inputs;
        }

        public void m_7917_(JsonObject json) {
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack(this.output));
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingr : this.inputs) {
                ingredients.add(ingr.m_43942_());
            }
            json.addProperty("mana", (Number)this.mana);
            json.add("ingredients", (JsonElement)ingredients);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ModRecipeTypes.RUNE_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    private static class FinishedHeadRecipe
    extends FinishedRecipe {
        private FinishedHeadRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
            super(id, output, mana, inputs);
        }

        @Override
        public RecipeSerializer<?> m_6637_() {
            return ModRecipeTypes.RUNE_HEAD_SERIALIZER;
        }
    }
}

