/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.config.AbstractConfig;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.config.ConfigLoadingStage;
import fuzs.puzzleslib.core.ModLoaderEnvironment;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigHolderImpl<C extends AbstractConfig, S extends AbstractConfig>
implements ConfigHolder<C, S> {
    @Nullable
    private final C client;
    @Nullable
    private final S server;
    private final List<Runnable> clientConfigValueCallbacks = Lists.newArrayList();
    private final List<Runnable> clientCallbacks = Lists.newArrayList();
    private final List<Runnable> serverConfigValueCallbacks = Lists.newArrayList();
    private final List<Runnable> serverCallbacks = Lists.newArrayList();
    private String clientFileName = "";
    private String serverFileName = "";
    @Nullable
    private ModConfig clientModConfig;
    @Nullable
    private ModConfig serverModConfig;
    private ConfigLoadingStage clientLoadingStage = ConfigLoadingStage.NOT_PRESENT;
    private ConfigLoadingStage serverLoadingStage = ConfigLoadingStage.NOT_PRESENT;

    ConfigHolderImpl(@NotNull Supplier<C> client, @NotNull Supplier<S> server) {
        this.client = ModLoaderEnvironment.isClient() ? (AbstractConfig)client.get() : null;
        this.server = (AbstractConfig)server.get();
    }

    private void onModConfig(ModConfig config, String modId, boolean reloading) {
        if (config.getModId().equals(modId)) {
            switch (config.getType()) {
                case CLIENT: {
                    if (config != this.clientModConfig && this.clientModConfig != null) break;
                    this.clientConfigValueCallbacks.forEach(Runnable::run);
                    this.makeClientAvailable(config);
                    this.clientCallbacks.forEach(Runnable::run);
                    break;
                }
                case SERVER: {
                    if (config != this.serverModConfig && this.serverModConfig != null) break;
                    this.serverConfigValueCallbacks.forEach(Runnable::run);
                    this.makeServerAvailable(config);
                    this.serverCallbacks.forEach(Runnable::run);
                }
            }
            PuzzlesLib.LOGGER.info("{} {} config for {}", new Object[]{reloading ? "Reloading" : "Loading", config.getType().extension(), modId});
        }
    }

    private <T> void addSaveCallback(ModConfig.Type type, ForgeConfigSpec.ConfigValue<T> entry, Consumer<T> save) {
        switch (type) {
            case CLIENT: {
                this.clientConfigValueCallbacks.add(() -> save.accept(entry.get()));
                break;
            }
            case SERVER: {
                this.serverConfigValueCallbacks.add(() -> save.accept(entry.get()));
                break;
            }
            case COMMON: {
                throw new RuntimeException("Common config type not supported");
            }
        }
    }

    public void addConfigs(String modId) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(evt -> this.onModConfig(evt.getConfig(), modId, evt instanceof ModConfigEvent.Reloading));
        this.registerConfigs(ModLoadingContext.get());
    }

    private void registerConfigs(ModLoadingContext context) {
        if (this.client != null) {
            this.addClientCallback(() -> this.client.afterConfigReload());
            this.registerConfig(context, ModConfig.Type.CLIENT, (AbstractConfig)this.client, this.clientFileName);
        }
        if (this.server != null) {
            this.addServerCallback(() -> this.server.afterConfigReload());
            this.registerConfig(context, ModConfig.Type.SERVER, (AbstractConfig)this.server, this.serverFileName);
        }
    }

    private void registerConfig(ModLoadingContext context, final ModConfig.Type type, AbstractConfig config, String fileName) {
        ConfigHolder.ConfigCallback saveCallback = new ConfigHolder.ConfigCallback(){

            @Override
            public <T> void accept(ForgeConfigSpec.ConfigValue<T> entry, Consumer<T> save) {
                ConfigHolderImpl.this.addSaveCallback(type, entry, save);
            }
        };
        ModConfig modConfig = StringUtils.isEmpty((CharSequence)fileName) ? new ModConfig(type, (IConfigSpec)this.buildSpec(config, saveCallback), context.getActiveContainer()) : new ModConfig(type, (IConfigSpec)this.buildSpec(config, saveCallback), context.getActiveContainer(), fileName);
        context.getActiveContainer().addConfig(modConfig);
        switch (type) {
            case CLIENT: {
                this.clientModConfig = modConfig;
                break;
            }
            case SERVER: {
                this.serverModConfig = modConfig;
                break;
            }
            case COMMON: {
                throw new RuntimeException("Common config type not supported");
            }
        }
    }

    private ForgeConfigSpec buildSpec(AbstractConfig config, ConfigHolder.ConfigCallback saveCallback) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        config.setupConfig(builder, saveCallback);
        return builder.build();
    }

    private void makeClientAvailable(@Nullable ModConfig modConfig) {
        ConfigLoadingStage currentLoadingStage = this.currentLoadingStage((AbstractConfig)this.client, modConfig);
        if (currentLoadingStage == ConfigLoadingStage.LOADED) {
            currentLoadingStage = ConfigLoadingStage.AVAILABLE;
        }
        this.clientLoadingStage = currentLoadingStage;
    }

    private void makeServerAvailable(@Nullable ModConfig modConfig) {
        ConfigLoadingStage currentLoadingStage = this.currentLoadingStage((AbstractConfig)this.server, modConfig);
        if (currentLoadingStage == ConfigLoadingStage.LOADED) {
            currentLoadingStage = ConfigLoadingStage.AVAILABLE;
        }
        this.serverLoadingStage = currentLoadingStage;
    }

    private ConfigLoadingStage currentLoadingStage(@Nullable AbstractConfig config, @Nullable ModConfig modConfig) {
        if (config == null) {
            return ConfigLoadingStage.NOT_PRESENT;
        }
        if (modConfig == null) {
            return ConfigLoadingStage.INITIALIZED;
        }
        if (modConfig.getConfigData() == null) {
            return ConfigLoadingStage.MISSING_DATA;
        }
        return ConfigLoadingStage.LOADED;
    }

    public ConfigHolderImpl<C, S> setClientFileName(String fileName) {
        this.clientFileName = fileName;
        return this;
    }

    public ConfigHolderImpl<C, S> setServerFileName(String fileName) {
        this.serverFileName = fileName;
        return this;
    }

    @Override
    public C client() {
        if (!this.isClientAvailable()) {
            PuzzlesLib.LOGGER.error("Calling client config when it is not yet available! This is a bug! Current loading stage: {}", (Object)this.clientLoadingStage, (Object)new Exception("Client config not yet available"));
        }
        return this.client;
    }

    @Override
    public S server() {
        if (!this.isServerAvailable()) {
            PuzzlesLib.LOGGER.error("Calling server config when it is not yet available! This is a bug! Current loading stage: {}", (Object)this.serverLoadingStage, (Object)new Exception("Server config not yet available"));
        }
        return this.server;
    }

    @Override
    public boolean isClientAvailable() {
        ConfigLoadingStage currentLoadingStage = this.currentLoadingStage((AbstractConfig)this.client, this.clientModConfig);
        if (currentLoadingStage != ConfigLoadingStage.LOADED || this.clientLoadingStage != ConfigLoadingStage.AVAILABLE) {
            this.clientLoadingStage = currentLoadingStage;
            return false;
        }
        return true;
    }

    @Override
    public boolean isServerAvailable() {
        ConfigLoadingStage currentLoadingStage = this.currentLoadingStage((AbstractConfig)this.server, this.serverModConfig);
        if (currentLoadingStage != ConfigLoadingStage.LOADED || this.serverLoadingStage != ConfigLoadingStage.AVAILABLE) {
            this.serverLoadingStage = currentLoadingStage;
            return false;
        }
        return true;
    }

    @Override
    public void addClientCallback(Runnable callback) {
        this.clientCallbacks.add(callback);
    }

    @Override
    public void addServerCallback(Runnable callback) {
        this.serverCallbacks.add(callback);
    }
}

