/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.cyclops.cyclopscore.helper.RenderHelpers;

public class WidgetScrollBar
extends AbstractWidget {
    private static final ResourceLocation SCROLLBUTTON = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final int SCROLL_BUTTON_HEIGHT = 15;
    private static final int SCROLL_BUTTON_WIDTH = 12;
    private final int x;
    private final int y;
    private final int height;
    @Nullable
    private final IScrollCallback scrollCallback;
    @Nullable
    private final Rectangle scollRegion;
    private int totalRows;
    private int visibleRows;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;

    public WidgetScrollBar(int x, int y, int height, Component narrationMessage, @Nullable IScrollCallback scrollCallback, int visibleRows) {
        this(x, y, height, narrationMessage, scrollCallback, visibleRows, null);
    }

    public WidgetScrollBar(int x, int y, int height, Component narrationMessage, @Nullable IScrollCallback scrollCallback, int visibleRows, Rectangle scollRegion) {
        super(x, y, 12, height, narrationMessage);
        this.x = x;
        this.y = y;
        this.height = height;
        this.scrollCallback = scrollCallback;
        this.scollRegion = scollRegion;
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.wasClicking = false;
        this.setVisibleRows(visibleRows);
    }

    public boolean m_5953_(double x, double y) {
        if (this.scollRegion != null && RenderHelpers.isPointInRegion(this.scollRegion, new Point((int)x, (int)y))) {
            return true;
        }
        return super.m_5953_(x, y);
    }

    public float getCurrentScroll() {
        return this.currentScroll;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (scroll != 0.0 && this.needsScrollBars()) {
            this.scrollRelative(scroll);
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        boolean flag = mouseButton == 0 || mouseButton == 1;
        int xMax = this.x + 14;
        int yMax = this.y + this.height;
        if (!this.needsScrollBars()) {
            this.scrollTo(0.0f);
            return true;
        }
        if (!this.wasClicking && flag && mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)xMax && mouseY < (double)yMax) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - (double)this.y) - 7.5f) / ((float)(yMax - this.y) - 15.0f);
            this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
            return true;
        }
        return false;
    }

    public void drawGuiContainerBackgroundLayer(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int scrollX = this.x;
        int scrollMinY = this.y;
        int scrollMaxY = scrollMinY + this.height;
        RenderHelpers.bindTexture(SCROLLBUTTON);
        this.m_93228_(matrixStack, scrollX, scrollMinY + (int)((float)(scrollMaxY - scrollMinY - 15 - 2) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
    }

    protected boolean needsScrollBars() {
        return this.getTotalRows() > this.getVisibleRows();
    }

    protected int getScrollStep() {
        return this.getTotalRows() - this.getVisibleRows();
    }

    public void scrollRelative(double step) {
        float scroll = (float)((double)this.currentScroll - step / (double)this.getScrollStep());
        scroll = Mth.m_14036_((float)scroll, (float)0.0f, (float)1.0f);
        this.scrollTo(scroll);
    }

    public void scrollTo(float scroll) {
        this.currentScroll = Math.max(0.0f, scroll);
        if (this.scrollCallback != null) {
            int firstRow = (int)((double)(scroll * (float)this.getScrollStep()) + 0.5);
            this.scrollCallback.onScroll(firstRow);
        }
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleRows(int visibleRows) {
        this.visibleRows = visibleRows;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public static interface IScrollCallback {
        public void onScroll(int var1);
    }
}

