/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeConfigProperty;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;

public class CommandConfig
implements Command<CommandSourceStack> {
    private final ModBase mod;
    private final boolean valueSet;

    public CommandConfig(ModBase mod, boolean valueSet) {
        this.mod = mod;
        this.valueSet = valueSet;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ConfigurablePropertyData property = (ConfigurablePropertyData)context.getArgument("property", ConfigurablePropertyData.class);
        if (!this.valueSet) {
            ((CommandSourceStack)context.getSource()).m_81375_().m_6352_((Component)new TextComponent(property.getConfigProperty().get().toString()), Util.f_137441_);
        } else {
            String value = (String)context.getArgument("value", String.class);
            Object newValue = Helpers.tryParse(value, property.getConfigProperty().get());
            if (newValue != null) {
                property.getConfigProperty().set(newValue);
                property.getConfigProperty().save();
                ((CommandSourceStack)context.getSource()).m_81375_().m_6352_((Component)new TranslatableComponent("chat.cyclopscore.command.updatedValue", new Object[]{property.getName(), newValue.toString()}), Util.f_137441_);
            } else {
                ((CommandSourceStack)context.getSource()).m_81375_().m_6352_((Component)new TranslatableComponent("chat.cyclopscore.command.invalidNewValue"), Util.f_137441_);
                return 1;
            }
        }
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> make(ModBase mod) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"config").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"property", (ArgumentType)new ArgumentTypeConfigProperty(mod)).executes((Command)new CommandConfig(mod, false))).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes((Command)new CommandConfig(mod, true))));
    }
}

