/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class CraftingHelpers {
    private static RecipeManager CLIENT_RECIPE_MANAGER;
    private static final LoadingCache<Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<Recipe>> CACHE_RECIPES;

    public static void load() {
        MinecraftForge.EVENT_BUS.register(CraftingHelpers.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRecipesLoaded(RecipesUpdatedEvent event) {
        CLIENT_RECIPE_MANAGER = event.getRecipeManager();
    }

    public static <C extends Container, T extends Recipe<C>> Collection<T> findRecipes(Level world, RecipeType<? extends T> recipeType) {
        return world.m_5776_() ? CraftingHelpers.getClientRecipes(recipeType) : CraftingHelpers.findServerRecipes((ServerLevel)world, recipeType);
    }

    public static RecipeManager getRecipeManager() {
        return MinecraftHelpers.isClientSide() ? (CLIENT_RECIPE_MANAGER != null ? CLIENT_RECIPE_MANAGER : Minecraft.m_91087_().m_91403_().m_105141_()) : Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_), "Server is still loading").m_7465_();
    }

    public static <C extends Container, T extends Recipe<C>> Optional<T> getServerRecipe(RecipeType<? extends T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable((Recipe)CraftingHelpers.getRecipeManager().m_44054_(recipeType).get(recipeName));
    }

    public static <C extends Container, T extends Recipe<C>> Optional<T> findServerRecipe(RecipeType<T> recipeType, C container, Level world) {
        return world.m_7465_().m_44015_(recipeType, container, world);
    }

    public static <C extends Container, T extends Recipe<C>> Collection<T> findServerRecipes(RecipeType<? extends T> recipeType) {
        return CraftingHelpers.findServerRecipes(Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_)), recipeType);
    }

    public static <C extends Container, T extends Recipe<C>> Collection<T> findServerRecipes(ServerLevel world, RecipeType<? extends T> recipeType) {
        return world.m_7465_().m_44054_(recipeType).values();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends Container, T extends Recipe<C>> Optional<T> getClientRecipe(RecipeType<? extends T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable((Recipe)CraftingHelpers.getRecipeManager().m_44054_(recipeType).get(recipeName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends Container, T extends Recipe<C>> Collection<T> getClientRecipes(RecipeType<? extends T> recipeType) {
        return CraftingHelpers.getRecipeManager().m_44054_(recipeType).values();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends Container, T extends Recipe<C>> T findClientRecipe(ItemStack itemStack, RecipeType<T> recipeType, int index) throws IllegalArgumentException {
        int indexAttempt = index;
        for (Recipe recipe : CraftingHelpers.getClientRecipes(recipeType)) {
            if (!ItemStack.m_41746_((ItemStack)recipe.m_8043_(), (ItemStack)itemStack) || indexAttempt-- != 0) continue;
            return (T)recipe;
        }
        throw new IllegalArgumentException("Could not find recipe for " + itemStack + "::" + itemStack.m_41783_() + " with index " + index);
    }

    public static <C extends Container, T extends Recipe<C>> Optional<T> findRecipeCached(RecipeType<T> recipeType, C inventoryCrafting, Level world, boolean uniqueInventory) {
        return (Optional)CACHE_RECIPES.getUnchecked((Object)Triple.of(recipeType, (Object)new CacheableCraftingInventory(inventoryCrafting, !uniqueInventory), (Object)world.m_46472_().m_135782_()));
    }

    static {
        CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<Recipe>>(){

            public Optional<Recipe> load(Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation> key) throws Exception {
                ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)((ResourceLocation)key.getRight())));
                return world.m_7465_().m_44015_((RecipeType)key.getLeft(), ((CacheableCraftingInventory)key.getMiddle()).getInventoryCrafting(), (Level)world);
            }
        });
    }

    public static class CacheableCraftingInventory {
        private final Container inventoryCrafting;

        public CacheableCraftingInventory(Container inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                int width = inventoryCrafting.m_6643_();
                int height = 1;
                if (inventoryCrafting instanceof CraftingContainer) {
                    width = ((CraftingContainer)inventoryCrafting).m_39347_();
                    height = ((CraftingContainer)inventoryCrafting).m_39346_();
                }
                this.inventoryCrafting = new CraftingContainer(new AbstractContainerMenu(null, 0){

                    public boolean m_6875_(Player playerIn) {
                        return false;
                    }
                }, width, height);
                for (int i = 0; i < inventoryCrafting.m_6643_(); ++i) {
                    this.inventoryCrafting.m_6836_(i, inventoryCrafting.m_8020_(i).m_41777_());
                }
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public Container getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableCraftingInventory)) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().m_6643_(); ++i) {
                if (ItemStack.m_41746_((ItemStack)this.getInventoryCrafting().m_8020_(i), (ItemStack)((CacheableCraftingInventory)obj).getInventoryCrafting().m_8020_(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().m_6643_();
            for (int i = 0; i < this.getInventoryCrafting().m_6643_(); ++i) {
                hash <<= 1;
                hash |= ItemStackHelpers.getItemStackHashCode(this.getInventoryCrafting().m_8020_(i));
            }
            return hash;
        }
    }
}

