/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;

public final class ItemStackHelpers {
    private static final Random RANDOM = new Random();

    public static void spawnItemStack(Level world, BlockPos pos, ItemStack itemStack) {
        ItemStackHelpers.spawnItemStack(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), itemStack);
    }

    public static void spawnItemStack(Level world, double x, double y, double z, ItemStack itemStack) {
        float offsetX = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetY = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetZ = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (itemStack.m_41613_() > 0) {
            int i = RANDOM.nextInt(21) + 10;
            if (i > itemStack.m_41613_()) {
                i = itemStack.m_41613_();
            }
            ItemStack dropStack = itemStack.m_41777_();
            itemStack.m_41774_(i);
            dropStack.m_41764_(i);
            ItemEntity entityitem = new ItemEntity(world, x + (double)offsetX, y + (double)offsetY, z + (double)offsetZ, dropStack);
            float motion = 0.05f;
            entityitem.m_20334_(RANDOM.nextGaussian() * (double)motion, RANDOM.nextGaussian() * (double)motion + 0.2, RANDOM.nextGaussian() * (double)motion);
            world.m_7967_((Entity)entityitem);
        }
    }

    public static void spawnItemStackToPlayer(Level world, BlockPos pos, ItemStack stack, Player player) {
        if (!world.m_5776_()) {
            float f = 0.5f;
            double xo = (double)(world.f_46441_.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double yo = (double)(world.f_46441_.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double zo = (double)(world.f_46441_.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity entityitem = new ItemEntity(world, (double)pos.m_123341_() + xo, (double)pos.m_123342_() + yo, (double)pos.m_123343_() + zo, stack);
            double d0 = 8.0;
            double d1 = (player.m_20185_() - entityitem.m_20185_()) / d0;
            double d2 = (player.m_20186_() + (double)player.m_20192_() - entityitem.m_20186_()) / d0;
            double d3 = (player.m_20189_() - entityitem.m_20189_()) / d0;
            entityitem.m_20256_(entityitem.m_20184_().m_82520_(d1, d2, d3));
            entityitem.m_32061_();
            world.m_7967_((Entity)entityitem);
        }
    }

    public static boolean hasPlayerItem(Player player, Item item) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack == null || itemStack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack parseItemStack(String itemStackString) {
        String[] split = itemStackString.split(":");
        String itemName = split[0] + ":" + split[1];
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new IllegalArgumentException("Invalid ItemStack item: " + itemName);
        }
        int amount = 1;
        if (split.length > 2) {
            try {
                amount = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid ItemStack amount: " + split[2]);
            }
        }
        return new ItemStack((ItemLike)item, amount);
    }

    public static int getItemStackHashCode(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_.hashCode();
        }
        int result = 1;
        result = 37 * result + stack.m_41613_();
        result = 37 * result + stack.m_41720_().hashCode();
        return result;
    }

    public static boolean isValidCreativeTab(Item item, @Nullable CreativeModeTab itemGroup) {
        for (CreativeModeTab itemTab : item.getCreativeTabs()) {
            if (itemTab != itemGroup) continue;
            return true;
        }
        return itemGroup == null || itemGroup == CreativeModeTab.f_40754_;
    }
}

