/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.mojang.math.Vector3f;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public final class ModelHelpers {
    public static final ItemTransform THIRD_PERSON_RIGHT_HAND = new ItemTransform(new Vector3f(70.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f));
    public static final ItemTransform THIRD_PERSON_LEFT_HAND = new ItemTransform(new Vector3f(70.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f));
    public static final ItemTransform FIRST_PERSON_RIGHT_HAND = new ItemTransform(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f));
    public static final ItemTransform FIRST_PERSON_LEFT_HAND = new ItemTransform(new Vector3f(0.0f, 255.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f));
    public static final ItemTransform HEAD = ItemTransform.f_111754_;
    public static final ItemTransform GROUND = new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f));
    public static final ItemTransform FIXED = new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f));
    public static final ItemTransform GUI = new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f));
    public static final ItemTransforms DEFAULT_CAMERA_TRANSFORMS = new ItemTransforms(THIRD_PERSON_RIGHT_HAND, THIRD_PERSON_LEFT_HAND, FIRST_PERSON_RIGHT_HAND, FIRST_PERSON_LEFT_HAND, HEAD, GUI, GROUND, FIXED);
    public static final ItemTransform THIRD_PERSON_RIGHT_HAND_ITEM = new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.55f, 0.55f, 0.55f));
    public static final ItemTransform THIRD_PERSON_LEFT_HAND_ITEM = new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.55f, 0.55f, 0.55f));
    public static final ItemTransform FIRST_PERSON_RIGHT_HAND_ITEM = new ItemTransform(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.68f, 0.68f, 0.68f));
    public static final ItemTransform FIRST_PERSON_LEFT_HAND_ITEM = new ItemTransform(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.68f, 0.68f, 0.68f));
    public static final ItemTransform HEAD_ITEM = ItemTransform.f_111754_;
    public static final ItemTransform GROUND_ITEM = new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f));
    public static final ItemTransform FIXED_ITEM = new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
    public static final ItemTransform GUI_ITEM = new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
    public static final ItemTransforms DEFAULT_CAMERA_TRANSFORMS_ITEM = new ItemTransforms(THIRD_PERSON_RIGHT_HAND_ITEM, THIRD_PERSON_LEFT_HAND_ITEM, FIRST_PERSON_RIGHT_HAND_ITEM, FIRST_PERSON_LEFT_HAND_ITEM, HEAD_ITEM, GUI_ITEM, GROUND_ITEM, FIXED_ITEM);
    public static final Map<Direction, List<BakedQuad>> EMPTY_FACE_QUADS = Maps.newHashMap();

    public static BlockModel loadModelBlock(ResourceLocation modelLocation) throws IOException {
        Resource resource = Minecraft.m_91087_().m_91098_().m_142591_(new ResourceLocation(modelLocation.m_135827_(), modelLocation.m_135815_() + ".json"));
        InputStreamReader reader = new InputStreamReader(resource.m_6679_(), Charsets.UTF_8);
        return BlockModel.m_111461_((Reader)reader);
    }

    public static <T> T getSafeProperty(@Nullable IModelData modelData, ModelProperty<T> property, T fallback) {
        Object value;
        if (modelData == null) {
            return fallback;
        }
        try {
            value = modelData.getData(property);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static ItemTransforms modifyDefaultTransforms(Map<ItemTransforms.TransformType, ItemTransform> overrides) {
        return new ItemTransforms(overrides.getOrDefault(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, THIRD_PERSON_RIGHT_HAND), overrides.getOrDefault(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, THIRD_PERSON_LEFT_HAND), overrides.getOrDefault(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, FIRST_PERSON_RIGHT_HAND), overrides.getOrDefault(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, FIRST_PERSON_LEFT_HAND), overrides.getOrDefault(ItemTransforms.TransformType.HEAD, HEAD), overrides.getOrDefault(ItemTransforms.TransformType.GUI, GUI), overrides.getOrDefault(ItemTransforms.TransformType.GROUND, GROUND), overrides.getOrDefault(ItemTransforms.TransformType.FIXED, FIXED));
    }

    static {
        for (Direction facing : Direction.values()) {
            EMPTY_FACE_QUADS.put(facing, Collections.emptyList());
        }
    }
}

