/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.item.IInformationProvider;

public abstract class DamageIndicatedItemFluidContainer
extends ItemFluidContainer
implements IInformationProvider {
    protected DamageIndicatedItemComponent component;
    protected Supplier<Fluid> fluid;

    public DamageIndicatedItemFluidContainer(Item.Properties builder, int capacity, Supplier<Fluid> fluid) {
        super(builder, capacity);
        this.fluid = fluid;
        this.init();
    }

    private void init() {
        this.component = new DamageIndicatedItemComponent(this);
    }

    public void m_6787_(CreativeModeTab itemGroup, NonNullList<ItemStack> items) {
        if (!ItemStackHelpers.isValidCreativeTab((Item)this, itemGroup)) {
            return;
        }
        if (this.m_41389_(this.f_41377_)) {
            this.component.fillItemGroup(itemGroup, items, this.fluid.get());
        }
    }

    @Override
    public MutableComponent getInfo(ItemStack itemStack) {
        return this.component.getInfo(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideInformation(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY != null) {
            this.component.addInformation(itemStack, world, list, flag);
        }
        super.m_7373_(itemStack, world, list, flag);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack itemStack) {
        return this.component.getDurability(itemStack);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(stack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }

    public boolean canDrain(int amount, ItemStack itemStack) {
        IFluidHandler fluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        if (fluidHandler == null) {
            return false;
        }
        FluidStack simulatedDrain = fluidHandler.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        return simulatedDrain != null && simulatedDrain.getAmount() == amount;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new FluidHandlerItemCapacity(stack, this.capacity, this.getFluid());
    }
}

