/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public abstract class NBTClassType<T> {
    public static Map<Class<?>, NBTClassType<?>> NBTYPES = new IdentityHashMap();

    public static <T> NBTClassType<T> getClassType(Class<T> clazz) {
        return NBTYPES.get(clazz);
    }

    public static <T, I extends T> void writeNbt(Class<T> clazz, String name, I instance, CompoundTag tag) {
        NBTClassType<I> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found for " + instance + " of type " + clazz);
        }
        serializationClass.writePersistedField(name, instance, tag);
    }

    public static <T> T readNbt(Class<T> clazz, String name, CompoundTag tag) {
        NBTClassType<T> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found type " + clazz);
        }
        return serializationClass.readPersistedField(name, tag);
    }

    private static boolean isImplementsInterface(Class<?> clazz, Class<?> interfaceClazz) {
        return interfaceClazz.isAssignableFrom(clazz);
    }

    private static NBTClassType getTypeSilent(Class<?> type) {
        NBTClassType<?> action = NBTYPES.get(type);
        if (action == null) {
            for (Class<?> iface : type.getInterfaces()) {
                action = NBTYPES.get(iface);
                if (action == null) continue;
                return action;
            }
            Class<?> superClass = type.getSuperclass();
            if (superClass != null) {
                return NBTClassType.getTypeSilent(superClass);
            }
            return null;
        }
        return action;
    }

    public static NBTClassType getType(Class<?> type, Object target) {
        if (NBTClassType.isImplementsInterface(type, INBTSerializable.class)) {
            return new INBTSerializable.SelfNBTClassType(type);
        }
        NBTClassType action = NBTClassType.getTypeSilent(type);
        if (action == null) {
            throw new RuntimeException("No NBT persist action found for type " + type.getName() + " or any of its parents and interfaces in class " + target.getClass() + " for target object " + target + ".");
        }
        return action;
    }

    public static void performActionForField(INBTProvider provider, Field field, CompoundTag tag, boolean write) {
        Class<?> type = field.getType();
        String fieldName = field.getName();
        boolean wasAccessible = field.isAccessible();
        if (!wasAccessible) {
            field.setAccessible(true);
        }
        NBTClassType action = NBTClassType.getType(type, provider);
        try {
            action.persistedFieldAction(provider, field, tag, write);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not access field " + fieldName + " in " + provider.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void persistedFieldAction(INBTProvider provider, Field field, CompoundTag tag, boolean write) throws IllegalAccessException {
        String name = field.getName();
        NBTPersist annotation = field.getAnnotation(NBTPersist.class);
        boolean useDefaultValue = annotation.useDefaultValue();
        Object castTile = field.getDeclaringClass().cast(provider);
        if (write) {
            try {
                field.setAccessible(true);
                Object object = field.get(castTile);
                if (object == null) return;
                try {
                    this.writePersistedField(name, object, tag);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Something went from with the field " + field.getName() + " in " + castTile + ": " + e.getMessage());
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Can not write the field " + field.getName() + " in " + castTile + " since it does not exist. " + e.getMessage());
            }
        }
        Object object = null;
        try {
            if (tag.m_128441_(name)) {
                object = this.readPersistedField(name, tag);
                field.setAccessible(true);
                field.set(castTile, object);
                return;
            } else {
                if (!useDefaultValue) return;
                object = this.getDefaultValue();
                field.setAccessible(true);
                field.set(castTile, object);
            }
            return;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Can not read the field " + field.getName() + " as " + object + " in " + castTile + " since it does not exist OR there is a class mismatch. " + e.getMessage());
        }
    }

    public abstract void writePersistedField(String var1, T var2, CompoundTag var3);

    public abstract T readPersistedField(String var1, CompoundTag var2);

    public abstract T getDefaultValue();

    static {
        NBTYPES.put(Integer.class, new NBTClassType<Integer>(){

            @Override
            public void writePersistedField(String name, Integer object, CompoundTag tag) {
                tag.m_128405_(name, object.intValue());
            }

            @Override
            public Integer readPersistedField(String name, CompoundTag tag) {
                return tag.m_128451_(name);
            }

            @Override
            public Integer getDefaultValue() {
                return 0;
            }
        });
        NBTYPES.put(Integer.TYPE, NBTYPES.get(Integer.class));
        NBTYPES.put(Float.class, new NBTClassType<Float>(){

            @Override
            public void writePersistedField(String name, Float object, CompoundTag tag) {
                tag.m_128350_(name, object.floatValue());
            }

            @Override
            public Float readPersistedField(String name, CompoundTag tag) {
                return Float.valueOf(tag.m_128457_(name));
            }

            @Override
            public Float getDefaultValue() {
                return Float.valueOf(0.0f);
            }
        });
        NBTYPES.put(Float.TYPE, NBTYPES.get(Float.class));
        NBTYPES.put(Boolean.class, new NBTClassType<Boolean>(){

            @Override
            public void writePersistedField(String name, Boolean object, CompoundTag tag) {
                tag.m_128379_(name, object.booleanValue());
            }

            @Override
            public Boolean readPersistedField(String name, CompoundTag tag) {
                return tag.m_128471_(name);
            }

            @Override
            public Boolean getDefaultValue() {
                return false;
            }
        });
        NBTYPES.put(Boolean.TYPE, NBTYPES.get(Boolean.class));
        NBTYPES.put(String.class, new NBTClassType<String>(){

            @Override
            public void writePersistedField(String name, String object, CompoundTag tag) {
                if (object != null && !object.isEmpty()) {
                    tag.m_128359_(name, object);
                }
            }

            @Override
            public String readPersistedField(String name, CompoundTag tag) {
                return tag.m_128461_(name);
            }

            @Override
            public String getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Direction.class, new NBTClassType<Direction>(){

            @Override
            public void writePersistedField(String name, Direction object, CompoundTag tag) {
                tag.m_128405_(name, object.ordinal());
            }

            @Override
            public Direction readPersistedField(String name, CompoundTag tag) {
                return Direction.values()[tag.m_128451_(name)];
            }

            @Override
            public Direction getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Fluid.class, new NBTClassType<Fluid>(){

            @Override
            public void writePersistedField(String name, Fluid object, CompoundTag tag) {
                tag.m_128359_(name, object.getRegistryName().toString());
            }

            @Override
            public Fluid readPersistedField(String name, CompoundTag tag) {
                String fluidName = tag.m_128461_(name);
                return (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
            }

            @Override
            public Fluid getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(FluidStack.class, new NBTClassType<FluidStack>(){

            @Override
            public void writePersistedField(String name, @Nullable FluidStack object, CompoundTag tag) {
                if (object != null) {
                    CompoundTag subTag = new CompoundTag();
                    object.writeToNBT(subTag);
                    tag.m_128365_(name, (Tag)subTag);
                }
            }

            @Override
            public FluidStack readPersistedField(String name, CompoundTag tag) {
                return FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_(name));
            }

            @Override
            public FluidStack getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Tag.class, new NBTClassType<Tag>(){

            @Override
            public void writePersistedField(String name, Tag object, CompoundTag tag) {
                tag.m_128365_(name, object);
            }

            @Override
            public Tag readPersistedField(String name, CompoundTag tag) {
                return tag.m_128423_(name);
            }

            @Override
            public Tag getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Set.class, new CollectionNBTClassType<Set>(){

            @Override
            protected Set createNewCollection() {
                return Sets.newHashSet();
            }
        });
        NBTYPES.put(List.class, new CollectionNBTClassType<List>(){

            @Override
            protected List createNewCollection() {
                return Lists.newLinkedList();
            }
        });
        NBTYPES.put(Map.class, new NBTClassType<Map>(){

            @Override
            public void writePersistedField(String name, Map object, CompoundTag tag) {
                CompoundTag mapTag = new CompoundTag();
                ListTag list = new ListTag();
                boolean setKeyType = false;
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    CompoundTag entryTag = new CompoundTag();
                    11.getType(entry.getKey().getClass(), object).writePersistedField("key", entry.getKey(), entryTag);
                    if (entry.getValue() != null) {
                        11.getType(entry.getValue().getClass(), object).writePersistedField("value", entry.getValue(), entryTag);
                    }
                    list.add((Object)entryTag);
                    if (!setKeyType) {
                        setKeyType = true;
                        mapTag.m_128359_("keyType", entry.getKey().getClass().getName());
                    }
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.m_128359_("valueType", entry.getValue().getClass().getName());
                }
                mapTag.m_128365_("map", (Tag)list);
                tag.m_128365_(name, (Tag)mapTag);
            }

            @Override
            public Map readPersistedField(String name, CompoundTag tag) {
                CompoundTag mapTag = tag.m_128469_(name);
                HashMap map = Maps.newHashMap();
                ListTag list = mapTag.m_128437_("map", 10);
                if (list.size() > 0) {
                    NBTClassType keyNBTClassType;
                    NBTClassType valueNBTClassType = null;
                    try {
                        Class<?> keyType = Class.forName(mapTag.m_128461_("keyType"));
                        keyNBTClassType = 11.getType(keyType, map);
                    }
                    catch (ClassNotFoundException e) {
                        CyclopsCore.clog(org.apache.logging.log4j.Level.WARN, "No class found for NBT type map key '" + mapTag.m_128461_("keyType") + "', this could be a mod error.");
                        return map;
                    }
                    if (mapTag.m_128441_("valueType")) {
                        try {
                            Class<?> valueType = Class.forName(mapTag.m_128461_("valueType"));
                            valueNBTClassType = 11.getType(valueType, map);
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCore.clog(org.apache.logging.log4j.Level.WARN, "No class found for NBT type map value '" + mapTag.m_128461_("valueType") + "', this could be a mod error.");
                            return map;
                        }
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag entryTag = list.m_128728_(i);
                        Object key = keyNBTClassType.readPersistedField("key", entryTag);
                        Object value = null;
                        if (valueNBTClassType != null && entryTag.m_128441_("value")) {
                            value = valueNBTClassType.readPersistedField("value", entryTag);
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public Map getDefaultValue() {
                return Maps.newHashMap();
            }
        });
        NBTYPES.put(Vec3i.class, new NBTClassType<Vec3i>(){

            @Override
            public void writePersistedField(String name, Vec3i object, CompoundTag tag) {
                tag.m_128385_(name, new int[]{object.m_123341_(), object.m_123342_(), object.m_123343_()});
            }

            @Override
            public Vec3i readPersistedField(String name, CompoundTag tag) {
                int[] array = tag.m_128465_(name);
                return new Vec3i(array[0], array[1], array[2]);
            }

            @Override
            public Vec3i getDefaultValue() {
                return LocationHelpers.copyLocation(Vec3i.f_123288_);
            }
        });
        NBTYPES.put(Vec3.class, new NBTClassType<Vec3>(){

            @Override
            public void writePersistedField(String name, Vec3 object, CompoundTag tag) {
                CompoundTag vec = new CompoundTag();
                vec.m_128347_("x", object.f_82479_);
                vec.m_128347_("y", object.f_82480_);
                vec.m_128347_("z", object.f_82481_);
                tag.m_128365_(name, (Tag)vec);
            }

            @Override
            public Vec3 readPersistedField(String name, CompoundTag tag) {
                CompoundTag vec = tag.m_128469_(name);
                return new Vec3(vec.m_128459_("x"), vec.m_128459_("y"), vec.m_128459_("z"));
            }

            @Override
            public Vec3 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Pair.class, new NBTClassType<Pair>(){

            @Override
            public void writePersistedField(String name, Pair object, CompoundTag tag) {
                CompoundTag pairTag = new CompoundTag();
                CompoundTag leftTag = new CompoundTag();
                CompoundTag rightTag = new CompoundTag();
                14.getType(object.getLeft().getClass(), object).writePersistedField("element", object.getLeft(), leftTag);
                14.getType(object.getRight().getClass(), object).writePersistedField("element", object.getRight(), rightTag);
                pairTag.m_128359_("leftType", object.getLeft().getClass().getName());
                pairTag.m_128359_("rightType", object.getRight().getClass().getName());
                pairTag.m_128365_("left", (Tag)leftTag);
                pairTag.m_128365_("right", (Tag)rightTag);
                tag.m_128365_(name, (Tag)pairTag);
            }

            @Override
            public Pair readPersistedField(String name, CompoundTag tag) {
                NBTClassType rightElementNBTClassType;
                NBTClassType leftElementNBTClassType;
                CompoundTag pairTag = tag.m_128469_(name);
                CompoundTag leftTag = pairTag.m_128469_("left");
                CompoundTag rightTag = pairTag.m_128469_("right");
                try {
                    Class<?> elementType = Class.forName(pairTag.m_128461_("leftType"));
                    leftElementNBTClassType = 14.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCore.clog(org.apache.logging.log4j.Level.WARN, "No class found for NBT type Pair left element '" + pairTag.m_128461_("leftType") + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                try {
                    Class<?> elementType = Class.forName(pairTag.m_128461_("rightType"));
                    rightElementNBTClassType = 14.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCore.clog(org.apache.logging.log4j.Level.WARN, "No class found for NBT type Pair right element '" + pairTag.m_128461_("rightType") + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                Object left = leftElementNBTClassType.readPersistedField("element", leftTag);
                Object right = rightElementNBTClassType.readPersistedField("element", rightTag);
                return Pair.of(left, right);
            }

            @Override
            public Pair getDefaultValue() {
                return Pair.of(null, null);
            }
        });
        NBTYPES.put(DimPos.class, new NBTClassType<DimPos>(){

            @Override
            public void writePersistedField(String name, DimPos object, CompoundTag tag) {
                CompoundTag dimPos = new CompoundTag();
                dimPos.m_128359_("dim", object.getLevel());
                dimPos.m_128405_("x", object.getBlockPos().m_123341_());
                dimPos.m_128405_("y", object.getBlockPos().m_123342_());
                dimPos.m_128405_("z", object.getBlockPos().m_123343_());
                tag.m_128365_(name, (Tag)dimPos);
            }

            @Override
            public DimPos readPersistedField(String name, CompoundTag tag) {
                CompoundTag dimPos = tag.m_128469_(name);
                String dimensionName = dimPos.m_128461_("dim");
                ResourceKey dimensionType = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimensionName));
                return DimPos.of((ResourceKey<Level>)dimensionType, new BlockPos(dimPos.m_128451_("x"), dimPos.m_128451_("y"), dimPos.m_128451_("z")));
            }

            @Override
            public DimPos getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(ItemStack.class, new NBTClassType<ItemStack>(){

            @Override
            public void writePersistedField(String name, ItemStack object, CompoundTag tag) {
                if (object != null) {
                    tag.m_128365_(name, (Tag)object.m_41777_().m_41739_(new CompoundTag()));
                }
            }

            @Override
            public ItemStack readPersistedField(String name, CompoundTag tag) {
                return ItemStack.m_41712_((CompoundTag)tag.m_128469_(name));
            }

            @Override
            public ItemStack getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(MutableComponent.class, new NBTClassType<MutableComponent>(){

            @Override
            public void writePersistedField(String name, MutableComponent object, CompoundTag tag) {
                if (object != null) {
                    tag.m_128359_(name, Component.Serializer.m_130703_((Component)object));
                }
            }

            @Override
            public MutableComponent readPersistedField(String name, CompoundTag tag) {
                return Component.Serializer.m_130701_((String)tag.m_128461_(name));
            }

            @Override
            public MutableComponent getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(EnumFacingMap.class, new NBTClassType<EnumFacingMap>(){

            @Override
            public void writePersistedField(String name, EnumFacingMap object, CompoundTag tag) {
                CompoundTag mapTag = new CompoundTag();
                ListTag list = new ListTag();
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    CompoundTag entryTag = new CompoundTag();
                    entryTag.m_128405_("key", ((Direction)entry.getKey()).ordinal());
                    if (entry.getValue() != null) {
                        18.getType(entry.getValue().getClass(), object).writePersistedField("value", entry.getValue(), entryTag);
                    }
                    list.add((Object)entryTag);
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.m_128359_("valueType", entry.getValue().getClass().getName());
                }
                mapTag.m_128365_("map", (Tag)list);
                tag.m_128365_(name, (Tag)mapTag);
            }

            @Override
            public EnumFacingMap readPersistedField(String name, CompoundTag tag) {
                CompoundTag mapTag = tag.m_128469_(name);
                EnumFacingMap<Object> map = EnumFacingMap.newMap();
                ListTag list = mapTag.m_128437_("map", 10);
                if (list.size() > 0) {
                    NBTClassType valueNBTClassType = null;
                    if (mapTag.m_128441_("valueType")) {
                        try {
                            Class<?> valueType = Class.forName(mapTag.m_128461_("valueType"));
                            valueNBTClassType = 18.getType(valueType, map);
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCore.clog(org.apache.logging.log4j.Level.WARN, "No class found for NBT type map value '" + mapTag.m_128461_("valueType") + "', this could be a mod error.");
                            return map;
                        }
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag entryTag = list.m_128728_(i);
                        Direction key = Direction.values()[entryTag.m_128451_("key")];
                        Object value = null;
                        if (valueNBTClassType != null && entryTag.m_128441_("value")) {
                            value = valueNBTClassType.readPersistedField("value", entryTag);
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public EnumFacingMap getDefaultValue() {
                return EnumFacingMap.newMap();
            }
        });
    }

    private static abstract class CollectionNBTClassType<C extends Collection>
    extends NBTClassType<C> {
        private CollectionNBTClassType() {
        }

        protected abstract C createNewCollection();

        @Override
        public C getDefaultValue() {
            return this.createNewCollection();
        }

        @Override
        public void writePersistedField(String name, C object, CompoundTag tag) {
            CompoundTag collectionTag = new CompoundTag();
            ListTag list = new ListTag();
            boolean setTypes = false;
            for (Object element : object) {
                CompoundTag elementTag = new CompoundTag();
                CollectionNBTClassType.getType(element.getClass(), object).writePersistedField("element", element, elementTag);
                list.add((Object)elementTag);
                if (setTypes) continue;
                setTypes = true;
                collectionTag.m_128359_("elementType", element.getClass().getName());
            }
            collectionTag.m_128365_("collection", (Tag)list);
            tag.m_128365_(name, (Tag)collectionTag);
        }

        @Override
        public C readPersistedField(String name, CompoundTag tag) {
            CompoundTag collectionTag = tag.m_128469_(name);
            C collection = this.createNewCollection();
            ListTag list = collectionTag.m_128437_("collection", 10);
            if (list.size() > 0) {
                NBTClassType elementNBTClassType;
                try {
                    Class<?> elementType = Class.forName(collectionTag.m_128461_("elementType"));
                    elementNBTClassType = CollectionNBTClassType.getType(elementType, collection);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCore.clog(org.apache.logging.log4j.Level.WARN, "No class found for NBT type collection element '" + collectionTag.m_128461_("elementType") + "', this could be a mod error.");
                    return collection;
                }
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag entryTag = list.m_128728_(i);
                    Object element = elementNBTClassType.readPersistedField("element", entryTag);
                    collection.add(element);
                }
            }
            return collection;
        }
    }
}

