/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget;

import com.github.atomicblom.weirdinggadget.Settings;
import com.github.atomicblom.weirdinggadget.TicketUtils;
import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetTicket;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public final class ChunkManagerCallback {
    public static void ticketsLoaded(ImmutableCollection<WeirdingGadgetTicket> tickets, Level level) {
        for (WeirdingGadgetTicket ticket : tickets) {
            CompoundTag modData = ticket.getModData();
            if (!modData.m_128441_("blockPosition")) continue;
            TicketUtils.activateTicket(level, ticket);
        }
    }

    public static ListMultimap<String, WeirdingGadgetTicket> playerTicketsLoaded(Map<String, List<WeirdingGadgetTicket>> tickets, Level level) {
        ArrayListMultimap returnedTickets = ArrayListMultimap.create();
        if (((Boolean)Settings.SERVER.emergencyMode.get()).booleanValue()) {
            return returnedTickets;
        }
        for (Map.Entry<String, List<WeirdingGadgetTicket>> playerTicketMap : tickets.entrySet()) {
            String player = playerTicketMap.getKey();
            for (WeirdingGadgetTicket ticket : playerTicketMap.getValue()) {
                if (!TicketUtils.isTicketValid((LevelAccessor)level, ticket)) continue;
                returnedTickets.put((Object)player, (Object)ticket);
            }
        }
        return returnedTickets;
    }
}

