/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget;

import com.github.atomicblom.weirdinggadget.WeirdingGadgetMod;
import com.github.atomicblom.weirdinggadget.block.blockentity.WeirdingGadgetBlockEntity;
import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetChunkManager;
import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetTicket;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TicketUtils {
    public static boolean isTicketValid(LevelAccessor blockAccess, WeirdingGadgetTicket ticket) {
        CompoundTag modData = ticket.getModData();
        if (!modData.m_128441_("blockPosition")) {
            return false;
        }
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)modData.m_128469_("blockPosition"));
        BlockEntity te = blockAccess.m_7702_(pos);
        return te instanceof WeirdingGadgetBlockEntity;
    }

    public static void activateTicket(Level level, WeirdingGadgetTicket ticket) {
        if (!TicketUtils.isTicketValid((LevelAccessor)level, ticket)) {
            return;
        }
        CompoundTag modData = ticket.getModData();
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)modData.m_128469_("blockPosition"));
        BlockEntity te = level.m_7702_(pos);
        if (!(te instanceof WeirdingGadgetBlockEntity)) {
            WeirdingGadgetMod.LOGGER.error("Expected a Weirding Gadget Tile Entity at {}, but it was a {}", (Object)pos, (Object)te);
            return;
        }
        WeirdingGadgetBlockEntity blockEntity = (WeirdingGadgetBlockEntity)te;
        int size = modData.m_128451_("size");
        ChunkPos chunk = new ChunkPos(pos);
        int minX = chunk.f_45578_ - (int)((float)size / 2.0f);
        int maxX = chunk.f_45578_ + (int)((float)(size - 1) / 2.0f);
        int minZ = chunk.f_45579_ - (int)((float)size / 2.0f);
        int maxZ = chunk.f_45579_ + (int)((float)(size - 1) / 2.0f);
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                ChunkPos ticketChunk = new ChunkPos(x, z);
                WeirdingGadgetChunkManager.forceChunk(level, ticket, ticketChunk);
            }
        }
        blockEntity.addTicket(ticket);
        String playerName = ticket.getPlayerName();
        MinecraftServer server = level.m_142572_();
        if (server == null) {
            WeirdingGadgetMod.LOGGER.error("Expected a server to be available from Weirding Gadget Tile Entity at {}, but it was null", (Object)pos);
            return;
        }
        ServerPlayer player = TicketUtils.getOnlinePlayerByName(server, playerName);
        if (player != null) {
            blockEntity.addTrackedPlayer((Player)player);
        }
    }

    @Nullable
    public static ServerPlayer getOnlinePlayerByName(MinecraftServer server, String playerName) {
        ServerPlayer locatedPlayer = null;
        PlayerList playerList = server.m_6846_();
        for (ServerPlayer entityPlayerMP : playerList.m_11314_()) {
            if (!playerName.equals(entityPlayerMP.m_7755_().getString())) continue;
            locatedPlayer = entityPlayerMP;
            break;
        }
        return locatedPlayer;
    }
}

