/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.chunkloading;

import com.github.atomicblom.weirdinggadget.Settings;
import com.github.atomicblom.weirdinggadget.WeirdingGadgetMod;
import com.github.atomicblom.weirdinggadget.chunkloading.Type;
import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetTicket;
import com.github.atomicblom.weirdinggadget.registration.CapabilityWeirdingGadgetTicketList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class WeirdingGadgetChunkManager {
    static Marker ChunkManager = new MarkerManager.Log4jMarker("WGChunkManager");

    public static void releaseTicket(Level level, WeirdingGadgetTicket ticket) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ChunkSource chunkProvider = level.m_7726_();
        if (!(chunkProvider instanceof ServerChunkCache)) {
            throw new RuntimeException("Attempted to force a chunk on the wrong side");
        }
        ServerChunkCache chunkManager = (ServerChunkCache)chunkProvider;
        CapabilityWeirdingGadgetTicketList.TicketListData capability = (CapabilityWeirdingGadgetTicketList.TicketListData)level.getCapability(CapabilityWeirdingGadgetTicketList.TICKET_LIST_DATA).orElseThrow(() -> new RuntimeException("Missing Weirding Gadget Capability"));
        capability.removeTicket(ticket.getId());
        for (Map.Entry<Long, Ticket<ChunkPos>> vanillaTicket : ticket.getVanillaTickets()) {
            long chunkId = vanillaTicket.getKey();
            ChunkPos chunkPos = new ChunkPos(chunkId);
            WeirdingGadgetMod.LOGGER.debug(ChunkManager, "releasing ticket {} from chunk {} in {}", vanillaTicket.getValue(), (Object)level.m_46472_().getRegistryName(), (Object)chunkPos);
            chunkManager.f_8327_.m_140818_(chunkId, vanillaTicket.getValue());
            SortedArraySet ticketSet = chunkManager.f_8327_.m_140857_(chunkId);
            if (ticketSet.size() == 0) {
                ForcedChunksSavedData forcedChunksSavedData = (ForcedChunksSavedData)serverLevel.m_8895_().m_164861_(ForcedChunksSavedData::m_151483_, ForcedChunksSavedData::new, "chunks");
                WeirdingGadgetMod.LOGGER.debug(ChunkManager, "removing {} from forced chunks in {}", (Object)chunkPos, (Object)level.m_46472_().getRegistryName());
                boolean removed = forcedChunksSavedData.m_46116_().remove(chunkId);
                forcedChunksSavedData.m_77760_(removed);
                continue;
            }
            WeirdingGadgetMod.LOGGER.debug(ChunkManager, "not removing {} from forced chunks in {} because there are {} tickets left", (Object)chunkPos, (Object)level.m_46472_().getRegistryName(), (Object)ticketSet.size());
        }
    }

    @Nullable
    public static WeirdingGadgetTicket requestPlayerTicket(Object modInstance, String playerName, Level level, Type requestType) {
        Mod modAnnotation = modInstance.getClass().getAnnotation(Mod.class);
        String modName = modAnnotation.value();
        CapabilityWeirdingGadgetTicketList.TicketListData capability = (CapabilityWeirdingGadgetTicketList.TicketListData)level.getCapability(CapabilityWeirdingGadgetTicketList.TICKET_LIST_DATA).orElseThrow(() -> new RuntimeException("Missing Weirding Gadget Capability"));
        int maximumModTickets = (Integer)Settings.CHUNK_LOADER_LIMITS.maximumModTickets.get();
        if (capability.getTotalModTicketCount(modName) + 1 == maximumModTickets) {
            WeirdingGadgetMod.LOGGER.warn("Could not allocate a ticket to the mod {} because it has reached it's allotted maximum number of tickets {}", (Object)modName, (Object)maximumModTickets);
            return null;
        }
        int maximumPlayerTickets = (Integer)Settings.CHUNK_LOADER_LIMITS.maximumPlayerTickets.get();
        if (capability.getTotalPlayerTicketCount(playerName) + 1 == maximumPlayerTickets) {
            WeirdingGadgetMod.LOGGER.warn("Could not allocate a ticket to the player {} because they have already requested the maximum number of tickets {}", (Object)playerName, (Object)maximumPlayerTickets);
            return null;
        }
        return new WeirdingGadgetTicket(playerName, modName);
    }

    public static void forceChunk(Level level, WeirdingGadgetTicket ticket, ChunkPos ticketChunk) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ChunkSource chunkProvider = level.m_7726_();
        if (!(chunkProvider instanceof ServerChunkCache)) {
            throw new RuntimeException("Attempted to force a chunk on the wrong side");
        }
        ServerChunkCache chunkManager = (ServerChunkCache)chunkProvider;
        if (ticket.getChunkCount() + 1 > (Integer)Settings.CHUNK_LOADER_LIMITS.maximumChunksPerTicket.get()) {
            WeirdingGadgetMod.LOGGER.warn("Could not allocate a chunk because the maximum number of tickets has been assigned to the ticket {}", (Object)ticket);
            return;
        }
        CapabilityWeirdingGadgetTicketList.TicketListData capability = (CapabilityWeirdingGadgetTicketList.TicketListData)level.getCapability(CapabilityWeirdingGadgetTicketList.TICKET_LIST_DATA).orElseThrow(() -> new RuntimeException("Missing Weirding Gadget Capability"));
        capability.addTicket(ticket);
        Ticket<ChunkPos> existingTicket = ticket.getOrCreateTicket(ticketChunk);
        ForcedChunksSavedData forcedChunksSavedData = (ForcedChunksSavedData)serverLevel.m_8895_().m_164861_(ForcedChunksSavedData::m_151483_, ForcedChunksSavedData::new, "chunks");
        boolean added = forcedChunksSavedData.m_46116_().add(ticketChunk.m_45588_());
        if (added) {
            WeirdingGadgetMod.LOGGER.debug(ChunkManager, "Added {} to the forced chunk list of {}", (Object)ticketChunk, (Object)level.m_46472_().getRegistryName());
            serverLevel.m_6325_(ticketChunk.f_45578_, ticketChunk.f_45579_);
        }
        forcedChunksSavedData.m_77760_(added);
        chunkManager.f_8327_.m_140784_(ticketChunk.m_45588_(), existingTicket);
        WeirdingGadgetMod.LOGGER.debug(ChunkManager, "Registered {} to the ticket manager", existingTicket);
    }
}

