/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.chunkloading;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;

public class WeirdingGadgetTicket {
    public static final TicketType<ChunkPos> WEIRDING_GADGET = TicketType.m_9462_((String)"weirding_gadget", Comparator.comparingLong(ChunkPos::m_45588_));
    public static final int TICKET_LEVEL = 31;
    private final String playerName;
    private final UUID id;
    private final String modName;
    private CompoundTag modData;
    private final Map<Long, Ticket<ChunkPos>> vanillaTickets = Maps.newHashMap();

    public WeirdingGadgetTicket(String playerName, String modName) {
        this.modName = modName;
        this.id = UUID.randomUUID();
        this.playerName = playerName;
    }

    public CompoundTag getModData() {
        if (this.modData == null) {
            this.modData = new CompoundTag();
        }
        return this.modData;
    }

    public void setModData(CompoundTag modData) {
        this.modData = modData;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public Set<Map.Entry<Long, Ticket<ChunkPos>>> getVanillaTickets() {
        return this.vanillaTickets.entrySet();
    }

    public Ticket<ChunkPos> getOrCreateTicket(ChunkPos ticketChunk) {
        return this.vanillaTickets.computeIfAbsent(ticketChunk.m_45588_(), pos -> new Ticket(WEIRDING_GADGET, 31, (Object)ticketChunk, true));
    }

    public UUID getId() {
        return this.id;
    }

    public int getChunkCount() {
        return this.vanillaTickets.size();
    }

    public String getModName() {
        return this.modName;
    }

    public String toString() {
        return "WeirdingGadgetTicket{playerName='" + this.playerName + "', modName='" + this.modName + "', modData=" + this.modData + "}";
    }
}

