/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.registration;

import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetTicket;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityWeirdingGadgetTicketList {
    public static final Capability<TicketListData> TICKET_LIST_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<TicketListData>(){});

    public static class TicketListData {
        private final HashMap<UUID, WeirdingGadgetTicket> tickets = Maps.newHashMap();
        private final HashMap<String, Set<UUID>> playerTickets = Maps.newHashMap();
        private final HashMap<String, Set<UUID>> modTickets = Maps.newHashMap();

        public void addTicket(WeirdingGadgetTicket ticket) {
            if (!this.tickets.containsKey(ticket.getId())) {
                this.tickets.put(ticket.getId(), ticket);
                Set playerGadgets = this.playerTickets.computeIfAbsent(ticket.getPlayerName(), p -> Sets.newHashSet());
                playerGadgets.add(ticket.getId());
                Set modGadgets = this.modTickets.computeIfAbsent(ticket.getModName(), p -> Sets.newHashSet());
                modGadgets.add(ticket.getId());
            }
        }

        public ImmutableCollection<WeirdingGadgetTicket> getAllTickets() {
            return ImmutableList.copyOf(this.tickets.values());
        }

        public int getTotalPlayerTicketCount(String playerName) {
            Set<UUID> playerTickets = this.playerTickets.getOrDefault(playerName, Sets.newHashSet());
            return playerTickets.size();
        }

        public int getTotalModTicketCount(String modName) {
            Set<UUID> modTickets = this.modTickets.getOrDefault(modName, Sets.newHashSet());
            return modTickets.size();
        }

        public void removeTicket(UUID ticketId) {
            this.tickets.remove(ticketId);
            for (Set<UUID> playerSet : this.playerTickets.values()) {
                playerSet.remove(ticketId);
            }
            for (Set<UUID> modSet : this.modTickets.values()) {
                modSet.remove(ticketId);
            }
        }

        public ListTag writeToNBT() {
            ListTag ticketList = new ListTag();
            for (WeirdingGadgetTicket ticket : this.tickets.values()) {
                CompoundTag ticketData = new CompoundTag();
                ticketData.m_128359_("playerName", ticket.getPlayerName());
                ticketData.m_128359_("modName", ticket.getModName());
                CompoundTag modData = ticket.getModData();
                ticketData.m_128365_("data", (Tag)modData);
                ticketList.add((Object)ticketData);
            }
            return ticketList;
        }

        public void readFromNBT(ListTag tagList) {
            for (Tag tag : tagList) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag ticketData = (CompoundTag)tag;
                String playerName = ticketData.m_128461_("playerName");
                String modName = ticketData.m_128461_("modName");
                WeirdingGadgetTicket ticket = new WeirdingGadgetTicket(playerName, modName);
                ticket.setModData(ticketData.m_128469_("data"));
                this.addTicket(ticket);
            }
        }
    }

    public static class WeirdingGadgetTicketListProvider
    implements ICapabilityProvider,
    INBTSerializable<ListTag> {
        final TicketListData data = new TicketListData();
        final LazyOptional<TicketListData> opt = LazyOptional.of(() -> this.data);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            return capability == TICKET_LIST_DATA ? this.opt.cast() : LazyOptional.empty();
        }

        public ListTag serializeNBT() {
            return this.data.writeToNBT();
        }

        public void deserializeNBT(ListTag nbt) {
            this.data.readFromNBT(nbt);
        }
    }
}

