/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.info.WorldgenRegistryDumpReport;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ConfiguredStructureTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraftforge.data.loading.DatagenModLoader;

public class Main {
    @DontObfuscate
    public static void main(String[] p_129669_) throws IOException {
        SharedConstants.m_142977_();
        OptionParser optionparser = new OptionParser();
        AbstractOptionSpec optionspec = optionparser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionspec1 = optionparser.accepts("server", "Include server generators");
        OptionSpecBuilder optionspec2 = optionparser.accepts("client", "Include client generators");
        OptionSpecBuilder optionspec3 = optionparser.accepts("dev", "Include development tools");
        OptionSpecBuilder optionspec4 = optionparser.accepts("reports", "Include data reports");
        OptionSpecBuilder optionspec5 = optionparser.accepts("validate", "Validate inputs");
        OptionSpecBuilder optionspec6 = optionparser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionspec7 = optionparser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("input", "Input folder").withRequiredArg();
        ArgumentAcceptingOptionSpec existing = optionparser.accepts("existing", "Existing resource packs that generated resources can reference").withRequiredArg();
        ArgumentAcceptingOptionSpec existingMod = optionparser.accepts("existing-mod", "Existing mods that generated resources can reference the resource packs of").withRequiredArg();
        ArgumentAcceptingOptionSpec gameDir = optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]).required();
        ArgumentAcceptingOptionSpec mod = optionparser.accepts("mod", "A modid to dump").withRequiredArg().withValuesSeparatedBy(",");
        OptionSpecBuilder flat = optionparser.accepts("flat", "Do not append modid prefix to output directory when generating for multiple mods");
        ArgumentAcceptingOptionSpec assetIndex = optionparser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec assetsDir = optionparser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        OptionSet optionset = optionparser.parse(p_129669_);
        if (!(optionset.has((OptionSpec)optionspec) || !optionset.hasOptions() || optionset.specs().size() == 1 && optionset.has((OptionSpec)gameDir))) {
            Path path = Paths.get((String)optionspec7.value(optionset), new String[0]);
            boolean flag = optionset.has((OptionSpec)optionspec6);
            boolean flag1 = flag || optionset.has((OptionSpec)optionspec2);
            boolean flag2 = flag || optionset.has((OptionSpec)optionspec1);
            boolean flag3 = flag || optionset.has((OptionSpec)optionspec3);
            boolean flag4 = flag || optionset.has((OptionSpec)optionspec4);
            boolean flag5 = flag || optionset.has((OptionSpec)optionspec5);
            Collection inputs = optionset.valuesOf((OptionSpec)optionspec8).stream().map(p_129659_ -> Paths.get(p_129659_, new String[0])).collect(Collectors.toList());
            Collection existingPacks = optionset.valuesOf((OptionSpec)existing).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            HashSet existingMods = new HashSet(optionset.valuesOf((OptionSpec)existingMod));
            HashSet mods = new HashSet(optionset.valuesOf((OptionSpec)mod));
            boolean isFlat = mods.isEmpty() || optionset.has((OptionSpec)flat);
            DatagenModLoader.begin(mods, (Path)path, (Collection)inputs, (Collection)existingPacks, existingMods, (boolean)flag2, (boolean)flag1, (boolean)flag3, (boolean)flag4, (boolean)flag5, (boolean)isFlat, (String)((String)optionset.valueOf((OptionSpec)assetIndex)), (File)((File)optionset.valueOf((OptionSpec)assetsDir)));
            if (mods.contains("minecraft") || mods.isEmpty()) {
                Main.m_129660_(isFlat ? path : path.resolve("minecraft"), inputs, flag1, flag2, flag3, flag4, flag5).m_123917_();
            }
        } else {
            optionparser.printHelpOn((OutputStream)System.out);
        }
    }

    public static DataGenerator m_129660_(Path p_129661_, Collection<Path> p_129662_, boolean p_129663_, boolean p_129664_, boolean p_129665_, boolean p_129666_, boolean p_129667_) {
        DataGenerator datagenerator = new DataGenerator(p_129661_, p_129662_);
        if (p_129663_ || p_129664_) {
            datagenerator.m_123914_((DataProvider)new SnbtToNbt(datagenerator).m_126475_((SnbtToNbt.Filter)new StructureUpdater()));
        }
        if (p_129663_) {
            datagenerator.m_123914_((DataProvider)new ModelProvider(datagenerator));
        }
        if (p_129664_) {
            datagenerator.m_123914_(new FluidTagsProvider(datagenerator));
            BlockTagsProvider blocktagsprovider = new BlockTagsProvider(datagenerator);
            datagenerator.m_123914_(blocktagsprovider);
            datagenerator.m_123914_(new ItemTagsProvider(datagenerator, blocktagsprovider));
            datagenerator.m_123914_(new EntityTypeTagsProvider(datagenerator));
            datagenerator.m_123914_(new RecipeProvider(datagenerator));
            datagenerator.m_123914_(new AdvancementProvider(datagenerator));
            datagenerator.m_123914_(new LootTableProvider(datagenerator));
            datagenerator.m_123914_(new GameEventTagsProvider(datagenerator));
            datagenerator.m_123914_(new BiomeTagsProvider(datagenerator));
            datagenerator.m_123914_(new ConfiguredStructureTagsProvider(datagenerator));
        }
        if (p_129665_) {
            datagenerator.m_123914_((DataProvider)new NbtToSnbt(datagenerator));
        }
        if (p_129666_) {
            datagenerator.m_123914_((DataProvider)new BlockListReport(datagenerator));
            datagenerator.m_123914_((DataProvider)new RegistryDumpReport(datagenerator));
            datagenerator.m_123914_((DataProvider)new CommandsReport(datagenerator));
            datagenerator.m_123914_((DataProvider)new WorldgenRegistryDumpReport(datagenerator));
        }
        return datagenerator;
    }
}

