/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;

public class RecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson f_44005_ = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger f_44006_ = LogUtils.getLogger();
    private Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> f_44007_ = ImmutableMap.of();
    private Map<ResourceLocation, Recipe<?>> f_199900_ = ImmutableMap.of();
    private boolean f_44008_;
    private final ICondition.IContext context;

    @Deprecated
    public RecipeManager() {
        this(ICondition.IContext.EMPTY);
    }

    public RecipeManager(ICondition.IContext context) {
        super(f_44005_, "recipes");
        this.context = context;
    }

    protected void m_5787_(Map<ResourceLocation, JsonElement> p_44037_, ResourceManager p_44038_, ProfilerFiller p_44039_) {
        this.f_44008_ = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : p_44037_.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.m_135815_().startsWith("_")) continue;
            try {
                if (entry.getValue().isJsonObject() && !CraftingHelper.processConditions((JsonObject)entry.getValue().getAsJsonObject(), (String)"conditions", (ICondition.IContext)this.context)) {
                    f_44006_.debug("Skipping loading recipe {} as it's conditions were not met", (Object)resourcelocation);
                    continue;
                }
                Recipe<?> recipe = RecipeManager.fromJson(resourcelocation, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element"), this.context);
                if (recipe == null) {
                    f_44006_.info("Skipping loading recipe {} as it's serializer returned null", (Object)resourcelocation);
                    continue;
                }
                map.computeIfAbsent(recipe.m_6671_(), p_44075_ -> ImmutableMap.builder()).put((Object)resourcelocation, recipe);
                builder.put((Object)resourcelocation, recipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                f_44006_.error("Parsing error loading recipe {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        this.f_44007_ = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_44033_ -> ((ImmutableMap.Builder)p_44033_.getValue()).build()));
        this.f_199900_ = builder.build();
        f_44006_.info("Loaded {} recipes", (Object)map.size());
    }

    public boolean m_151269_() {
        return this.f_44008_;
    }

    public <C extends Container, T extends Recipe<C>> Optional<T> m_44015_(RecipeType<T> p_44016_, C p_44017_, Level p_44018_) {
        return this.m_44054_(p_44016_).values().stream().flatMap(p_44064_ -> p_44016_.m_44115_(p_44064_, p_44018_, p_44017_).stream()).findFirst();
    }

    public <C extends Container, T extends Recipe<C>> List<T> m_44013_(RecipeType<T> p_44014_) {
        return this.m_44054_(p_44014_).values().stream().map(p_44053_ -> p_44053_).collect(Collectors.toList());
    }

    public <C extends Container, T extends Recipe<C>> List<T> m_44056_(RecipeType<T> p_44057_, C p_44058_, Level p_44059_) {
        return this.m_44054_(p_44057_).values().stream().flatMap(p_44023_ -> p_44057_.m_44115_(p_44023_, p_44059_, p_44058_).stream()).sorted(Comparator.comparing(p_44012_ -> p_44012_.m_8043_().m_41778_())).collect(Collectors.toList());
    }

    private <C extends Container, T extends Recipe<C>> Map<ResourceLocation, Recipe<C>> m_44054_(RecipeType<T> p_44055_) {
        return this.f_44007_.getOrDefault(p_44055_, Collections.emptyMap());
    }

    public <C extends Container, T extends Recipe<C>> NonNullList<ItemStack> m_44069_(RecipeType<T> p_44070_, C p_44071_, Level p_44072_) {
        Optional<T> optional = this.m_44015_(p_44070_, p_44071_, p_44072_);
        if (optional.isPresent()) {
            return ((Recipe)optional.get()).m_7457_(p_44071_);
        }
        NonNullList nonnulllist = NonNullList.m_122780_((int)p_44071_.m_6643_(), (Object)((Object)ItemStack.f_41583_));
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)p_44071_.m_8020_(i));
        }
        return nonnulllist;
    }

    public Optional<? extends Recipe<?>> m_44043_(ResourceLocation p_44044_) {
        return Optional.ofNullable(this.f_199900_.get(p_44044_));
    }

    public Collection<Recipe<?>> m_44051_() {
        return this.f_44007_.values().stream().flatMap(p_199910_ -> p_199910_.values().stream()).collect(Collectors.toSet());
    }

    public Stream<ResourceLocation> m_44073_() {
        return this.f_44007_.values().stream().flatMap(p_199904_ -> p_199904_.keySet().stream());
    }

    @Deprecated
    public static Recipe<?> m_44045_(ResourceLocation p_44046_, JsonObject p_44047_) {
        return RecipeManager.fromJson(p_44046_, p_44047_, ICondition.IContext.EMPTY);
    }

    public static Recipe<?> fromJson(ResourceLocation p_44046_, JsonObject p_44047_, ICondition.IContext context) {
        String s = GsonHelper.m_13906_((JsonObject)p_44047_, (String)"type");
        return Registry.f_122865_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + s + "'")).fromJson(p_44046_, p_44047_, context);
    }

    public void m_44024_(Iterable<Recipe<?>> p_44025_) {
        this.f_44008_ = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        p_44025_.forEach(p_199908_ -> {
            Map map1 = map.computeIfAbsent(p_199908_.m_6671_(), p_199912_ -> Maps.newHashMap());
            ResourceLocation resourcelocation = p_199908_.m_6423_();
            Recipe recipe = map1.put(resourcelocation, p_199908_);
            builder.put((Object)resourcelocation, p_199908_);
            if (recipe != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + resourcelocation);
            }
        });
        this.f_44007_ = ImmutableMap.copyOf((Map)map);
        this.f_199900_ = builder.build();
    }
}

