/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.corelib.tag;

import de.maxhenkel.camera.corelib.tag.BlockTag;
import de.maxhenkel.camera.corelib.tag.FluidTag;
import de.maxhenkel.camera.corelib.tag.ItemTag;
import de.maxhenkel.camera.corelib.tag.SingleElementTag;
import de.maxhenkel.camera.corelib.tag.Tag;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;

public class TagUtils {
    public static Tag<Block> AIR_BLOCK_TAG = new SingleElementTag<Block>(Blocks.f_50016_.getRegistryName(), Blocks.f_50016_);
    public static Tag<Item> AIR_ITEM_TAG = new SingleElementTag<Item>(Items.f_41852_.getRegistryName(), Items.f_41852_);
    public static Tag<Fluid> AIR_FLUID_TAG = new SingleElementTag<Fluid>(Fluids.f_76191_.getRegistryName(), Fluids.f_76191_);

    @Nullable
    public static Tag<Block> getBlock(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = new ResourceLocation(name.substring(1));
            Registry blocks = ((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122901_);
            Optional tag = blocks.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)id));
            if (tag.isEmpty()) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_BLOCK_TAG;
            }
            return new BlockTag((HolderSet.Named<Block>)((HolderSet.Named)tag.get()));
        }
        ResourceLocation resourceLocation = new ResourceLocation(name);
        if (!ForgeRegistries.BLOCKS.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (block == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        return new SingleElementTag<Block>(resourceLocation, block);
    }

    public static Tag<Block> getBlock(String name) {
        return TagUtils.getBlock(name, false);
    }

    public static Tag<Block> getBlockTag(ResourceLocation name, boolean nullIfNotExists) {
        Registry blocks = ((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122901_);
        Optional tag = blocks.m_203431_(BlockTags.create((ResourceLocation)name));
        if (tag.isEmpty()) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        return new BlockTag((HolderSet.Named<Block>)((HolderSet.Named)tag.get()));
    }

    public static Tag<Block> getBlockTag(ResourceLocation name) {
        return TagUtils.getBlockTag(name, false);
    }

    @Nullable
    public static Tag<Item> getItem(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = new ResourceLocation(name.substring(1));
            Registry items = ((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122904_);
            Optional tag = items.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)id));
            if (tag.isEmpty()) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_ITEM_TAG;
            }
            return new ItemTag((HolderSet.Named<Item>)((HolderSet.Named)tag.get()));
        }
        ResourceLocation resourceLocation = new ResourceLocation(name);
        if (!ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        if (item == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        return new SingleElementTag<Item>(resourceLocation, item);
    }

    public static Tag<Item> getItem(String name) {
        return TagUtils.getItem(name, false);
    }

    public static Tag<Item> getItemTag(ResourceLocation name, boolean nullIfNotExists) {
        Registry blocks = ((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122904_);
        Optional tag = blocks.m_203431_(ItemTags.create((ResourceLocation)name));
        if (tag.isEmpty()) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        return new ItemTag((HolderSet.Named<Item>)((HolderSet.Named)tag.get()));
    }

    public static Tag<Item> getItemTag(ResourceLocation name) {
        return TagUtils.getItemTag(name, false);
    }

    @Nullable
    public static Tag<Fluid> getFluid(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = new ResourceLocation(name.substring(1));
            Registry items = ((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122899_);
            Optional tag = items.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)id));
            if (tag.isEmpty()) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_FLUID_TAG;
            }
            return new FluidTag((HolderSet.Named<Fluid>)((HolderSet.Named)tag.get()));
        }
        ResourceLocation resourceLocation = new ResourceLocation(name);
        if (!ForgeRegistries.FLUIDS.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(name));
        if (fluid == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        return new SingleElementTag<Fluid>(resourceLocation, fluid);
    }

    public static Tag<Fluid> getFluid(String name) {
        return TagUtils.getFluid(name, false);
    }

    public static Tag<Fluid> getFluidTag(ResourceLocation name, boolean nullIfNotExists) {
        Registry blocks = ((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122899_);
        Optional tag = blocks.m_203431_(FluidTags.create((ResourceLocation)name));
        if (tag.isEmpty()) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        return new FluidTag((HolderSet.Named<Fluid>)((HolderSet.Named)tag.get()));
    }

    public static Tag<Fluid> getFluidTag(ResourceLocation name) {
        return TagUtils.getFluidTag(name, false);
    }
}

