/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester.status;

import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.ticking.TickRateModulation;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.status.LinkState;
import com.almostreliable.merequester.requester.status.RequestStatus;
import com.almostreliable.merequester.requester.status.StatusState;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class PlanState
implements StatusState {
    private final Future<? extends ICraftingPlan> future;

    PlanState(Future<? extends ICraftingPlan> future) {
        this.future = future;
    }

    @Override
    public StatusState handle(RequesterBlockEntity host, int index) {
        if (!this.future.isDone()) {
            return this;
        }
        if (this.future.isCancelled()) {
            return StatusState.IDLE;
        }
        try {
            ICraftingPlan plan = this.future.get();
            ICraftingLink link = host.getMainNodeGrid().getCraftingService().submitJob(plan, (ICraftingRequester)host, null, false, host.getActionSource());
            if (link == null) {
                return StatusState.IDLE;
            }
            return new LinkState(Objects.requireNonNull(link));
        }
        catch (InterruptedException | ExecutionException e) {
            return StatusState.IDLE;
        }
    }

    @Override
    public RequestStatus type() {
        return RequestStatus.PLAN;
    }

    @Override
    public TickRateModulation getTickRateModulation() {
        return this.future.isDone() && !this.future.isCancelled() ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }
}

