/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.container;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import shadows.placebo.container.IDataUpdateListener;
import shadows.placebo.container.QuickMoveHandler;

public abstract class PlaceboContainerMenu
extends AbstractContainerMenu
implements QuickMoveHandler.IExposedContainer {
    protected final Level level;
    protected final QuickMoveHandler mover = new QuickMoveHandler();
    protected final List<Int2IntFunction> syncTransformers = new ArrayList<Int2IntFunction>();
    protected IDataUpdateListener updateListener;
    protected int playerInvStart = -1;
    protected int hotbarStart = -1;

    protected PlaceboContainerMenu(MenuType<?> type, int id, Inventory pInv) {
        super(type, id);
        this.level = pInv.f_35978_.f_19853_;
    }

    protected void addPlayerSlots(Inventory pInv, int x, int y) {
        int row;
        this.playerInvStart = this.f_38839_.size();
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)pInv, column + row * 9 + 9, x + column * 18, y + row * 18));
            }
        }
        this.hotbarStart = this.f_38839_.size();
        for (row = 0; row < 9; ++row) {
            this.m_38897_(new Slot((Container)pInv, row, x + row * 18, y + 58));
        }
    }

    protected void registerInvShuffleRules() {
        if (this.hotbarStart == -1 || this.playerInvStart == -1) {
            throw new UnsupportedOperationException("Attempted to register inv shuffle rules with no player inv slots.");
        }
        this.mover.registerRule((stack, slot) -> slot >= this.hotbarStart, this.playerInvStart, this.hotbarStart);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart, this.hotbarStart, this.f_38839_.size());
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return this.mover.quickMoveStack(this, pPlayer, pIndex);
    }

    public boolean m_38903_(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        return super.m_38903_(pStack, pStartIndex, pEndIndex, pReverseDirection);
    }

    public void setDataListener(IDataUpdateListener listener) {
        this.updateListener = listener;
    }

    public void m_7511_(int pId, int pData) {
        super.m_7511_(pId, pData);
        if (this.updateListener != null) {
            this.updateListener.dataUpdated(pId, pData);
        }
    }

    protected DataSlot m_38895_(DataSlot slot) {
        if (slot instanceof Int2IntFunction) {
            Int2IntFunction fun = (Int2IntFunction)slot;
            this.syncTransformers.add(fun);
        } else {
            this.syncTransformers.add(Int2IntFunction.identity());
        }
        return super.m_38895_(slot);
    }

    public void m_150440_(int slotId, int value) {
        int i;
        if (!this.f_150398_ && (i = this.f_150395_.getInt(slotId)) != value) {
            this.f_150395_.set(slotId, value);
            if (this.f_150397_ != null) {
                this.f_150397_.m_142145_((AbstractContainerMenu)this, slotId, this.syncTransformers.get(slotId).applyAsInt(value));
            }
        }
    }
}

