/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.Placebo;
import shadows.placebo.util.RunnableReloader;

public class RecipeHelper {
    private static final List<Recipe<?>> recipes = new ArrayList();
    protected String modid;
    protected Set<String> names = new HashSet<String>();

    public RecipeHelper(String modid) {
        this.modid = modid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecipe(Recipe<?> rec) {
        List<Recipe<?>> list = recipes;
        synchronized (list) {
            if (rec == null) {
                Placebo.LOGGER.error("Attempted to add null recipe, this is invalid behavior.");
                Thread.dumpStack();
            }
            recipes.add(rec);
        }
    }

    public void addShapeless(Object output, Object ... inputs) {
        ItemStack out = RecipeHelper.makeStack(output);
        RecipeHelper.addRecipe(new ShapelessRecipe(this.name(out), this.modid, out, this.createInput(false, inputs)));
    }

    public void addShaped(Object output, int width, int height, Object ... input) {
        RecipeHelper.addRecipe(this.genShaped(RecipeHelper.makeStack(output), width, height, input));
    }

    public ShapedRecipe genShaped(ItemStack output, int l, int w, Object ... input) {
        if (l * w != input.length) {
            throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.  Complain to the author of " + this.modid);
        }
        return new ShapedRecipe(this.name(output), this.modid, l, w, this.createInput(true, input), output);
    }

    public NonNullList<Ingredient> createInput(boolean allowEmpty, Object ... input) {
        NonNullList inputL = NonNullList.m_122779_();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation((String)k))));
                continue;
            }
            if (k instanceof ItemStack && !((ItemStack)k).m_41619_()) {
                inputL.add(i, (Object)CachedIngredient.create((ItemStack)k));
                continue;
            }
            if (k instanceof IForgeRegistryEntry) {
                inputL.add(i, (Object)CachedIngredient.create(RecipeHelper.makeStack(k)));
                continue;
            }
            if (k instanceof Ingredient) {
                inputL.add(i, (Object)((Ingredient)k));
                continue;
            }
            if (allowEmpty) {
                inputL.add(i, (Object)Ingredient.f_43901_);
                continue;
            }
            throw new UnsupportedOperationException("Attempted to add invalid recipe.  Complain to the author of " + this.modid + ". (Input " + k + " not allowed.)");
        }
        return inputL;
    }

    public void addSimpleShapeless(Object output, Object input, int numInputs) {
        this.addShapeless(output, NonNullList.m_122780_((int)numInputs, (Object)RecipeHelper.makeStack(input)).toArray(new Object[0]));
    }

    private ResourceLocation name(ItemStack out) {
        Object name = out.m_41720_().getRegistryName().m_135815_();
        while (this.names.contains(name)) {
            name = (String)name + "_";
        }
        this.names.add((String)name);
        return new ResourceLocation(this.modid, (String)name);
    }

    public static ItemStack makeStack(Object thing, int size) {
        if (thing instanceof ItemStack) {
            return (ItemStack)thing;
        }
        if (thing instanceof Item) {
            return new ItemStack((ItemLike)((Item)thing), size);
        }
        if (thing instanceof Block) {
            return new ItemStack((ItemLike)((Block)thing), size);
        }
        throw new IllegalArgumentException("Attempted to create an ItemStack from something that cannot be converted: " + thing);
    }

    public static ItemStack makeStack(Object thing) {
        return RecipeHelper.makeStack(thing, 1);
    }

    static void addRecipes(RecipeManager mgr) {
        recipes.forEach(r -> {
            Map map = mgr.f_44007_.computeIfAbsent(r.m_6671_(), t -> new HashMap());
            Recipe old = (Recipe)map.get(r.m_6423_());
            if (old == null) {
                map.put(r.m_6423_(), r);
            } else {
                Placebo.LOGGER.debug("Skipping registration for code recipe {} as a json recipe already exists with that ID.", (Object)r.m_6423_());
            }
        });
        Placebo.LOGGER.info("Registered {} additional recipes.", (Object)recipes.size());
    }

    public static void mutableManager(RecipeManager mgr) {
        mgr.f_44007_ = new HashMap(mgr.f_44007_);
        for (RecipeType type : mgr.f_44007_.keySet()) {
            mgr.f_44007_.put(type, new HashMap((Map)mgr.f_44007_.get(type)));
        }
    }

    public static void reload(RecipeManager mgr, ReloadableResourceManager rel) {
        rel.m_7217_((PreparableReloadListener)RunnableReloader.of(() -> {
            RecipeHelper.mutableManager(mgr);
            RecipeHelper.addRecipes(mgr);
        }));
    }

    public static class CachedIngredient
    extends Ingredient {
        private static Int2ObjectMap<CachedIngredient> ingredients = new Int2ObjectOpenHashMap();

        private CachedIngredient(ItemStack ... matches) {
            super(Arrays.stream(matches).map(Ingredient.ItemValue::new));
            if (matches.length == 1) {
                ingredients.put(StackedContents.m_36496_((ItemStack)matches[0]), (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CachedIngredient create(ItemStack ... matches) {
            Int2ObjectMap<CachedIngredient> int2ObjectMap = ingredients;
            synchronized (int2ObjectMap) {
                if (matches.length == 1) {
                    CachedIngredient coi = (CachedIngredient)((Object)ingredients.get(StackedContents.m_36496_((ItemStack)matches[0])));
                    CachedIngredient cachedIngredient = coi != null ? coi : new CachedIngredient(matches);
                    return cachedIngredient;
                }
                return new CachedIngredient(matches);
            }
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return VanillaIngredientSerializer.INSTANCE;
        }
    }
}

