/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network;

import com.hrznstudio.titanium.network.Message;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private SimpleChannel network;
    private int i = 0;

    public NetworkHandler(String modid) {
        this.network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modid, "network"), () -> "1.0", s -> true, s -> true);
    }

    public SimpleChannel get() {
        return this.network;
    }

    public <REQ extends Message> void registerMessage(Class<REQ> message) {
        this.network.registerMessage(this.i++, message, Message::toBytes, buffer -> {
            try {
                Message req = (Message)message.getConstructor(new Class[0]).newInstance(new Object[0]);
                req.fromBytes((FriendlyByteBuf)buffer);
                return req;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, (req, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            req.handleMessage(context);
            context.setPacketHandled(true);
        });
    }

    public void sendToNearby(Level world, BlockPos pos, int distance, Message message) {
        world.m_45976_(ServerPlayer.class, new AABB(pos).m_82400_((double)distance)).forEach(playerEntity -> this.network.sendTo((Object)message, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }
}

