/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.shapelessenchant;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ShapelessEnchantSerializer
extends ShapelessRecipe.Serializer {
    @Nonnull
    public ShapelessRecipe m_6729_(@Nonnull ResourceLocation recipeId, JsonObject json) {
        HashMap enchantmentLevelMap;
        String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> ingredients = ShapelessEnchantSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        JsonObject jsonObject = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)jsonObject);
        if (jsonObject.has("enchantments")) {
            JsonElement enchantments = jsonObject.get("enchantments");
            enchantmentLevelMap = Maps.newHashMap();
            if (enchantments.isJsonArray()) {
                for (JsonElement jsonElement : enchantments.getAsJsonArray()) {
                    if (!jsonElement.isJsonObject()) continue;
                    Pair<Enchantment, Integer> enchantmentLevelPair = ShapelessEnchantSerializer.parseJson(jsonElement.getAsJsonObject());
                    enchantmentLevelMap.put((Enchantment)enchantmentLevelPair.getKey(), (Integer)enchantmentLevelPair.getValue());
                }
            } else if (enchantments.isJsonObject()) {
                Pair<Enchantment, Integer> enchantmentLevelPair = ShapelessEnchantSerializer.parseJson(enchantments.getAsJsonObject());
                enchantmentLevelMap.put((Enchantment)enchantmentLevelPair.getKey(), (Integer)enchantmentLevelPair.getValue());
            }
        } else {
            throw new JsonParseException("No String or Array found for enchantments");
        }
        EnchantmentHelper.m_44865_((Map)enchantmentLevelMap, (ItemStack)itemstack);
        return new ShapelessRecipe(recipeId, s, itemstack, ingredients);
    }

    private static Pair<Enchantment, Integer> parseJson(JsonObject jsonObject) {
        String name = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"name");
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(name));
        if (enchantment == null) {
            throw new JsonParseException("Failed to find enchantment named: " + name);
        }
        return Pair.of((Object)enchantment, (Object)GsonHelper.m_13824_((JsonObject)jsonObject, (String)"level", (int)1));
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < ingredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }
}

