/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.handler;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.gui.entry.ExperienceDisplayEntry;
import fuzs.pickupnotifier.client.gui.entry.ItemDisplayEntry;
import fuzs.pickupnotifier.client.handler.DrawEntriesHandler;
import fuzs.pickupnotifier.config.ClientConfig;
import fuzs.pickupnotifier.config.ItemBlacklistManager;
import fuzs.pickupnotifier.mixin.client.accessor.AbstractArrowAccessor;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;

public class AddEntriesHandler {
    public static void onEntityPickup(int itemId, int playerId, int amount) {
        if (Minecraft.m_91087_().f_91073_.m_6815_(playerId) instanceof LocalPlayer && !DrawEntriesHandler.HANDLED_ENTITIES.containsKey(itemId)) {
            AddEntriesHandler.onEntityPickup(itemId, amount);
        }
    }

    public static void addPickUpEntry(int itemId, int amount) {
        if (!((ClientConfig)PickUpNotifier.CONFIG.client()).general().forceClient) {
            DrawEntriesHandler.HANDLED_ENTITIES.put(itemId, (Object)new MutableInt());
            AddEntriesHandler.onEntityPickup(itemId, amount);
        }
    }

    public static void addItemEntry(ItemStack stack) {
        if (!((ClientConfig)PickUpNotifier.CONFIG.client()).general().forceClient && ((ClientConfig)PickUpNotifier.CONFIG.client()).general().logItems) {
            AddEntriesHandler.addItemEntry(stack, stack.m_41613_());
        }
    }

    private static void onEntityPickup(int itemId, int amount) {
        Entity pickedEntity = Minecraft.m_91087_().f_91073_.m_6815_(itemId);
        if (pickedEntity instanceof ItemEntity) {
            if (((ClientConfig)PickUpNotifier.CONFIG.client()).general().logItems) {
                AddEntriesHandler.addItemEntry(((ItemEntity)pickedEntity).m_32055_(), amount);
            }
        } else if (pickedEntity instanceof AbstractArrow) {
            if (((ClientConfig)PickUpNotifier.CONFIG.client()).general().logArrows) {
                AddEntriesHandler.addItemEntry(((AbstractArrowAccessor)pickedEntity).callGetPickupItem(), amount);
            }
        } else if (pickedEntity instanceof ExperienceOrb && ((ClientConfig)PickUpNotifier.CONFIG.client()).general().logExperience) {
            AddEntriesHandler.addExperienceEntry((ExperienceOrb)pickedEntity, amount);
        }
    }

    private static void addItemEntry(ItemStack stack, int amount) {
        if (!stack.m_41619_() && ItemBlacklistManager.isItemAllowed((ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_(), stack.m_41720_())) {
            stack = stack.m_41777_();
            stack.m_41749_("Enchantments");
            AddEntriesHandler.addEntry(new ItemDisplayEntry(stack, amount));
        }
    }

    private static void addExperienceEntry(ExperienceOrb orb, int amount) {
        if (orb.m_20801_() > 0) {
            AddEntriesHandler.addEntry(new ExperienceDisplayEntry(orb.m_7755_(), amount));
        }
    }

    private static void addEntry(DisplayEntry newEntry) {
        Optional possibleDuplicate;
        int scaledHeight = (int)((float)Minecraft.m_91087_().m_91268_().m_85446_() / ((float)((ClientConfig)PickUpNotifier.CONFIG.client()).display().scale / 6.0f));
        int maxSize = (int)((double)scaledHeight * ((ClientConfig)PickUpNotifier.CONFIG.client()).display().height / 18.0) - 1;
        Optional<Object> optional = possibleDuplicate = ((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().combineEntries ? DrawEntriesHandler.PICK_UPS.findDuplicate(newEntry) : Optional.empty();
        if (possibleDuplicate.isPresent()) {
            DisplayEntry duplicate = (DisplayEntry)possibleDuplicate.get();
            duplicate.mergeWith(newEntry);
            DrawEntriesHandler.PICK_UPS.refresh(duplicate);
        } else {
            DrawEntriesHandler.PICK_UPS.add(newEntry, maxSize);
        }
    }
}

